/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.jarhandling.impl;

import java.security.CodeSigner;
import java.util.Locale;
import java.util.Map;
import java.util.jar.JarInputStream;
import net.minecraftforge.unsafe.UnsafeFieldAccess;
import net.minecraftforge.unsafe.UnsafeHacks;

public class SecureJarVerifier {
    private static final char[] LOOKUP = "0123456789abcdef".toCharArray();
    private static final Class<Object> JV_TYPE = SecureJarVerifier.getJVType();
    private static final UnsafeFieldAccess<JarInputStream, Object> jarVerifier = UnsafeHacks.findField(JarInputStream.class, "jv");
    private static final UnsafeFieldAccess<Object, Map<String, CodeSigner[]>> sigFileSigners = UnsafeHacks.findField(JV_TYPE, "sigFileSigners");
    private static final UnsafeFieldAccess<Object, Map<String, CodeSigner[]>> verifiedSigners = UnsafeHacks.findField(JV_TYPE, "verifiedSigners");
    private static final UnsafeFieldAccess.Bool<Object> parsingMeta = UnsafeHacks.findBooleanField(JV_TYPE, "parsingMeta");
    private static final UnsafeFieldAccess.Bool<Object> anyToVerify = UnsafeHacks.findBooleanField(JV_TYPE, "anyToVerify");

    public static String toHexString(byte[] bytes) {
        StringBuffer buffer = new StringBuffer(2 * bytes.length);
        int bytesLength = bytes.length;
        for (int i = 0; i < bytesLength; ++i) {
            int aByte = bytes[i] & 0xFF;
            buffer.append(LOOKUP[(aByte & 0xF0) >> 4]);
            buffer.append(LOOKUP[aByte & 0xF]);
        }
        return buffer.toString();
    }

    public static boolean isSigningRelated(String path) {
        String filename = path.toLowerCase(Locale.ENGLISH);
        if (!filename.startsWith("meta-inf/")) {
            return false;
        }
        if ((filename = filename.substring(9)).indexOf(47) != -1) {
            return false;
        }
        if ("manifest.mf".equals(filename) || filename.endsWith(".sf") || filename.endsWith(".dsa") || filename.endsWith(".rsa")) {
            return true;
        }
        if (!filename.startsWith("sig-")) {
            return false;
        }
        int ext = filename.lastIndexOf(46);
        if (ext == -1) {
            return true;
        }
        if (ext < filename.length() - 4) {
            return false;
        }
        for (int x = ext + 1; x < filename.length(); ++x) {
            char c = filename.charAt(x);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    @Deprecated(forRemoval=true)
    public static Object getJarVerifier(Object inst) {
        return SecureJarVerifier.getJarVerifier((JarInputStream)inst);
    }

    public static Object getJarVerifier(JarInputStream inst) {
        return jarVerifier.get(inst);
    }

    public static boolean isParsingMeta(Object inst) {
        return parsingMeta.getBoolean(inst);
    }

    public static boolean hasSignatures(Object inst) {
        return anyToVerify.getBoolean(inst);
    }

    public static Map<String, CodeSigner[]> getVerifiedSigners(Object inst) {
        return verifiedSigners.get(inst);
    }

    public static Map<String, CodeSigner[]> getPendingSigners(Object inst) {
        return sigFileSigners.get(inst);
    }

    private static Class<Object> getJVType() {
        try {
            return JarInputStream.class.getDeclaredField("jv").getType();
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to get JarInputStream's jv field, this should never be possible, be sure to report this will exact details on what JVM you're running.", e);
        }
    }
}

