/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.vanilla.installer.model;

import java.nio.file.Path;
import org.checkerframework.checker.nullness.qual.Nullable;

public record GroupArtifactVersion(String group, String artifact, @Nullable String version, @Nullable String classifier) {
    public static GroupArtifactVersion parse(String notation) {
        String[] split = notation.split(":");
        if (split.length > 4 || split.length < 2) {
            throw new IllegalArgumentException("Unsupported notation '" + notation + "', must be in the format of group:artifact[:version[:classifier]]");
        }
        return new GroupArtifactVersion(split[0], split[1], split.length > 2 ? split[2] : null, split.length > 3 ? split[3] : null);
    }

    public Path resolve(Path base) {
        Path artifact = base.resolve(this.group.replace('.', '/')).resolve(this.artifact);
        return this.version == null ? artifact : artifact.resolve(this.version);
    }

    @Override
    public String toString() {
        return this.group() + ":" + this.artifact() + (String)(this.version() == null ? "" : ":" + this.version()) + (String)(this.classifier == null ? "" : ":" + this.classifier());
    }
}

