/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.netty;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.ReferenceCountUtil;
import java.util.ArrayDeque;
import java.util.Queue;

public class AutoReadHolderHandler
extends ChannelDuplexHandler {
    private final Queue<Object> queuedMessages = new ArrayDeque<Object>();

    @Override
    public void read(ChannelHandlerContext ctx) throws Exception {
        this.drainQueuedMessages(ctx);
        ctx.read();
    }

    private void drainQueuedMessages(ChannelHandlerContext ctx) {
        if (!this.queuedMessages.isEmpty()) {
            Object queued;
            while ((queued = this.queuedMessages.poll()) != null) {
                ctx.fireChannelRead(queued);
            }
            ctx.fireChannelReadComplete();
        }
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (ctx.channel().config().isAutoRead()) {
            ctx.fireChannelRead(msg);
        } else {
            this.queuedMessages.add(msg);
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().config().isAutoRead()) {
            if (!this.queuedMessages.isEmpty()) {
                this.drainQueuedMessages(ctx);
            } else {
                ctx.fireChannelReadComplete();
            }
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        for (Object e : this.queuedMessages) {
            ReferenceCountUtil.release(e);
        }
        this.queuedMessages.clear();
    }
}

