/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.player;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.Optional;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class KickedFromServerEvent
implements ResultedEvent<ServerKickResult> {
    private final Player player;
    private final RegisteredServer server;
    private final @Nullable Component originalReason;
    private final boolean duringServerConnect;
    private ServerKickResult result;

    public KickedFromServerEvent(Player player, RegisteredServer server, @Nullable Component originalReason, boolean duringServerConnect, ServerKickResult result) {
        this.player = Preconditions.checkNotNull(player, "player");
        this.server = Preconditions.checkNotNull(server, "server");
        this.originalReason = originalReason;
        this.duringServerConnect = duringServerConnect;
        this.result = Preconditions.checkNotNull(result, "result");
    }

    @Override
    public ServerKickResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(@NonNull ServerKickResult result) {
        this.result = Preconditions.checkNotNull(result, "result");
    }

    public Player getPlayer() {
        return this.player;
    }

    public RegisteredServer getServer() {
        return this.server;
    }

    public Optional<Component> getServerKickReason() {
        return Optional.ofNullable(this.originalReason);
    }

    public boolean kickedDuringServerConnect() {
        return this.duringServerConnect;
    }

    @Deprecated
    public boolean kickedDuringLogin() {
        return this.duringServerConnect;
    }

    public static final class Notify
    implements ServerKickResult {
        private final Component message;

        private Notify(Component message) {
            this.message = Preconditions.checkNotNull(message, "message");
        }

        @Override
        public boolean isAllowed() {
            return false;
        }

        public Component getMessageComponent() {
            return this.message;
        }

        public static Notify create(Component message) {
            return new Notify(message);
        }
    }

    public static final class RedirectPlayer
    implements ServerKickResult {
        private final Component message;
        private final RegisteredServer server;

        private RedirectPlayer(RegisteredServer server, @Nullable Component message) {
            this.server = Preconditions.checkNotNull(server, "server");
            this.message = message;
        }

        @Override
        public boolean isAllowed() {
            return false;
        }

        public RegisteredServer getServer() {
            return this.server;
        }

        public @Nullable Component getMessageComponent() {
            return this.message;
        }

        public static RedirectPlayer create(RegisteredServer server, Component message) {
            return new RedirectPlayer(server, message);
        }

        public static ServerKickResult create(RegisteredServer server) {
            return new RedirectPlayer(server, null);
        }
    }

    public static final class DisconnectPlayer
    implements ServerKickResult {
        private final Component component;

        private DisconnectPlayer(Component component) {
            this.component = Preconditions.checkNotNull(component, "component");
        }

        @Override
        public boolean isAllowed() {
            return true;
        }

        public Component getReasonComponent() {
            return this.component;
        }

        public static DisconnectPlayer create(Component reason) {
            return new DisconnectPlayer(reason);
        }
    }

    public static interface ServerKickResult
    extends ResultedEvent.Result {
    }
}

