/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.ArgumentCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.brigadier.ArgumentPropertyRegistry;
import com.velocitypowered.proxy.util.collect.IdentityHashStrategy;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AvailableCommands
implements MinecraftPacket {
    private static final Command<CommandSource> PLACEHOLDER_COMMAND = source -> 0;
    private static final byte NODE_TYPE_ROOT = 0;
    private static final byte NODE_TYPE_LITERAL = 1;
    private static final byte NODE_TYPE_ARGUMENT = 2;
    private static final byte FLAG_NODE_TYPE = 3;
    private static final byte FLAG_EXECUTABLE = 4;
    private static final byte FLAG_IS_REDIRECT = 8;
    private static final byte FLAG_HAS_SUGGESTIONS = 16;
    private @MonotonicNonNull RootCommandNode<CommandSource> rootNode;

    public RootCommandNode<CommandSource> getRootNode() {
        if (this.rootNode == null) {
            throw new IllegalStateException("Packet not yet deserialized");
        }
        return this.rootNode;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        int commands = ProtocolUtils.readVarInt(buf);
        WireNode[] wireNodes = new WireNode[commands];
        for (int i = 0; i < commands; ++i) {
            wireNodes[i] = AvailableCommands.deserializeNode(buf, i);
        }
        ArrayDeque<WireNode> nodeQueue = new ArrayDeque<WireNode>(Arrays.asList(wireNodes));
        while (!nodeQueue.isEmpty()) {
            boolean cycling = false;
            Iterator it = nodeQueue.iterator();
            while (it.hasNext()) {
                WireNode node = (WireNode)it.next();
                if (!node.toNode(wireNodes)) continue;
                cycling = true;
                it.remove();
            }
            if (cycling) continue;
            throw new IllegalStateException("Stopped cycling; the root node can't be built.");
        }
        int rootIdx = ProtocolUtils.readVarInt(buf);
        this.rootNode = (RootCommandNode)wireNodes[rootIdx].built;
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        ArrayDeque<RootCommandNode<CommandSource>> childrenQueue = new ArrayDeque<RootCommandNode<CommandSource>>(ImmutableList.of(this.rootNode));
        Object2IntLinkedOpenCustomHashMap<CommandNode<CommandSource>> idMappings = new Object2IntLinkedOpenCustomHashMap<CommandNode<CommandSource>>(IdentityHashStrategy.instance());
        while (!childrenQueue.isEmpty()) {
            CommandNode child = (CommandNode)childrenQueue.poll();
            if (idMappings.containsKey(child)) continue;
            idMappings.put((CommandNode<CommandSource>)child, idMappings.size());
            childrenQueue.addAll(child.getChildren());
            if (child.getRedirect() == null) continue;
            childrenQueue.add((RootCommandNode<CommandSource>)child.getRedirect());
        }
        ProtocolUtils.writeVarInt(buf, idMappings.size());
        for (CommandNode child : idMappings.keySet()) {
            AvailableCommands.serializeNode(child, buf, idMappings);
        }
        ProtocolUtils.writeVarInt(buf, idMappings.getInt(this.rootNode));
    }

    private static void serializeNode(CommandNode<CommandSource> node, ByteBuf buf, Object2IntMap<CommandNode<CommandSource>> idMappings) {
        int flags = 0;
        if (node.getRedirect() != null) {
            flags = (byte)(flags | 8);
        }
        if (node.getCommand() != null) {
            flags = (byte)(flags | 4);
        }
        if (node instanceof LiteralCommandNode) {
            flags = (byte)(flags | 1);
        } else if (node instanceof ArgumentCommandNode) {
            flags = (byte)(flags | 2);
            if (((ArgumentCommandNode)node).getCustomSuggestions() != null) {
                flags = (byte)(flags | 0x10);
            }
        } else if (!(node instanceof RootCommandNode)) {
            throw new IllegalArgumentException("Unknown node type " + node.getClass().getName());
        }
        buf.writeByte(flags);
        ProtocolUtils.writeVarInt(buf, node.getChildren().size());
        for (CommandNode<CommandSource> child : node.getChildren()) {
            ProtocolUtils.writeVarInt(buf, idMappings.getInt(child));
        }
        if (node.getRedirect() != null) {
            ProtocolUtils.writeVarInt(buf, idMappings.getInt(node.getRedirect()));
        }
        if (node instanceof ArgumentCommandNode) {
            ProtocolUtils.writeString(buf, node.getName());
            ArgumentPropertyRegistry.serialize(buf, ((ArgumentCommandNode)node).getType());
            if (((ArgumentCommandNode)node).getCustomSuggestions() != null) {
                SuggestionProvider provider = ((ArgumentCommandNode)node).getCustomSuggestions();
                String name = "minecraft:ask_server";
                if (provider instanceof ProtocolSuggestionProvider) {
                    name = ((ProtocolSuggestionProvider)provider).name;
                }
                ProtocolUtils.writeString(buf, name);
            }
        } else if (node instanceof LiteralCommandNode) {
            ProtocolUtils.writeString(buf, node.getName());
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    private static WireNode deserializeNode(ByteBuf buf, int idx) {
        byte flags = buf.readByte();
        int[] children = ProtocolUtils.readIntegerArray(buf);
        int redirectTo = -1;
        if ((flags & 8) > 0) {
            redirectTo = ProtocolUtils.readVarInt(buf);
        }
        switch (flags & 3) {
            case 0: {
                return new WireNode(idx, flags, children, redirectTo, null);
            }
            case 1: {
                return new WireNode(idx, flags, children, redirectTo, LiteralArgumentBuilder.literal(ProtocolUtils.readString(buf)));
            }
            case 2: {
                String name = ProtocolUtils.readString(buf);
                ArgumentType<?> argumentType = ArgumentPropertyRegistry.deserialize(buf);
                RequiredArgumentBuilder<CommandSource, ?> argumentBuilder = RequiredArgumentBuilder.argument(name, argumentType);
                if ((flags & 0x10) != 0) {
                    argumentBuilder.suggests(new ProtocolSuggestionProvider(ProtocolUtils.readString(buf)));
                }
                return new WireNode(idx, flags, children, redirectTo, argumentBuilder);
            }
        }
        throw new IllegalArgumentException("Unknown node type " + (flags & 3));
    }

    public static class ProtocolSuggestionProvider
    implements SuggestionProvider<CommandSource> {
        private final String name;

        public ProtocolSuggestionProvider(String name) {
            this.name = name;
        }

        @Override
        public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSource> context, SuggestionsBuilder builder) throws CommandSyntaxException {
            return builder.buildFuture();
        }
    }

    private static class WireNode {
        private final int idx;
        private final byte flags;
        private final int[] children;
        private final int redirectTo;
        private final @Nullable ArgumentBuilder<CommandSource, ?> args;
        private @MonotonicNonNull CommandNode<CommandSource> built;
        private boolean validated;

        private WireNode(int idx, byte flags, int[] children, int redirectTo, @Nullable ArgumentBuilder<CommandSource, ?> args) {
            this.idx = idx;
            this.flags = flags;
            this.children = children;
            this.redirectTo = redirectTo;
            this.args = args;
            this.validated = false;
        }

        void validate(WireNode[] wireNodes) {
            for (int child : this.children) {
                if (child >= 0 && child < wireNodes.length) continue;
                throw new IllegalStateException("Node points to non-existent index " + child);
            }
            if (this.redirectTo != -1 && (this.redirectTo < 0 || this.redirectTo >= wireNodes.length)) {
                throw new IllegalStateException("Redirect node points to non-existent index " + this.redirectTo);
            }
            this.validated = true;
        }

        boolean toNode(WireNode[] wireNodes) {
            if (!this.validated) {
                this.validate(wireNodes);
            }
            if (this.built == null) {
                int type = this.flags & 3;
                if (type == 0) {
                    this.built = new RootCommandNode<CommandSource>();
                } else {
                    if (this.args == null) {
                        throw new IllegalStateException("Non-root node without args builder!");
                    }
                    if (this.redirectTo != -1) {
                        WireNode redirect = wireNodes[this.redirectTo];
                        if (redirect.built != null) {
                            this.args.redirect(redirect.built);
                        } else {
                            return false;
                        }
                    }
                    if ((this.flags & 4) != 0) {
                        this.args.executes(PLACEHOLDER_COMMAND);
                    }
                    this.built = this.args.build();
                }
            }
            for (int child : this.children) {
                if (wireNodes[child].built != null) continue;
                return false;
            }
            for (int child : this.children) {
                CommandNode<CommandSource> childNode = wireNodes[child].built;
                if (childNode instanceof RootCommandNode) continue;
                this.built.addChild(childNode);
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper(this).add("idx", this.idx).add("flags", this.flags).add("children", this.children).add("redirectTo", this.redirectTo);
            if (this.args != null) {
                if (this.args instanceof LiteralArgumentBuilder) {
                    helper.add("argsLabel", ((LiteralArgumentBuilder)this.args).getLiteral());
                } else if (this.args instanceof RequiredArgumentBuilder) {
                    helper.add("argsName", ((RequiredArgumentBuilder)this.args).getName());
                }
            }
            return helper.toString();
        }
    }
}

