/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.proxy.command.brigadier.VelocityArgumentCommandNode;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class VelocityCommands {
    public static final String ARGS_NODE_NAME = "arguments";

    static String normalizeInput(String input, boolean trim) {
        String command = trim ? input.trim() : input;
        int firstSep = command.indexOf(32);
        if (firstSep != -1) {
            return command.substring(0, firstSep).toLowerCase(Locale.ENGLISH) + command.substring(firstSep);
        }
        return command.toLowerCase(Locale.ENGLISH);
    }

    public static String readAlias(List<? extends ParsedCommandNode<?>> nodes) {
        if (nodes.isEmpty()) {
            throw new IllegalArgumentException("Cannot read alias from empty node list");
        }
        return nodes.get(0).getNode().getName();
    }

    public static <V> V readArguments(Map<String, ? extends ParsedArgument<?, ?>> arguments, Class<V> type, V fallback) {
        ParsedArgument<?, ?> argument = arguments.get(ARGS_NODE_NAME);
        if (argument == null) {
            return fallback;
        }
        Object result = argument.getResult();
        try {
            return type.cast(result);
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("Parsed argument is of type " + result.getClass() + ", expected " + type, e);
        }
    }

    public static boolean isValidAlias(String alias) {
        return alias.equals(alias.toLowerCase(Locale.ENGLISH));
    }

    public static LiteralCommandNode<CommandSource> shallowCopy(LiteralCommandNode<CommandSource> original, String newName) {
        Preconditions.checkNotNull(original, "original");
        Preconditions.checkNotNull(newName, "secondaryAlias");
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal(newName).requires(original.getRequirement())).requiresWithContext(original.getContextRequirement())).forward(original.getRedirect(), original.getRedirectModifier(), original.isFork())).executes(original.getCommand());
        for (CommandNode child : original.getChildren()) {
            builder.then(child);
        }
        return builder.build();
    }

    static <S> @Nullable VelocityArgumentCommandNode<S, ?> getArgumentsNode(LiteralCommandNode<S> alias) {
        CommandNode node = alias.getChild(ARGS_NODE_NAME);
        if (node instanceof VelocityArgumentCommandNode) {
            return (VelocityArgumentCommandNode)node;
        }
        return null;
    }

    public static boolean isArgumentsNode(CommandNode<?> node) {
        return node instanceof VelocityArgumentCommandNode && node.getName().equals(ARGS_NODE_NAME);
    }

    private VelocityCommands() {
        throw new AssertionError();
    }
}

