/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.network;

import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.client.HandshakeSessionHandler;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.netty.LegacyPingDecoder;
import com.velocitypowered.proxy.protocol.netty.LegacyPingEncoder;
import com.velocitypowered.proxy.protocol.netty.MinecraftDecoder;
import com.velocitypowered.proxy.protocol.netty.MinecraftEncoder;
import com.velocitypowered.proxy.protocol.netty.MinecraftVarintFrameDecoder;
import com.velocitypowered.proxy.protocol.netty.MinecraftVarintLengthEncoder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.codec.haproxy.HAProxyMessageDecoder;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.concurrent.TimeUnit;

public class ServerChannelInitializer
extends ChannelInitializer<Channel> {
    private final VelocityServer server;

    public ServerChannelInitializer(VelocityServer server) {
        this.server = server;
    }

    @Override
    protected void initChannel(Channel ch) {
        ch.pipeline().addLast("legacy-ping-decoder", (ChannelHandler)new LegacyPingDecoder()).addLast("frame-decoder", (ChannelHandler)new MinecraftVarintFrameDecoder()).addLast("read-timeout", (ChannelHandler)new ReadTimeoutHandler(this.server.getConfiguration().getReadTimeout(), TimeUnit.MILLISECONDS)).addLast("legacy-ping-encoder", (ChannelHandler)LegacyPingEncoder.INSTANCE).addLast("frame-encoder", (ChannelHandler)MinecraftVarintLengthEncoder.INSTANCE).addLast("minecraft-decoder", (ChannelHandler)new MinecraftDecoder(ProtocolUtils.Direction.SERVERBOUND)).addLast("minecraft-encoder", (ChannelHandler)new MinecraftEncoder(ProtocolUtils.Direction.CLIENTBOUND));
        MinecraftConnection connection = new MinecraftConnection(ch, this.server);
        connection.setSessionHandler(new HandshakeSessionHandler(connection, this.server));
        ch.pipeline().addLast("handler", (ChannelHandler)connection);
        if (this.server.getConfiguration().isProxyProtocol()) {
            ch.pipeline().addFirst(new HAProxyMessageDecoder());
        }
    }
}

