/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.util.bossbar;

import com.google.common.collect.MapMaker;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.util.collect.Enum2IntMap;
import com.velocitypowered.proxy.util.concurrent.Once;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AdventureBossBarManager
implements BossBar.Listener {
    private static final Enum2IntMap<BossBar.Color> COLORS_TO_PROTOCOL = new Enum2IntMap.Builder<BossBar.Color>(BossBar.Color.class).put(BossBar.Color.PINK, 0).put(BossBar.Color.BLUE, 1).put(BossBar.Color.RED, 2).put(BossBar.Color.GREEN, 3).put(BossBar.Color.YELLOW, 4).put(BossBar.Color.PURPLE, 5).put(BossBar.Color.WHITE, 6).build();
    private static final Enum2IntMap<BossBar.Overlay> OVERLAY_TO_PROTOCOL = new Enum2IntMap.Builder<BossBar.Overlay>(BossBar.Overlay.class).put(BossBar.Overlay.PROGRESS, 0).put(BossBar.Overlay.NOTCHED_6, 1).put(BossBar.Overlay.NOTCHED_10, 2).put(BossBar.Overlay.NOTCHED_12, 3).put(BossBar.Overlay.NOTCHED_20, 4).build();
    private static final Enum2IntMap<BossBar.Flag> FLAG_BITS_TO_PROTOCOL = new Enum2IntMap.Builder<BossBar.Flag>(BossBar.Flag.class).put(BossBar.Flag.DARKEN_SCREEN, 1).put(BossBar.Flag.PLAY_BOSS_MUSIC, 2).put(BossBar.Flag.CREATE_WORLD_FOG, 4).build();
    private final Map<BossBar, BossBarHolder> bars = new MapMaker().weakKeys().makeMap();

    private @Nullable BossBarHolder getHandler(BossBar bar) {
        return this.bars.get(bar);
    }

    private BossBarHolder getOrCreateHandler(BossBar bar) {
        BossBarHolder holder = this.bars.computeIfAbsent(bar, k -> new BossBarHolder(bar));
        holder.register();
        return holder;
    }

    public void onDisconnect(ConnectedPlayer player) {
        for (BossBarHolder holder : this.bars.values()) {
            holder.subscribers.remove(player);
        }
    }

    public void addBossBar(ConnectedPlayer player, BossBar bar) {
        BossBarHolder holder = this.getOrCreateHandler(bar);
        if (holder.subscribers.add(player)) {
            player.getConnection().write(holder.createAddPacket(player));
        }
    }

    public void removeBossBar(ConnectedPlayer player, BossBar bar) {
        BossBarHolder holder = this.getHandler(bar);
        if (holder != null && holder.subscribers.remove(player)) {
            player.getConnection().write(holder.createRemovePacket());
        }
    }

    @Override
    public void bossBarNameChanged(@NonNull BossBar bar, @NonNull Component oldName, @NonNull Component newName) {
        BossBarHolder holder = this.getHandler(bar);
        if (holder == null) {
            return;
        }
        for (ConnectedPlayer player : holder.subscribers) {
            Component translated = player.translateMessage(newName);
            com.velocitypowered.proxy.protocol.packet.BossBar packet = holder.createTitleUpdate(translated, player.getProtocolVersion());
            player.getConnection().write(packet);
        }
    }

    @Override
    public void bossBarProgressChanged(@NonNull BossBar bar, float oldPercent, float newPercent) {
        BossBarHolder holder = this.getHandler(bar);
        if (holder == null) {
            return;
        }
        com.velocitypowered.proxy.protocol.packet.BossBar packet = holder.createPercentUpdate(newPercent);
        for (ConnectedPlayer player : holder.subscribers) {
            player.getConnection().write(packet);
        }
    }

    @Override
    public void bossBarColorChanged(@NonNull BossBar bar, @NonNull BossBar.Color oldColor, @NonNull BossBar.Color newColor) {
        BossBarHolder holder = this.getHandler(bar);
        if (holder == null) {
            return;
        }
        com.velocitypowered.proxy.protocol.packet.BossBar packet = holder.createColorUpdate(newColor);
        for (ConnectedPlayer player : holder.subscribers) {
            player.getConnection().write(packet);
        }
    }

    @Override
    public void bossBarOverlayChanged(@NonNull BossBar bar, @NonNull BossBar.Overlay oldOverlay, @NonNull BossBar.Overlay newOverlay) {
        BossBarHolder holder = this.getHandler(bar);
        if (holder == null) {
            return;
        }
        com.velocitypowered.proxy.protocol.packet.BossBar packet = holder.createOverlayUpdate(newOverlay);
        for (ConnectedPlayer player : holder.subscribers) {
            player.getConnection().write(packet);
        }
    }

    @Override
    public void bossBarFlagsChanged(@NonNull BossBar bar, @NonNull Set<BossBar.Flag> added, @NonNull Set<BossBar.Flag> removed) {
        BossBarHolder holder = this.getHandler(bar);
        if (holder == null) {
            return;
        }
        com.velocitypowered.proxy.protocol.packet.BossBar packet = holder.createFlagsUpdate();
        for (ConnectedPlayer player : holder.subscribers) {
            player.getConnection().write(packet);
        }
    }

    private class BossBarHolder {
        private final UUID id = UUID.randomUUID();
        private final BossBar bar;
        private final Set<ConnectedPlayer> subscribers = Collections.newSetFromMap(new MapMaker().weakKeys().makeMap());
        private final Once registrationOnce = new Once();

        BossBarHolder(BossBar bar) {
            this.bar = bar;
        }

        void register() {
            this.registrationOnce.run(() -> this.bar.addListener(AdventureBossBarManager.this));
        }

        com.velocitypowered.proxy.protocol.packet.BossBar createRemovePacket() {
            return com.velocitypowered.proxy.protocol.packet.BossBar.createRemovePacket(this.id);
        }

        com.velocitypowered.proxy.protocol.packet.BossBar createAddPacket(ConnectedPlayer player) {
            com.velocitypowered.proxy.protocol.packet.BossBar packet = new com.velocitypowered.proxy.protocol.packet.BossBar();
            packet.setUuid(this.id);
            packet.setAction(0);
            packet.setName((String)ProtocolUtils.getJsonChatSerializer(player.getProtocolVersion()).serialize(player.translateMessage(this.bar.name())));
            packet.setColor(COLORS_TO_PROTOCOL.get(this.bar.color()));
            packet.setOverlay(OVERLAY_TO_PROTOCOL.get(this.bar.overlay()));
            packet.setPercent(this.bar.progress());
            packet.setFlags(this.serializeFlags(this.bar.flags()));
            return packet;
        }

        com.velocitypowered.proxy.protocol.packet.BossBar createPercentUpdate(float newPercent) {
            com.velocitypowered.proxy.protocol.packet.BossBar packet = new com.velocitypowered.proxy.protocol.packet.BossBar();
            packet.setUuid(this.id);
            packet.setAction(2);
            packet.setPercent(newPercent);
            return packet;
        }

        com.velocitypowered.proxy.protocol.packet.BossBar createColorUpdate(BossBar.Color color) {
            com.velocitypowered.proxy.protocol.packet.BossBar packet = new com.velocitypowered.proxy.protocol.packet.BossBar();
            packet.setUuid(this.id);
            packet.setAction(4);
            packet.setColor(COLORS_TO_PROTOCOL.get(color));
            packet.setOverlay(OVERLAY_TO_PROTOCOL.get(this.bar.overlay()));
            packet.setFlags(this.serializeFlags(this.bar.flags()));
            return packet;
        }

        com.velocitypowered.proxy.protocol.packet.BossBar createTitleUpdate(Component name, ProtocolVersion version) {
            com.velocitypowered.proxy.protocol.packet.BossBar packet = new com.velocitypowered.proxy.protocol.packet.BossBar();
            packet.setUuid(this.id);
            packet.setAction(3);
            packet.setName((String)ProtocolUtils.getJsonChatSerializer(version).serialize(name));
            return packet;
        }

        com.velocitypowered.proxy.protocol.packet.BossBar createFlagsUpdate() {
            return this.createFlagsUpdate(this.bar.flags());
        }

        com.velocitypowered.proxy.protocol.packet.BossBar createFlagsUpdate(Set<BossBar.Flag> newFlags) {
            com.velocitypowered.proxy.protocol.packet.BossBar packet = new com.velocitypowered.proxy.protocol.packet.BossBar();
            packet.setUuid(this.id);
            packet.setAction(5);
            packet.setColor(COLORS_TO_PROTOCOL.get(this.bar.color()));
            packet.setFlags(this.serializeFlags(newFlags));
            return packet;
        }

        com.velocitypowered.proxy.protocol.packet.BossBar createOverlayUpdate(BossBar.Overlay overlay) {
            com.velocitypowered.proxy.protocol.packet.BossBar packet = new com.velocitypowered.proxy.protocol.packet.BossBar();
            packet.setUuid(this.id);
            packet.setAction(4);
            packet.setColor(COLORS_TO_PROTOCOL.get(this.bar.color()));
            packet.setOverlay(OVERLAY_TO_PROTOCOL.get(overlay));
            return packet;
        }

        private byte serializeFlags(Set<BossBar.Flag> flags) {
            byte val = 0;
            for (BossBar.Flag flag : flags) {
                val = (byte)(val | FLAG_BITS_TO_PROTOCOL.get(flag));
            }
            return val;
        }
    }
}

