/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.proxy.crypto;

import com.google.common.collect.ImmutableSet;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.crypto.KeySigned;
import java.security.PublicKey;
import java.util.Set;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface IdentifiedKey
extends KeySigned {
    public PublicKey getSignedPublicKey();

    public boolean verifyDataSignature(byte[] var1, byte[] ... var2);

    public @Nullable UUID getSignatureHolder();

    public Revision getKeyRevision();

    public static enum Revision {
        GENERIC_V1(ImmutableSet.of(), ImmutableSet.of(ProtocolVersion.MINECRAFT_1_19)),
        LINKED_V2(ImmutableSet.of(), ImmutableSet.of(ProtocolVersion.MINECRAFT_1_19_1));

        final Set<Revision> backwardsCompatibleTo;
        final Set<ProtocolVersion> applicableTo;

        private Revision(Set<Revision> backwardsCompatibleTo, Set<ProtocolVersion> applicableTo) {
            this.backwardsCompatibleTo = backwardsCompatibleTo;
            this.applicableTo = applicableTo;
        }

        public Set<Revision> getBackwardsCompatibleTo() {
            return this.backwardsCompatibleTo;
        }

        public Set<ProtocolVersion> getApplicableTo() {
            return this.applicableTo;
        }
    }
}

