/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.natives.compression.VelocityCompressor;
import com.velocitypowered.natives.encryption.VelocityCipher;
import com.velocitypowered.natives.encryption.VelocityCipherFactory;
import com.velocitypowered.natives.util.Natives;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.ConnectionType;
import com.velocitypowered.proxy.connection.ConnectionTypes;
import com.velocitypowered.proxy.connection.MinecraftConnectionAssociation;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.client.HandshakeSessionHandler;
import com.velocitypowered.proxy.connection.client.InitialLoginSessionHandler;
import com.velocitypowered.proxy.connection.client.StatusSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.VelocityConnectionEvent;
import com.velocitypowered.proxy.protocol.netty.MinecraftCipherDecoder;
import com.velocitypowered.proxy.protocol.netty.MinecraftCipherEncoder;
import com.velocitypowered.proxy.protocol.netty.MinecraftCompressDecoder;
import com.velocitypowered.proxy.protocol.netty.MinecraftCompressorAndLengthEncoder;
import com.velocitypowered.proxy.protocol.netty.MinecraftDecoder;
import com.velocitypowered.proxy.protocol.netty.MinecraftEncoder;
import com.velocitypowered.proxy.protocol.netty.MinecraftVarintLengthEncoder;
import com.velocitypowered.proxy.util.except.QuietDecoderException;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.haproxy.HAProxyMessage;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.ReferenceCountUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.concurrent.TimeUnit;
import javax.crypto.spec.SecretKeySpec;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MinecraftConnection
extends ChannelInboundHandlerAdapter {
    private static final Logger logger = LogManager.getLogger(MinecraftConnection.class);
    private final Channel channel;
    private SocketAddress remoteAddress;
    private StateRegistry state;
    private @Nullable MinecraftSessionHandler sessionHandler;
    private ProtocolVersion protocolVersion;
    private @Nullable MinecraftConnectionAssociation association;
    public final VelocityServer server;
    private ConnectionType connectionType = ConnectionTypes.UNDETERMINED;
    private boolean knownDisconnect = false;

    public MinecraftConnection(Channel channel, VelocityServer server) {
        this.channel = channel;
        this.remoteAddress = channel.remoteAddress();
        this.server = server;
        this.state = StateRegistry.HANDSHAKE;
    }

    @Override
    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        if (this.sessionHandler != null) {
            this.sessionHandler.connected();
        }
        if (this.association != null && this.server.getConfiguration().isLogPlayerConnections()) {
            logger.info("{} has connected", (Object)this.association);
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        if (this.sessionHandler != null) {
            this.sessionHandler.disconnected();
        }
        if (this.association != null && !this.knownDisconnect && !(this.sessionHandler instanceof StatusSessionHandler) && this.server.getConfiguration().isLogPlayerConnections()) {
            logger.info("{} has disconnected", (Object)this.association);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        try {
            if (this.sessionHandler == null) {
                return;
            }
            if (this.sessionHandler.beforeHandle()) {
                return;
            }
            if (this.isClosed()) {
                return;
            }
            if (msg instanceof MinecraftPacket) {
                MinecraftPacket pkt = (MinecraftPacket)msg;
                if (!pkt.handle(this.sessionHandler)) {
                    this.sessionHandler.handleGeneric((MinecraftPacket)msg);
                }
            } else if (msg instanceof HAProxyMessage) {
                HAProxyMessage proxyMessage = (HAProxyMessage)msg;
                this.remoteAddress = new InetSocketAddress(proxyMessage.sourceAddress(), proxyMessage.sourcePort());
            } else if (msg instanceof ByteBuf) {
                this.sessionHandler.handleUnknown((ByteBuf)msg);
            }
        }
        finally {
            ReferenceCountUtil.release(msg);
        }
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        if (this.sessionHandler != null) {
            this.sessionHandler.readCompleted();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (ctx.channel().isActive()) {
            if (this.sessionHandler != null) {
                try {
                    this.sessionHandler.exception(cause);
                }
                catch (Exception ex) {
                    logger.error("{}: exception handling exception in {}", this.association != null ? this.association : this.channel.remoteAddress(), (Object)this.sessionHandler, (Object)cause);
                }
            }
            if (this.association != null) {
                if (cause instanceof ReadTimeoutException) {
                    logger.error("{}: read timed out", (Object)this.association);
                } else {
                    boolean willLog;
                    boolean frontlineHandler = this.sessionHandler instanceof InitialLoginSessionHandler || this.sessionHandler instanceof HandshakeSessionHandler || this.sessionHandler instanceof StatusSessionHandler;
                    boolean isQuietDecoderException = cause instanceof QuietDecoderException;
                    boolean bl = willLog = !isQuietDecoderException && !frontlineHandler;
                    if (willLog) {
                        logger.error("{}: exception encountered in {}", (Object)this.association, (Object)this.sessionHandler, (Object)cause);
                    } else {
                        this.knownDisconnect = true;
                    }
                }
            }
            ctx.close();
        }
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        if (this.sessionHandler != null) {
            this.sessionHandler.writabilityChanged();
        }
    }

    private void ensureInEventLoop() {
        Preconditions.checkState(this.channel.eventLoop().inEventLoop(), "Not in event loop");
    }

    public EventLoop eventLoop() {
        return this.channel.eventLoop();
    }

    public void write(Object msg) {
        if (this.channel.isActive()) {
            this.channel.writeAndFlush(msg, this.channel.voidPromise());
        } else {
            ReferenceCountUtil.release(msg);
        }
    }

    public void delayedWrite(Object msg) {
        if (this.channel.isActive()) {
            this.channel.write(msg, this.channel.voidPromise());
        } else {
            ReferenceCountUtil.release(msg);
        }
    }

    public void flush() {
        if (this.channel.isActive()) {
            this.channel.flush();
        }
    }

    public void closeWith(Object msg) {
        if (this.channel.isActive()) {
            boolean is17;
            boolean bl = is17 = this.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_8) < 0 && this.getProtocolVersion().compareTo(ProtocolVersion.MINECRAFT_1_7_2) >= 0;
            if (is17 && this.getState() != StateRegistry.STATUS) {
                this.channel.eventLoop().execute(() -> {
                    this.setAutoReading(false);
                    this.channel.eventLoop().schedule(() -> {
                        this.knownDisconnect = true;
                        this.channel.writeAndFlush(msg).addListener(ChannelFutureListener.CLOSE);
                    }, 250L, TimeUnit.MILLISECONDS);
                });
            } else {
                this.knownDisconnect = true;
                this.channel.writeAndFlush(msg).addListener(ChannelFutureListener.CLOSE);
            }
        }
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean markKnown) {
        if (this.channel.isActive()) {
            if (this.channel.eventLoop().inEventLoop()) {
                if (markKnown) {
                    this.knownDisconnect = true;
                }
                this.channel.close();
            } else {
                this.channel.eventLoop().execute(() -> {
                    if (markKnown) {
                        this.knownDisconnect = true;
                    }
                    this.channel.close();
                });
            }
        }
    }

    public Channel getChannel() {
        return this.channel;
    }

    public boolean isClosed() {
        return !this.channel.isActive();
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public StateRegistry getState() {
        return this.state;
    }

    public boolean isAutoReading() {
        return this.channel.config().isAutoRead();
    }

    public boolean isKnownDisconnect() {
        return this.knownDisconnect;
    }

    public void setAutoReading(boolean autoReading) {
        this.ensureInEventLoop();
        this.channel.config().setAutoRead(autoReading);
        if (autoReading) {
            this.channel.read();
        }
    }

    public void setState(StateRegistry state) {
        this.ensureInEventLoop();
        this.state = state;
        this.channel.pipeline().get(MinecraftEncoder.class).setState(state);
        this.channel.pipeline().get(MinecraftDecoder.class).setState(state);
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this.ensureInEventLoop();
        boolean changed = this.protocolVersion != protocolVersion;
        this.protocolVersion = protocolVersion;
        if (protocolVersion != ProtocolVersion.LEGACY) {
            this.channel.pipeline().get(MinecraftEncoder.class).setProtocolVersion(protocolVersion);
            this.channel.pipeline().get(MinecraftDecoder.class).setProtocolVersion(protocolVersion);
        } else {
            this.channel.pipeline().remove("minecraft-encoder");
            this.channel.pipeline().remove("minecraft-decoder");
        }
        if (changed) {
            this.channel.pipeline().fireUserEventTriggered((Object)VelocityConnectionEvent.PROTOCOL_VERSION_CHANGED);
        }
    }

    public @Nullable MinecraftSessionHandler getSessionHandler() {
        return this.sessionHandler;
    }

    public void setSessionHandler(MinecraftSessionHandler sessionHandler) {
        this.ensureInEventLoop();
        if (this.sessionHandler != null) {
            this.sessionHandler.deactivated();
        }
        this.sessionHandler = sessionHandler;
        sessionHandler.activated();
    }

    private void ensureOpen() {
        Preconditions.checkState(!this.isClosed(), "Connection is closed.");
    }

    public void setCompressionThreshold(int threshold) {
        this.ensureOpen();
        this.ensureInEventLoop();
        if (threshold == -1) {
            ChannelHandler removedDecoder = this.channel.pipeline().remove("compression-decoder");
            ChannelHandler removedEncoder = this.channel.pipeline().remove("compression-encoder");
            if (removedDecoder != null && removedEncoder != null) {
                this.channel.pipeline().addBefore("minecraft-decoder", "frame-encoder", MinecraftVarintLengthEncoder.INSTANCE);
                this.channel.pipeline().fireUserEventTriggered((Object)VelocityConnectionEvent.COMPRESSION_DISABLED);
            }
        } else {
            MinecraftCompressDecoder decoder = (MinecraftCompressDecoder)this.channel.pipeline().get("compression-decoder");
            MinecraftCompressorAndLengthEncoder encoder = (MinecraftCompressorAndLengthEncoder)this.channel.pipeline().get("compression-encoder");
            if (decoder != null && encoder != null) {
                decoder.setThreshold(threshold);
                encoder.setThreshold(threshold);
            } else {
                int level = this.server.getConfiguration().getCompressionLevel();
                VelocityCompressor compressor = Natives.compress.get().create(level);
                encoder = new MinecraftCompressorAndLengthEncoder(threshold, compressor);
                decoder = new MinecraftCompressDecoder(threshold, compressor);
                this.channel.pipeline().remove("frame-encoder");
                this.channel.pipeline().addBefore("minecraft-decoder", "compression-decoder", decoder);
                this.channel.pipeline().addBefore("minecraft-encoder", "compression-encoder", encoder);
                this.channel.pipeline().fireUserEventTriggered((Object)VelocityConnectionEvent.COMPRESSION_ENABLED);
            }
        }
    }

    public void enableEncryption(byte[] secret) throws GeneralSecurityException {
        this.ensureOpen();
        this.ensureInEventLoop();
        SecretKeySpec key = new SecretKeySpec(secret, "AES");
        VelocityCipherFactory factory = Natives.cipher.get();
        VelocityCipher decryptionCipher = factory.forDecryption(key);
        VelocityCipher encryptionCipher = factory.forEncryption(key);
        this.channel.pipeline().addBefore("frame-decoder", "cipher-decoder", new MinecraftCipherDecoder(decryptionCipher));
        this.channel.pipeline().addBefore("frame-encoder", "cipher-encoder", new MinecraftCipherEncoder(encryptionCipher));
        this.channel.pipeline().fireUserEventTriggered((Object)VelocityConnectionEvent.ENCRYPTION_ENABLED);
    }

    public @Nullable MinecraftConnectionAssociation getAssociation() {
        return this.association;
    }

    public void setAssociation(MinecraftConnectionAssociation association) {
        this.ensureInEventLoop();
        this.association = association;
    }

    public ConnectionType getType() {
        return this.connectionType;
    }

    public void setType(ConnectionType connectionType) {
        this.connectionType = connectionType;
    }
}

