/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.backend;

import com.velocitypowered.api.event.player.ServerConnectedEvent;
import com.velocitypowered.api.event.player.ServerPostConnectEvent;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.ConnectionTypes;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.backend.BackendConnectionPhases;
import com.velocitypowered.proxy.connection.backend.BackendPlaySessionHandler;
import com.velocitypowered.proxy.connection.backend.BungeeCordMessageResponder;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ClientPlaySessionHandler;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.forge.legacy.LegacyForgeHandshakeBackendPhase;
import com.velocitypowered.proxy.connection.util.ConnectionMessages;
import com.velocitypowered.proxy.connection.util.ConnectionRequestResults;
import com.velocitypowered.proxy.protocol.packet.Disconnect;
import com.velocitypowered.proxy.protocol.packet.JoinGame;
import com.velocitypowered.proxy.protocol.packet.KeepAlive;
import com.velocitypowered.proxy.protocol.packet.PluginMessage;
import com.velocitypowered.proxy.protocol.util.PluginMessageUtil;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TransitionSessionHandler
implements MinecraftSessionHandler {
    private static final Logger logger = LogManager.getLogger(TransitionSessionHandler.class);
    private final VelocityServer server;
    private final VelocityServerConnection serverConn;
    private final CompletableFuture<ConnectionRequestResults.Impl> resultFuture;
    private final BungeeCordMessageResponder bungeecordMessageResponder;

    TransitionSessionHandler(VelocityServer server, VelocityServerConnection serverConn, CompletableFuture<ConnectionRequestResults.Impl> resultFuture) {
        this.server = server;
        this.serverConn = serverConn;
        this.resultFuture = resultFuture;
        this.bungeecordMessageResponder = new BungeeCordMessageResponder(server, serverConn.getPlayer());
    }

    @Override
    public boolean beforeHandle() {
        if (!this.serverConn.isActive()) {
            this.serverConn.disconnect();
            return true;
        }
        return false;
    }

    @Override
    public boolean handle(KeepAlive packet) {
        this.serverConn.ensureConnected().write(packet);
        return true;
    }

    @Override
    public boolean handle(JoinGame packet) {
        MinecraftConnection smc = this.serverConn.ensureConnected();
        RegisteredServer previousServer = this.serverConn.getPreviousServer().orElse(null);
        VelocityServerConnection existingConnection = this.serverConn.getPlayer().getConnectedServer();
        ConnectedPlayer player = this.serverConn.getPlayer();
        if (existingConnection != null) {
            player.setConnectedServer(null);
            existingConnection.disconnect();
            player.sendKeepAlive();
        }
        smc.setAutoReading(false);
        ((CompletableFuture)this.server.getEventManager().fire(new ServerConnectedEvent(player, this.serverConn.getServer(), previousServer)).thenRunAsync(() -> {
            ClientPlaySessionHandler playHandler;
            if (!this.serverConn.isActive()) {
                this.serverConn.disconnect();
                return;
            }
            if (player.getConnection().getSessionHandler() instanceof ClientPlaySessionHandler) {
                playHandler = (ClientPlaySessionHandler)player.getConnection().getSessionHandler();
            } else {
                playHandler = new ClientPlaySessionHandler(this.server, player);
                player.getConnection().setSessionHandler(playHandler);
            }
            playHandler.handleBackendJoinGame(packet, this.serverConn);
            smc.setSessionHandler(new BackendPlaySessionHandler(this.server, this.serverConn));
            smc.setAutoReading(true);
            this.serverConn.getPlayer().setConnectedServer(this.serverConn);
            this.server.getEventManager().fireAndForget(new ServerPostConnectEvent(player, previousServer));
            this.resultFuture.complete(ConnectionRequestResults.successful(this.serverConn.getServer()));
        }, smc.eventLoop())).exceptionally(exc -> {
            logger.error("Unable to switch to new server {} for {}", (Object)this.serverConn.getServerInfo().getName(), (Object)player.getUsername(), exc);
            player.disconnect(ConnectionMessages.INTERNAL_SERVER_CONNECTION_ERROR);
            this.resultFuture.completeExceptionally((Throwable)exc);
            return null;
        });
        return true;
    }

    @Override
    public boolean handle(Disconnect packet) {
        MinecraftConnection connection = this.serverConn.ensureConnected();
        this.serverConn.disconnect();
        if (connection.getType() == ConnectionTypes.LEGACY_FORGE && !this.serverConn.getPhase().consideredComplete()) {
            this.resultFuture.complete(ConnectionRequestResults.forUnsafeDisconnect(packet, this.serverConn.getServer()));
        } else {
            this.resultFuture.complete(ConnectionRequestResults.forDisconnect(packet, (RegisteredServer)this.serverConn.getServer()));
        }
        return true;
    }

    @Override
    public boolean handle(PluginMessage packet) {
        if (this.bungeecordMessageResponder.process(packet)) {
            return true;
        }
        if (PluginMessageUtil.isRegister(packet)) {
            this.serverConn.getPlayer().getKnownChannels().addAll(PluginMessageUtil.getChannels(packet));
        } else if (PluginMessageUtil.isUnregister(packet)) {
            this.serverConn.getPlayer().getKnownChannels().removeAll(PluginMessageUtil.getChannels(packet));
        }
        if (this.serverConn.getPhase().handle(this.serverConn, this.serverConn.getPlayer(), packet)) {
            VelocityServerConnection existingConnection;
            if (this.serverConn.getPhase() == LegacyForgeHandshakeBackendPhase.HELLO && (existingConnection = this.serverConn.getPlayer().getConnectedServer()) != null && existingConnection.getPhase() != BackendConnectionPhases.IN_TRANSITION) {
                existingConnection.setConnectionPhase(BackendConnectionPhases.IN_TRANSITION);
                existingConnection.getPhase().onDepartForNewServer(existingConnection, this.serverConn.getPlayer());
            }
            return true;
        }
        this.serverConn.getPlayer().getConnection().write(packet.retain());
        return true;
    }

    @Override
    public void disconnected() {
        this.resultFuture.completeExceptionally(new IOException("Unexpectedly disconnected from remote server"));
    }
}

