/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.player;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import net.kyori.adventure.text.Component;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class VelocityResourcePackInfo
implements ResourcePackInfo {
    private final String url;
    private final @Nullable byte[] hash;
    private final boolean shouldForce;
    private final @Nullable Component prompt;
    private final ResourcePackInfo.Origin origin;
    private ResourcePackInfo.Origin originalOrigin;

    private VelocityResourcePackInfo(String url, @Nullable byte[] hash, boolean shouldForce, @Nullable Component prompt, ResourcePackInfo.Origin origin) {
        this.url = url;
        this.hash = hash;
        this.shouldForce = shouldForce;
        this.prompt = prompt;
        this.origin = origin;
        this.originalOrigin = origin;
    }

    @Override
    public String getUrl() {
        return this.url;
    }

    @Override
    public @Nullable Component getPrompt() {
        return this.prompt;
    }

    @Override
    public boolean getShouldForce() {
        return this.shouldForce;
    }

    @Override
    public @Nullable byte[] getHash() {
        return this.hash == null ? null : (byte[])this.hash.clone();
    }

    @Override
    public ResourcePackInfo.Origin getOrigin() {
        return this.origin;
    }

    public void setOriginalOrigin(ResourcePackInfo.Origin originalOrigin) {
        this.originalOrigin = originalOrigin;
    }

    @Override
    public ResourcePackInfo.Origin getOriginalOrigin() {
        return this.originalOrigin;
    }

    @Override
    public ResourcePackInfo.Builder asBuilder() {
        return new BuilderImpl(this.url).setShouldForce(this.shouldForce).setHash(this.hash).setPrompt(this.prompt);
    }

    @Override
    public ResourcePackInfo.Builder asBuilder(String newUrl) {
        return new BuilderImpl(newUrl).setShouldForce(this.shouldForce).setHash(this.hash).setPrompt(this.prompt);
    }

    public static final class BuilderImpl
    implements ResourcePackInfo.Builder {
        private final String url;
        private boolean shouldForce;
        private @Nullable byte[] hash;
        private @Nullable Component prompt;
        private ResourcePackInfo.Origin origin = ResourcePackInfo.Origin.PLUGIN_ON_PROXY;

        public BuilderImpl(String url) {
            this.url = Preconditions.checkNotNull(url, "url");
        }

        @Override
        public BuilderImpl setShouldForce(boolean shouldForce) {
            this.shouldForce = shouldForce;
            return this;
        }

        @Override
        public BuilderImpl setHash(@Nullable byte[] hash) {
            if (hash != null) {
                Preconditions.checkArgument(hash.length == 20, "Hash length is not 20");
                this.hash = (byte[])hash.clone();
            } else {
                this.hash = null;
            }
            return this;
        }

        @Override
        public BuilderImpl setPrompt(@Nullable Component prompt) {
            this.prompt = prompt;
            return this;
        }

        @Override
        public ResourcePackInfo build() {
            return new VelocityResourcePackInfo(this.url, this.hash, this.shouldForce, this.prompt, this.origin);
        }

        public BuilderImpl setOrigin(ResourcePackInfo.Origin origin) {
            this.origin = origin;
            return this;
        }
    }
}

