/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.registry;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.network.ProtocolVersion;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class DimensionData {
    private static final String UNKNOWN_DIMENSION_ID = "velocity:unknown_dimension";
    private final String registryIdentifier;
    private final @Nullable Integer dimensionId;
    private final boolean isNatural;
    private final float ambientLight;
    private final boolean isShrunk;
    private final boolean isUltrawarm;
    private final boolean hasCeiling;
    private final boolean hasSkylight;
    private final boolean isPiglinSafe;
    private final boolean doBedsWork;
    private final boolean doRespawnAnchorsWork;
    private final boolean hasRaids;
    private final int logicalHeight;
    private final String burningBehaviourIdentifier;
    private final @Nullable Long fixedTime;
    private final @Nullable Boolean createDragonFight;
    private final @Nullable Double coordinateScale;
    private final @Nullable String effects;
    private final @Nullable Integer minY;
    private final @Nullable Integer height;
    private final @Nullable Integer monsterSpawnBlockLightLimit;
    private final @Nullable Integer monsterSpawnLightLevel;

    public DimensionData(String registryIdentifier, @Nullable Integer dimensionId, boolean isNatural, float ambientLight, boolean isShrunk, boolean isUltrawarm, boolean hasCeiling, boolean hasSkylight, boolean isPiglinSafe, boolean doBedsWork, boolean doRespawnAnchorsWork, boolean hasRaids, int logicalHeight, String burningBehaviourIdentifier, @Nullable Long fixedTime, @Nullable Boolean createDragonFight, @Nullable Double coordinateScale, @Nullable String effects, @Nullable Integer minY, @Nullable Integer height, @Nullable Integer monsterSpawnBlockLightLimit, @Nullable Integer monsterSpawnLightLevel) {
        this.monsterSpawnBlockLightLimit = monsterSpawnBlockLightLimit;
        this.monsterSpawnLightLevel = monsterSpawnLightLevel;
        Preconditions.checkNotNull(registryIdentifier, "registryIdentifier cannot be null");
        Preconditions.checkArgument(registryIdentifier.length() > 0, "registryIdentifier cannot be empty");
        Preconditions.checkArgument(logicalHeight >= 0, "localHeight must be >= 0");
        Preconditions.checkNotNull(burningBehaviourIdentifier, "burningBehaviourIdentifier cannot be null");
        Preconditions.checkArgument(burningBehaviourIdentifier.length() > 0, "burningBehaviourIdentifier cannot be empty");
        this.registryIdentifier = registryIdentifier;
        this.dimensionId = dimensionId;
        this.isNatural = isNatural;
        this.ambientLight = ambientLight;
        this.isShrunk = isShrunk;
        this.isUltrawarm = isUltrawarm;
        this.hasCeiling = hasCeiling;
        this.hasSkylight = hasSkylight;
        this.isPiglinSafe = isPiglinSafe;
        this.doBedsWork = doBedsWork;
        this.doRespawnAnchorsWork = doRespawnAnchorsWork;
        this.hasRaids = hasRaids;
        this.logicalHeight = logicalHeight;
        this.burningBehaviourIdentifier = burningBehaviourIdentifier;
        this.fixedTime = fixedTime;
        this.createDragonFight = createDragonFight;
        this.coordinateScale = coordinateScale;
        this.effects = effects;
        this.minY = minY;
        this.height = height;
    }

    public String getRegistryIdentifier() {
        return this.registryIdentifier;
    }

    public @Nullable Integer getDimensionId() {
        return this.dimensionId;
    }

    public boolean isNatural() {
        return this.isNatural;
    }

    public float getAmbientLight() {
        return this.ambientLight;
    }

    public boolean isShrunk() {
        return this.isShrunk;
    }

    public boolean isUltrawarm() {
        return this.isUltrawarm;
    }

    public boolean hasCeiling() {
        return this.hasCeiling;
    }

    public boolean hasSkylight() {
        return this.hasSkylight;
    }

    public boolean isPiglinSafe() {
        return this.isPiglinSafe;
    }

    public boolean doBedsWork() {
        return this.doBedsWork;
    }

    public boolean doRespawnAnchorsWork() {
        return this.doRespawnAnchorsWork;
    }

    public boolean hasRaids() {
        return this.hasRaids;
    }

    public int getLogicalHeight() {
        return this.logicalHeight;
    }

    public String getBurningBehaviourIdentifier() {
        return this.burningBehaviourIdentifier;
    }

    public @Nullable Long getFixedTime() {
        return this.fixedTime;
    }

    public @Nullable Boolean getCreateDragonFight() {
        return this.createDragonFight;
    }

    public @Nullable Double getCoordinateScale() {
        return this.coordinateScale;
    }

    public @Nullable Integer getMinY() {
        return this.minY;
    }

    public @Nullable Integer getHeight() {
        return this.height;
    }

    public DimensionData annotateWith(String registryIdentifier, @Nullable Integer dimensionId) {
        return new DimensionData(registryIdentifier, dimensionId, this.isNatural, this.ambientLight, this.isShrunk, this.isUltrawarm, this.hasCeiling, this.hasSkylight, this.isPiglinSafe, this.doBedsWork, this.doRespawnAnchorsWork, this.hasRaids, this.logicalHeight, this.burningBehaviourIdentifier, this.fixedTime, this.createDragonFight, this.coordinateScale, this.effects, this.minY, this.height, this.monsterSpawnBlockLightLimit, this.monsterSpawnLightLevel);
    }

    public boolean isUnannotated() {
        return this.registryIdentifier.equalsIgnoreCase(UNKNOWN_DIMENSION_ID);
    }

    public static DimensionData decodeBaseCompoundTag(CompoundBinaryTag details, ProtocolVersion version) {
        Integer monsterSpawnLightLevel;
        boolean isNatural = details.getBoolean("natural");
        float ambientLight = details.getFloat("ambient_light");
        boolean isShrunk = details.getBoolean("shrunk");
        boolean isUltrawarm = details.getBoolean("ultrawarm");
        boolean hasCeiling = details.getBoolean("has_ceiling");
        boolean hasSkylight = details.getBoolean("has_skylight");
        boolean isPiglinSafe = details.getBoolean("piglin_safe");
        boolean doBedsWork = details.getBoolean("bed_works");
        boolean doRespawnAnchorsWork = details.getBoolean("respawn_anchor_works");
        boolean hasRaids = details.getBoolean("has_raids");
        int logicalHeight = details.getInt("logical_height");
        String burningBehaviourIdentifier = details.getString("infiniburn");
        Long fixedTime = details.keySet().contains("fixed_time") ? Long.valueOf(details.getLong("fixed_time")) : null;
        Boolean hasEnderdragonFight = details.keySet().contains("has_enderdragon_fight") ? Boolean.valueOf(details.getBoolean("has_enderdragon_fight")) : null;
        Double coordinateScale = details.keySet().contains("coordinate_scale") ? Double.valueOf(details.getDouble("coordinate_scale")) : null;
        String effects = details.keySet().contains("effects") ? details.getString("effects") : null;
        Integer minY = details.keySet().contains("min_y") ? Integer.valueOf(details.getInt("min_y")) : null;
        Integer height = details.keySet().contains("height") ? Integer.valueOf(details.getInt("height")) : null;
        Integer monsterSpawnBlockLightLimit = details.keySet().contains("monster_spawn_block_light_limit") ? Integer.valueOf(details.getInt("monster_spawn_block_light_limit")) : null;
        Integer n = monsterSpawnLightLevel = details.keySet().contains("monster_spawn_light_level") ? Integer.valueOf(details.getInt("monster_spawn_block_light_limit")) : null;
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_17) >= 0) {
            Preconditions.checkNotNull(height, "DimensionData requires 'height' to be present for this version");
            Preconditions.checkNotNull(minY, "DimensionData requires 'minY' to be present for this version");
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_19) >= 0) {
            Preconditions.checkNotNull(monsterSpawnBlockLightLimit, "DimensionData requires 'monster_spawn_block_light_limit' to be present for this version.");
            Preconditions.checkNotNull(monsterSpawnLightLevel, "DimensionData requires 'monster_spawn_light_level' to be present for this version.");
        }
        return new DimensionData(UNKNOWN_DIMENSION_ID, null, isNatural, ambientLight, isShrunk, isUltrawarm, hasCeiling, hasSkylight, isPiglinSafe, doBedsWork, doRespawnAnchorsWork, hasRaids, logicalHeight, burningBehaviourIdentifier, fixedTime, hasEnderdragonFight, coordinateScale, effects, minY, height, monsterSpawnBlockLightLimit, monsterSpawnLightLevel);
    }

    public static DimensionData decodeRegistryEntry(CompoundBinaryTag dimTag, ProtocolVersion version) {
        CompoundBinaryTag details;
        String registryIdentifier = dimTag.getString("name");
        Integer dimensionId = null;
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_16_2) >= 0) {
            dimensionId = dimTag.getInt("id");
            details = dimTag.getCompound("element");
        } else {
            details = dimTag;
        }
        DimensionData deserializedDetails = DimensionData.decodeBaseCompoundTag(details, version);
        return deserializedDetails.annotateWith(registryIdentifier, dimensionId);
    }

    public CompoundBinaryTag encodeAsCompoundTag(ProtocolVersion version) {
        CompoundBinaryTag details = this.serializeDimensionDetails();
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_16_2) >= 0) {
            if (this.dimensionId == null) {
                throw new IllegalStateException("Tried to serialize a 1.16.2+ dimension registry entry without an ID");
            }
            return ((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)((CompoundBinaryTag.Builder)CompoundBinaryTag.builder().putString("name", this.registryIdentifier)).putInt("id", this.dimensionId)).put("element", details)).build();
        }
        return (CompoundBinaryTag)details.putString("name", this.registryIdentifier);
    }

    public CompoundBinaryTag serializeDimensionDetails() {
        CompoundBinaryTag.Builder ret = CompoundBinaryTag.builder();
        ret.putBoolean("natural", this.isNatural);
        ret.putFloat("ambient_light", this.ambientLight);
        ret.putBoolean("shrunk", this.isShrunk);
        ret.putBoolean("ultrawarm", this.isUltrawarm);
        ret.putBoolean("has_ceiling", this.hasCeiling);
        ret.putBoolean("has_skylight", this.hasSkylight);
        ret.putBoolean("piglin_safe", this.isPiglinSafe);
        ret.putBoolean("bed_works", this.doBedsWork);
        ret.putBoolean("respawn_anchor_works", this.doRespawnAnchorsWork);
        ret.putBoolean("has_raids", this.hasRaids);
        ret.putInt("logical_height", this.logicalHeight);
        ret.putString("infiniburn", this.burningBehaviourIdentifier);
        if (this.fixedTime != null) {
            ret.putLong("fixed_time", this.fixedTime);
        }
        if (this.createDragonFight != null) {
            ret.putBoolean("has_enderdragon_fight", this.createDragonFight);
        }
        if (this.coordinateScale != null) {
            ret.putDouble("coordinate_scale", this.coordinateScale);
        }
        if (this.effects != null) {
            ret.putString("effects", this.effects);
        }
        if (this.minY != null) {
            ret.putInt("min_y", this.minY);
        }
        if (this.height != null) {
            ret.putInt("height", this.height);
        }
        if (this.monsterSpawnBlockLightLimit != null) {
            ret.putInt("monster_spawn_block_light_limit", this.monsterSpawnBlockLightLimit);
        }
        if (this.monsterSpawnLightLevel != null) {
            ret.putInt("monster_spawn_light_level", this.monsterSpawnLightLevel);
        }
        return ret.build();
    }
}

