/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.crypto;

import com.google.common.base.Objects;
import com.velocitypowered.api.proxy.crypto.IdentifiedKey;
import com.velocitypowered.proxy.crypto.EncryptionUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.time.Instant;
import java.util.Arrays;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class IdentifiedKeyImpl
implements IdentifiedKey {
    private final IdentifiedKey.Revision revision;
    private final PublicKey publicKey;
    private final byte[] signature;
    private final Instant expiryTemporal;
    private @MonotonicNonNull Boolean isSignatureValid;
    private @MonotonicNonNull UUID holder;

    public IdentifiedKeyImpl(IdentifiedKey.Revision revision, byte[] keyBits, long expiry, byte[] signature) {
        this(revision, EncryptionUtils.parseRsaPublicKey(keyBits), Instant.ofEpochMilli(expiry), signature);
    }

    public IdentifiedKeyImpl(IdentifiedKey.Revision revision, PublicKey publicKey, Instant expiryTemporal, byte[] signature) {
        this.revision = revision;
        this.publicKey = publicKey;
        this.expiryTemporal = expiryTemporal;
        this.signature = signature;
    }

    @Override
    public PublicKey getSignedPublicKey() {
        return this.publicKey;
    }

    @Override
    public PublicKey getSigner() {
        return EncryptionUtils.getYggdrasilSessionKey();
    }

    @Override
    public Instant getExpiryTemporal() {
        return this.expiryTemporal;
    }

    @Override
    public byte[] getSignature() {
        return (byte[])this.signature.clone();
    }

    @Override
    public @Nullable UUID getSignatureHolder() {
        return this.holder;
    }

    @Override
    public IdentifiedKey.Revision getKeyRevision() {
        return this.revision;
    }

    public boolean internalAddHolder(UUID holder) {
        if (holder == null) {
            return false;
        }
        if (this.holder == null) {
            Boolean result = this.validateData(holder);
            if (result == null || !result.booleanValue()) {
                return false;
            }
            this.isSignatureValid = true;
            this.holder = holder;
            return true;
        }
        return this.holder.equals(holder) && this.isSignatureValid();
    }

    @Override
    public boolean isSignatureValid() {
        if (this.isSignatureValid == null) {
            this.isSignatureValid = this.validateData(this.holder);
        }
        return this.isSignatureValid != null && this.isSignatureValid != false;
    }

    private Boolean validateData(@Nullable UUID verify) {
        if (this.revision == IdentifiedKey.Revision.GENERIC_V1) {
            String pemKey = EncryptionUtils.pemEncodeRsaKey(this.publicKey);
            long expires = this.expiryTemporal.toEpochMilli();
            byte[] toVerify = (expires + pemKey).getBytes(StandardCharsets.US_ASCII);
            return EncryptionUtils.verifySignature("SHA1withRSA", EncryptionUtils.getYggdrasilSessionKey(), this.signature, new byte[][]{toVerify});
        }
        if (verify == null) {
            return null;
        }
        byte[] keyBytes = this.publicKey.getEncoded();
        byte[] toVerify = new byte[keyBytes.length + 24];
        ByteBuffer fixedDataSet = ByteBuffer.wrap(toVerify).order(ByteOrder.BIG_ENDIAN);
        fixedDataSet.putLong(verify.getMostSignificantBits());
        fixedDataSet.putLong(verify.getLeastSignificantBits());
        fixedDataSet.putLong(this.expiryTemporal.toEpochMilli());
        fixedDataSet.put(keyBytes);
        return EncryptionUtils.verifySignature("SHA1withRSA", EncryptionUtils.getYggdrasilSessionKey(), this.signature, new byte[][]{toVerify});
    }

    @Override
    public boolean verifyDataSignature(byte[] signature, byte[] ... toVerify) {
        try {
            return EncryptionUtils.verifySignature("SHA256withRSA", this.publicKey, signature, toVerify);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public String toString() {
        return "IdentifiedKeyImpl{revision=" + this.revision + ", publicKey=" + this.publicKey + ", signature=" + Arrays.toString(this.signature) + ", expiryTemporal=" + this.expiryTemporal + ", isSignatureValid=" + this.isSignatureValid + ", holder=" + this.holder + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IdentifiedKey)) {
            return false;
        }
        IdentifiedKey that = (IdentifiedKey)o;
        return Objects.equal(this.getSignedPublicKey(), that.getSignedPublicKey()) && Objects.equal(this.getExpiryTemporal(), that.getExpiryTemporal()) && Arrays.equals(this.getSignature(), that.getSignature()) && Objects.equal(this.getSigner(), that.getSigner());
    }
}

