/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.crypto.IdentifiedKey;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.proxy.crypto.IdentifiedKeyImpl;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.netty.MinecraftDecoder;
import com.velocitypowered.proxy.protocol.util.NettyPreconditions;
import com.velocitypowered.proxy.protocol.util.VelocityLegacyHoverEventSerializer;
import com.velocitypowered.proxy.util.except.QuietDecoderException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.nbt.BinaryTagIO;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;

public enum ProtocolUtils {

    private static final GsonComponentSerializer PRE_1_16_SERIALIZER = GsonComponentSerializer.builder().downsampleColors().emitLegacyHoverEvent().legacyHoverEventSerializer(VelocityLegacyHoverEventSerializer.INSTANCE).build();
    private static final GsonComponentSerializer MODERN_SERIALIZER = GsonComponentSerializer.builder().legacyHoverEventSerializer(VelocityLegacyHoverEventSerializer.INSTANCE).build();
    public static final int DEFAULT_MAX_STRING_SIZE = 65536;
    private static final QuietDecoderException BAD_VARINT_CACHED = new QuietDecoderException("Bad VarInt decoded");
    private static final int[] VARINT_EXACT_BYTE_LENGTHS = new int[33];
    private static final int FORGE_MAX_ARRAY_LENGTH = 2097050;

    public static int readVarInt(ByteBuf buf) {
        int read = ProtocolUtils.readVarIntSafely(buf);
        if (read == Integer.MIN_VALUE) {
            throw MinecraftDecoder.DEBUG ? new CorruptedFrameException("Bad VarInt decoded") : BAD_VARINT_CACHED;
        }
        return read;
    }

    public static int readVarIntSafely(ByteBuf buf) {
        int i = 0;
        int maxRead = Math.min(5, buf.readableBytes());
        for (int j = 0; j < maxRead; ++j) {
            byte k = buf.readByte();
            i |= (k & 0x7F) << j * 7;
            if ((k & 0x80) == 128) continue;
            return i;
        }
        return Integer.MIN_VALUE;
    }

    public static int varIntBytes(int value) {
        return VARINT_EXACT_BYTE_LENGTHS[Integer.numberOfLeadingZeros(value)];
    }

    public static void writeVarInt(ByteBuf buf, int value) {
        if ((value & 0xFFFFFF80) == 0) {
            buf.writeByte(value);
        } else if ((value & 0xFFFFC000) == 0) {
            int w = (value & 0x7F | 0x80) << 8 | value >>> 7;
            buf.writeShort(w);
        } else {
            ProtocolUtils.writeVarIntFull(buf, value);
        }
    }

    private static void writeVarIntFull(ByteBuf buf, int value) {
        if ((value & 0xFFFFFF80) == 0) {
            buf.writeByte(value);
        } else if ((value & 0xFFFFC000) == 0) {
            int w = (value & 0x7F | 0x80) << 8 | value >>> 7;
            buf.writeShort(w);
        } else if ((value & 0xFFE00000) == 0) {
            int w = (value & 0x7F | 0x80) << 16 | (value >>> 7 & 0x7F | 0x80) << 8 | value >>> 14;
            buf.writeMedium(w);
        } else if ((value & 0xF0000000) == 0) {
            int w = (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | value >>> 21;
            buf.writeInt(w);
        } else {
            int w = (value & 0x7F | 0x80) << 24 | (value >>> 7 & 0x7F | 0x80) << 16 | (value >>> 14 & 0x7F | 0x80) << 8 | (value >>> 21 & 0x7F | 0x80);
            buf.writeInt(w);
            buf.writeByte(value >>> 28);
        }
    }

    public static void write21BitVarInt(ByteBuf buf, int value) {
        int w = (value & 0x7F | 0x80) << 16 | (value >>> 7 & 0x7F | 0x80) << 8 | value >>> 14;
        buf.writeMedium(w);
    }

    public static String readString(ByteBuf buf) {
        return ProtocolUtils.readString(buf, 65536);
    }

    public static String readString(ByteBuf buf, int cap) {
        int length = ProtocolUtils.readVarInt(buf);
        return ProtocolUtils.readString(buf, cap, length);
    }

    private static String readString(ByteBuf buf, int cap, int length) {
        NettyPreconditions.checkFrame(length >= 0, "Got a negative-length string (%s)", (Object)length);
        NettyPreconditions.checkFrame(length <= cap * 3, "Bad string size (got %s, maximum is %s)", (Object)length, (Object)cap);
        NettyPreconditions.checkFrame(buf.isReadable(length), "Trying to read a string that is too long (wanted %s, only have %s)", (Object)length, (Object)buf.readableBytes());
        String str = buf.toString(buf.readerIndex(), length, StandardCharsets.UTF_8);
        buf.skipBytes(length);
        NettyPreconditions.checkFrame(str.length() <= cap, "Got a too-long string (got %s, max %s)", (Object)str.length(), (Object)cap);
        return str;
    }

    public static void writeString(ByteBuf buf, CharSequence str) {
        int size = ByteBufUtil.utf8Bytes(str);
        ProtocolUtils.writeVarInt(buf, size);
        buf.writeCharSequence(str, StandardCharsets.UTF_8);
    }

    public static byte[] readByteArray(ByteBuf buf) {
        return ProtocolUtils.readByteArray(buf, 65536);
    }

    public static byte[] readByteArray(ByteBuf buf, int cap) {
        int length = ProtocolUtils.readVarInt(buf);
        NettyPreconditions.checkFrame(length >= 0, "Got a negative-length array (%s)", (Object)length);
        NettyPreconditions.checkFrame(length <= cap, "Bad array size (got %s, maximum is %s)", (Object)length, (Object)cap);
        NettyPreconditions.checkFrame(buf.isReadable(length), "Trying to read an array that is too long (wanted %s, only have %s)", (Object)length, (Object)buf.readableBytes());
        byte[] array = new byte[length];
        buf.readBytes(array);
        return array;
    }

    public static void writeByteArray(ByteBuf buf, byte[] array) {
        ProtocolUtils.writeVarInt(buf, array.length);
        buf.writeBytes(array);
    }

    public static int[] readIntegerArray(ByteBuf buf) {
        int len = ProtocolUtils.readVarInt(buf);
        Preconditions.checkArgument(len >= 0, "Got a negative-length integer array (%s)", len);
        int[] array = new int[len];
        for (int i = 0; i < len; ++i) {
            array[i] = ProtocolUtils.readVarInt(buf);
        }
        return array;
    }

    public static UUID readUuid(ByteBuf buf) {
        long msb = buf.readLong();
        long lsb = buf.readLong();
        return new UUID(msb, lsb);
    }

    public static void writeUuid(ByteBuf buf, UUID uuid) {
        buf.writeLong(uuid.getMostSignificantBits());
        buf.writeLong(uuid.getLeastSignificantBits());
    }

    public static UUID readUuidIntArray(ByteBuf buf) {
        long msbHigh = (long)buf.readInt() << 32;
        long msbLow = (long)buf.readInt() & 0xFFFFFFFFL;
        long msb = msbHigh | msbLow;
        long lsbHigh = (long)buf.readInt() << 32;
        long lsbLow = (long)buf.readInt() & 0xFFFFFFFFL;
        long lsb = lsbHigh | lsbLow;
        return new UUID(msb, lsb);
    }

    public static void writeUuidIntArray(ByteBuf buf, UUID uuid) {
        buf.writeInt((int)(uuid.getMostSignificantBits() >> 32));
        buf.writeInt((int)uuid.getMostSignificantBits());
        buf.writeInt((int)(uuid.getLeastSignificantBits() >> 32));
        buf.writeInt((int)uuid.getLeastSignificantBits());
    }

    public static CompoundBinaryTag readCompoundTag(ByteBuf buf, BinaryTagIO.Reader reader) {
        try {
            return reader.read(new ByteBufInputStream(buf));
        }
        catch (IOException thrown) {
            throw new DecoderException("Unable to parse NBT CompoundTag, full error: " + thrown.getMessage());
        }
    }

    public static void writeCompoundTag(ByteBuf buf, CompoundBinaryTag compoundTag) {
        try {
            BinaryTagIO.writer().write(compoundTag, new ByteBufOutputStream(buf));
        }
        catch (IOException e) {
            throw new EncoderException("Unable to encode NBT CompoundTag");
        }
    }

    public static String[] readStringArray(ByteBuf buf) {
        int length = ProtocolUtils.readVarInt(buf);
        String[] ret = new String[length];
        for (int i = 0; i < length; ++i) {
            ret[i] = ProtocolUtils.readString(buf);
        }
        return ret;
    }

    public static void writeStringArray(ByteBuf buf, String[] stringArray) {
        ProtocolUtils.writeVarInt(buf, stringArray.length);
        for (String s : stringArray) {
            ProtocolUtils.writeString(buf, s);
        }
    }

    public static void writeProperties(ByteBuf buf, List<GameProfile.Property> properties) {
        ProtocolUtils.writeVarInt(buf, properties.size());
        for (GameProfile.Property property : properties) {
            ProtocolUtils.writeString(buf, property.getName());
            ProtocolUtils.writeString(buf, property.getValue());
            String signature = property.getSignature();
            if (signature != null && !signature.isEmpty()) {
                buf.writeBoolean(true);
                ProtocolUtils.writeString(buf, signature);
                continue;
            }
            buf.writeBoolean(false);
        }
    }

    public static List<GameProfile.Property> readProperties(ByteBuf buf) {
        ArrayList<GameProfile.Property> properties = new ArrayList<GameProfile.Property>();
        int size = ProtocolUtils.readVarInt(buf);
        for (int i = 0; i < size; ++i) {
            String name = ProtocolUtils.readString(buf);
            String value = ProtocolUtils.readString(buf);
            String signature = "";
            boolean hasSignature = buf.readBoolean();
            if (hasSignature) {
                signature = ProtocolUtils.readString(buf);
            }
            properties.add(new GameProfile.Property(name, value, signature));
        }
        return properties;
    }

    public static byte[] readByteArray17(ByteBuf buf) {
        int len = ProtocolUtils.readExtendedForgeShort(buf);
        Preconditions.checkArgument(len <= 2097050, "Cannot receive array longer than %s (got %s bytes)", 2097050, len);
        byte[] ret = new byte[len];
        buf.readBytes(ret);
        return ret;
    }

    public static ByteBuf readRetainedByteBufSlice17(ByteBuf buf) {
        int len = ProtocolUtils.readExtendedForgeShort(buf);
        NettyPreconditions.checkFrame(len <= 2097050, "Cannot receive array longer than %s (got %s bytes)", (Object)2097050, (Object)len);
        return buf.readRetainedSlice(len);
    }

    public static void writeByteArray17(byte[] b, ByteBuf buf, boolean allowExtended) {
        if (allowExtended) {
            NettyPreconditions.checkFrame(b.length <= 2097050, "Cannot send array longer than %s (got %s bytes)", (Object)2097050, (Object)b.length);
        } else {
            NettyPreconditions.checkFrame(b.length <= Short.MAX_VALUE, "Cannot send array longer than Short.MAX_VALUE (got %s bytes)", (Object)b.length);
        }
        ProtocolUtils.writeExtendedForgeShort(buf, b.length);
        buf.writeBytes(b);
    }

    public static void writeByteBuf17(ByteBuf b, ByteBuf buf, boolean allowExtended) {
        if (allowExtended) {
            NettyPreconditions.checkFrame(b.readableBytes() <= 2097050, "Cannot send array longer than %s (got %s bytes)", (Object)2097050, (Object)b.readableBytes());
        } else {
            NettyPreconditions.checkFrame(b.readableBytes() <= Short.MAX_VALUE, "Cannot send array longer than Short.MAX_VALUE (got %s bytes)", (Object)b.readableBytes());
        }
        ProtocolUtils.writeExtendedForgeShort(buf, b.readableBytes());
        buf.writeBytes(b);
    }

    public static int readExtendedForgeShort(ByteBuf buf) {
        int low = buf.readUnsignedShort();
        int high = 0;
        if ((low & 0x8000) != 0) {
            low &= Short.MAX_VALUE;
            high = buf.readUnsignedByte();
        }
        return (high & 0xFF) << 15 | low;
    }

    public static void writeExtendedForgeShort(ByteBuf buf, int toWrite) {
        int low = toWrite & Short.MAX_VALUE;
        int high = (toWrite & 0x7F8000) >> 15;
        if (high != 0) {
            low |= 0x8000;
        }
        buf.writeShort(low);
        if (high != 0) {
            buf.writeByte(high);
        }
    }

    public static String readStringWithoutLength(ByteBuf buf) {
        return ProtocolUtils.readString(buf, 65536, buf.readableBytes());
    }

    public static GsonComponentSerializer getJsonChatSerializer(ProtocolVersion version) {
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_16) >= 0) {
            return MODERN_SERIALIZER;
        }
        return PRE_1_16_SERIALIZER;
    }

    public static void writePlayerKey(ByteBuf buf, IdentifiedKey playerKey) {
        buf.writeLong(playerKey.getExpiryTemporal().toEpochMilli());
        ProtocolUtils.writeByteArray(buf, playerKey.getSignedPublicKey().getEncoded());
        ProtocolUtils.writeByteArray(buf, playerKey.getSignature());
    }

    public static IdentifiedKey readPlayerKey(ProtocolVersion version, ByteBuf buf) {
        long expiry = buf.readLong();
        byte[] key = ProtocolUtils.readByteArray(buf);
        byte[] signature = ProtocolUtils.readByteArray(buf, 4096);
        IdentifiedKey.Revision revision = version.compareTo(ProtocolVersion.MINECRAFT_1_19) == 0 ? IdentifiedKey.Revision.GENERIC_V1 : IdentifiedKey.Revision.LINKED_V2;
        return new IdentifiedKeyImpl(revision, key, expiry, signature);
    }

    static {
        for (int i = 0; i <= 32; ++i) {
            ProtocolUtils.VARINT_EXACT_BYTE_LENGTHS[i] = (int)Math.ceil((31.0 - (double)(i - 1)) / 7.0);
        }
        ProtocolUtils.VARINT_EXACT_BYTE_LENGTHS[32] = 1;
    }

    public static enum Direction {
        SERVERBOUND,
        CLIENTBOUND;


        public StateRegistry.PacketRegistry.ProtocolRegistry getProtocolRegistry(StateRegistry state, ProtocolVersion version) {
            return (this == SERVERBOUND ? state.serverbound : state.clientbound).getProtocolRegistry(version);
        }
    }
}

