/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.google.common.collect.ImmutableSet;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.registry.DimensionData;
import com.velocitypowered.proxy.connection.registry.DimensionInfo;
import com.velocitypowered.proxy.connection.registry.DimensionRegistry;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.Pair;
import net.kyori.adventure.nbt.BinaryTagIO;
import net.kyori.adventure.nbt.BinaryTagTypes;
import net.kyori.adventure.nbt.CompoundBinaryTag;
import net.kyori.adventure.nbt.ListBinaryTag;
import org.checkerframework.checker.nullness.qual.Nullable;

public class JoinGame
implements MinecraftPacket {
    private static final BinaryTagIO.Reader JOINGAME_READER = BinaryTagIO.reader(0x400000L);
    private int entityId;
    private short gamemode;
    private int dimension;
    private long partialHashedSeed;
    private short difficulty;
    private boolean isHardcore;
    private int maxPlayers;
    private @Nullable String levelType;
    private int viewDistance;
    private boolean reducedDebugInfo;
    private boolean showRespawnScreen;
    private DimensionRegistry dimensionRegistry;
    private DimensionInfo dimensionInfo;
    private DimensionData currentDimensionData;
    private short previousGamemode;
    private CompoundBinaryTag biomeRegistry;
    private int simulationDistance;
    private @Nullable Pair<String, Long> lastDeathPosition;
    private CompoundBinaryTag chatTypeRegistry;

    public int getEntityId() {
        return this.entityId;
    }

    public void setEntityId(int entityId) {
        this.entityId = entityId;
    }

    public short getGamemode() {
        return this.gamemode;
    }

    public void setGamemode(short gamemode) {
        this.gamemode = gamemode;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setDimension(int dimension) {
        this.dimension = dimension;
    }

    public long getPartialHashedSeed() {
        return this.partialHashedSeed;
    }

    public short getDifficulty() {
        return this.difficulty;
    }

    public void setDifficulty(short difficulty) {
        this.difficulty = difficulty;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }

    public @Nullable String getLevelType() {
        return this.levelType;
    }

    public void setLevelType(@Nullable String levelType) {
        this.levelType = levelType;
    }

    public int getViewDistance() {
        return this.viewDistance;
    }

    public void setViewDistance(int viewDistance) {
        this.viewDistance = viewDistance;
    }

    public boolean isReducedDebugInfo() {
        return this.reducedDebugInfo;
    }

    public void setReducedDebugInfo(boolean reducedDebugInfo) {
        this.reducedDebugInfo = reducedDebugInfo;
    }

    public DimensionInfo getDimensionInfo() {
        return this.dimensionInfo;
    }

    public void setDimensionInfo(DimensionInfo dimensionInfo) {
        this.dimensionInfo = dimensionInfo;
    }

    public DimensionRegistry getDimensionRegistry() {
        return this.dimensionRegistry;
    }

    public void setDimensionRegistry(DimensionRegistry dimensionRegistry) {
        this.dimensionRegistry = dimensionRegistry;
    }

    public short getPreviousGamemode() {
        return this.previousGamemode;
    }

    public void setPreviousGamemode(short previousGamemode) {
        this.previousGamemode = previousGamemode;
    }

    public boolean getIsHardcore() {
        return this.isHardcore;
    }

    public void setIsHardcore(boolean isHardcore) {
        this.isHardcore = isHardcore;
    }

    public CompoundBinaryTag getBiomeRegistry() {
        return this.biomeRegistry;
    }

    public void setBiomeRegistry(CompoundBinaryTag biomeRegistry) {
        this.biomeRegistry = biomeRegistry;
    }

    public DimensionData getCurrentDimensionData() {
        return this.currentDimensionData;
    }

    public int getSimulationDistance() {
        return this.simulationDistance;
    }

    public void setSimulationDistance(int simulationDistance) {
        this.simulationDistance = simulationDistance;
    }

    public Pair<String, Long> getLastDeathPosition() {
        return this.lastDeathPosition;
    }

    public void setLastDeathPosition(Pair<String, Long> lastDeathPosition) {
        this.lastDeathPosition = lastDeathPosition;
    }

    public CompoundBinaryTag getChatTypeRegistry() {
        return this.chatTypeRegistry;
    }

    public void setChatTypeRegistry(CompoundBinaryTag chatTypeRegistry) {
        this.chatTypeRegistry = chatTypeRegistry;
    }

    public String toString() {
        return "JoinGame{entityId=" + this.entityId + ", gamemode=" + this.gamemode + ", dimension=" + this.dimension + ", partialHashedSeed=" + this.partialHashedSeed + ", difficulty=" + this.difficulty + ", maxPlayers=" + this.maxPlayers + ", levelType='" + this.levelType + "', viewDistance=" + this.viewDistance + ", reducedDebugInfo=" + this.reducedDebugInfo + ", dimensionRegistry='" + this.dimensionRegistry + "', dimensionInfo='" + this.dimensionInfo + "', previousGamemode=" + this.previousGamemode + ", simulationDistance=" + this.simulationDistance + ", lastDeathPosition='" + this.lastDeathPosition + "'}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_16) >= 0) {
            this.decode116Up(buf, version);
        } else {
            this.decodeLegacy(buf, version);
        }
    }

    private void decodeLegacy(ByteBuf buf, ProtocolVersion version) {
        this.entityId = buf.readInt();
        this.gamemode = buf.readByte();
        this.isHardcore = (this.gamemode & 8) != 0;
        this.gamemode = (short)(this.gamemode & 0xFFFFFFF7);
        this.dimension = version.compareTo(ProtocolVersion.MINECRAFT_1_9_1) >= 0 ? buf.readInt() : (int)buf.readByte();
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_13_2) <= 0) {
            this.difficulty = buf.readUnsignedByte();
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_15) >= 0) {
            this.partialHashedSeed = buf.readLong();
        }
        this.maxPlayers = buf.readUnsignedByte();
        this.levelType = ProtocolUtils.readString(buf, 16);
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_14) >= 0) {
            this.viewDistance = ProtocolUtils.readVarInt(buf);
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
            this.reducedDebugInfo = buf.readBoolean();
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_15) >= 0) {
            this.showRespawnScreen = buf.readBoolean();
        }
    }

    private void decode116Up(ByteBuf buf, ProtocolVersion version) {
        String dimensionIdentifier;
        ListBinaryTag dimensionRegistryContainer;
        this.entityId = buf.readInt();
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_16_2) >= 0) {
            this.isHardcore = buf.readBoolean();
            this.gamemode = buf.readByte();
        } else {
            this.gamemode = buf.readByte();
            this.isHardcore = (this.gamemode & 8) != 0;
            this.gamemode = (short)(this.gamemode & 0xFFFFFFF7);
        }
        this.previousGamemode = buf.readByte();
        ImmutableSet<String> levelNames = ImmutableSet.copyOf(ProtocolUtils.readStringArray(buf));
        CompoundBinaryTag registryContainer = ProtocolUtils.readCompoundTag(buf, JOINGAME_READER);
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_16_2) >= 0) {
            dimensionRegistryContainer = registryContainer.getCompound("minecraft:dimension_type").getList("value", BinaryTagTypes.COMPOUND);
            this.biomeRegistry = registryContainer.getCompound("minecraft:worldgen/biome");
            this.chatTypeRegistry = version.compareTo(ProtocolVersion.MINECRAFT_1_19) >= 0 ? registryContainer.getCompound("minecraft:chat_type") : CompoundBinaryTag.empty();
        } else {
            dimensionRegistryContainer = registryContainer.getList("dimension", BinaryTagTypes.COMPOUND);
        }
        ImmutableSet<DimensionData> readData = DimensionRegistry.fromGameData(dimensionRegistryContainer, version);
        this.dimensionRegistry = new DimensionRegistry(readData, levelNames);
        String levelName = null;
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_16_2) >= 0 && version.compareTo(ProtocolVersion.MINECRAFT_1_19) < 0) {
            CompoundBinaryTag currentDimDataTag = ProtocolUtils.readCompoundTag(buf, JOINGAME_READER);
            dimensionIdentifier = ProtocolUtils.readString(buf);
            this.currentDimensionData = DimensionData.decodeBaseCompoundTag(currentDimDataTag, version).annotateWith(dimensionIdentifier, null);
        } else {
            dimensionIdentifier = ProtocolUtils.readString(buf);
            levelName = ProtocolUtils.readString(buf);
        }
        this.partialHashedSeed = buf.readLong();
        this.maxPlayers = version.compareTo(ProtocolVersion.MINECRAFT_1_16_2) >= 0 ? ProtocolUtils.readVarInt(buf) : (int)buf.readUnsignedByte();
        this.viewDistance = ProtocolUtils.readVarInt(buf);
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_18) >= 0) {
            this.simulationDistance = ProtocolUtils.readVarInt(buf);
        }
        this.reducedDebugInfo = buf.readBoolean();
        this.showRespawnScreen = buf.readBoolean();
        boolean isDebug = buf.readBoolean();
        boolean isFlat = buf.readBoolean();
        this.dimensionInfo = new DimensionInfo(dimensionIdentifier, levelName, isFlat, isDebug);
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_19) >= 0 && buf.readBoolean()) {
            this.lastDeathPosition = Pair.of(ProtocolUtils.readString(buf), buf.readLong());
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_16) >= 0) {
            this.encode116Up(buf, version);
        } else {
            this.encodeLegacy(buf, version);
        }
    }

    private void encodeLegacy(ByteBuf buf, ProtocolVersion version) {
        buf.writeInt(this.entityId);
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_16_2) >= 0) {
            buf.writeBoolean(this.isHardcore);
            buf.writeByte(this.gamemode);
        } else {
            buf.writeByte(this.isHardcore ? this.gamemode | 8 : this.gamemode);
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_9_1) >= 0) {
            buf.writeInt(this.dimension);
        } else {
            buf.writeByte(this.dimension);
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_13_2) <= 0) {
            buf.writeByte(this.difficulty);
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_15) >= 0) {
            buf.writeLong(this.partialHashedSeed);
        }
        buf.writeByte(this.maxPlayers);
        if (this.levelType == null) {
            throw new IllegalStateException("No level type specified.");
        }
        ProtocolUtils.writeString(buf, this.levelType);
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_14) >= 0) {
            ProtocolUtils.writeVarInt(buf, this.viewDistance);
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
            buf.writeBoolean(this.reducedDebugInfo);
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_15) >= 0) {
            buf.writeBoolean(this.showRespawnScreen);
        }
    }

    private void encode116Up(ByteBuf buf, ProtocolVersion version) {
        buf.writeInt(this.entityId);
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_16_2) >= 0) {
            buf.writeBoolean(this.isHardcore);
            buf.writeByte(this.gamemode);
        } else {
            buf.writeByte(this.isHardcore ? this.gamemode | 8 : this.gamemode);
        }
        buf.writeByte(this.previousGamemode);
        ProtocolUtils.writeStringArray(buf, this.dimensionRegistry.getLevelNames().toArray(new String[0]));
        CompoundBinaryTag.Builder registryContainer = CompoundBinaryTag.builder();
        ListBinaryTag encodedDimensionRegistry = this.dimensionRegistry.encodeRegistry(version);
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_16_2) >= 0) {
            CompoundBinaryTag.Builder dimensionRegistryEntry = CompoundBinaryTag.builder();
            dimensionRegistryEntry.putString("type", "minecraft:dimension_type");
            dimensionRegistryEntry.put("value", encodedDimensionRegistry);
            registryContainer.put("minecraft:dimension_type", dimensionRegistryEntry.build());
            registryContainer.put("minecraft:worldgen/biome", this.biomeRegistry);
            if (version.compareTo(ProtocolVersion.MINECRAFT_1_19) >= 0) {
                registryContainer.put("minecraft:chat_type", this.chatTypeRegistry);
            }
        } else {
            registryContainer.put("dimension", encodedDimensionRegistry);
        }
        ProtocolUtils.writeCompoundTag(buf, registryContainer.build());
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_16_2) >= 0 && version.compareTo(ProtocolVersion.MINECRAFT_1_19) < 0) {
            ProtocolUtils.writeCompoundTag(buf, this.currentDimensionData.serializeDimensionDetails());
            ProtocolUtils.writeString(buf, this.dimensionInfo.getRegistryIdentifier());
        } else {
            ProtocolUtils.writeString(buf, this.dimensionInfo.getRegistryIdentifier());
            ProtocolUtils.writeString(buf, this.dimensionInfo.getLevelName());
        }
        buf.writeLong(this.partialHashedSeed);
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_16_2) >= 0) {
            ProtocolUtils.writeVarInt(buf, this.maxPlayers);
        } else {
            buf.writeByte(this.maxPlayers);
        }
        ProtocolUtils.writeVarInt(buf, this.viewDistance);
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_18) >= 0) {
            ProtocolUtils.writeVarInt(buf, this.simulationDistance);
        }
        buf.writeBoolean(this.reducedDebugInfo);
        buf.writeBoolean(this.showRespawnScreen);
        buf.writeBoolean(this.dimensionInfo.isDebugType());
        buf.writeBoolean(this.dimensionInfo.isFlat());
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_19) >= 0) {
            if (this.lastDeathPosition != null) {
                buf.writeBoolean(true);
                ProtocolUtils.writeString(buf, this.lastDeathPosition.key());
                buf.writeLong(this.lastDeathPosition.value());
            } else {
                buf.writeBoolean(false);
            }
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

