/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.event.player.PlayerResourcePackStatusEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class ResourcePackResponse
implements MinecraftPacket {
    private String hash = "";
    private  @MonotonicNonNull PlayerResourcePackStatusEvent.Status status;

    public ResourcePackResponse() {
    }

    public ResourcePackResponse(String hash,  @MonotonicNonNull PlayerResourcePackStatusEvent.Status status) {
        this.hash = hash;
        this.status = status;
    }

    public PlayerResourcePackStatusEvent.Status getStatus() {
        if (this.status == null) {
            throw new IllegalStateException("Packet not yet deserialized");
        }
        return this.status;
    }

    public String getHash() {
        return this.hash;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_9_4) <= 0) {
            this.hash = ProtocolUtils.readString(buf);
        }
        this.status = PlayerResourcePackStatusEvent.Status.values()[ProtocolUtils.readVarInt(buf)];
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_9_4) <= 0) {
            ProtocolUtils.writeString(buf, this.hash);
        }
        ProtocolUtils.writeVarInt(buf, this.status.ordinal());
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    public String toString() {
        return "ResourcePackResponse{hash=" + this.hash + ", status=" + this.status + "}";
    }
}

