/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.util.GameProfile;
import com.velocitypowered.api.util.UuidUtils;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ServerLoginSuccess
implements MinecraftPacket {
    private @Nullable UUID uuid;
    private @Nullable String username;
    private @Nullable List<GameProfile.Property> properties;

    public UUID getUuid() {
        if (this.uuid == null) {
            throw new IllegalStateException("No UUID specified!");
        }
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public String getUsername() {
        if (this.username == null) {
            throw new IllegalStateException("No username specified!");
        }
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public List<GameProfile.Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<GameProfile.Property> properties) {
        this.properties = properties;
    }

    public String toString() {
        return "ServerLoginSuccess{uuid=" + this.uuid + ", username='" + this.username + "', properties='" + this.properties + "'}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        this.uuid = version.compareTo(ProtocolVersion.MINECRAFT_1_19) >= 0 ? ProtocolUtils.readUuid(buf) : (version.compareTo(ProtocolVersion.MINECRAFT_1_16) >= 0 ? ProtocolUtils.readUuidIntArray(buf) : (version.compareTo(ProtocolVersion.MINECRAFT_1_7_6) >= 0 ? UUID.fromString(ProtocolUtils.readString(buf, 36)) : UuidUtils.fromUndashed(ProtocolUtils.readString(buf, 32))));
        this.username = ProtocolUtils.readString(buf, 16);
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_19) >= 0) {
            this.properties = ProtocolUtils.readProperties(buf);
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (this.uuid == null) {
            throw new IllegalStateException("No UUID specified!");
        }
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_19) >= 0) {
            ProtocolUtils.writeUuid(buf, this.uuid);
        } else if (version.compareTo(ProtocolVersion.MINECRAFT_1_16) >= 0) {
            ProtocolUtils.writeUuidIntArray(buf, this.uuid);
        } else if (version.compareTo(ProtocolVersion.MINECRAFT_1_7_6) >= 0) {
            ProtocolUtils.writeString(buf, this.uuid.toString());
        } else {
            ProtocolUtils.writeString(buf, UuidUtils.toUndashed(this.uuid));
        }
        if (this.username == null) {
            throw new IllegalStateException("No username specified!");
        }
        ProtocolUtils.writeString(buf, this.username);
        if (version.compareTo(ProtocolVersion.MINECRAFT_1_19) >= 0) {
            if (this.properties == null) {
                ProtocolUtils.writeVarInt(buf, 0);
            } else {
                ProtocolUtils.writeProperties(buf, this.properties);
            }
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

