/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat;

import com.velocitypowered.api.event.command.CommandExecuteEvent;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import java.time.Instant;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface CommandHandler<T extends MinecraftPacket> {
    public static final Logger logger = LogManager.getLogger(CommandHandler.class);

    public Class<T> packetClass();

    public void handlePlayerCommandInternal(T var1);

    default public boolean handlePlayerCommand(MinecraftPacket packet) {
        if (this.packetClass().isInstance(packet)) {
            this.handlePlayerCommandInternal((MinecraftPacket)this.packetClass().cast(packet));
            return true;
        }
        return false;
    }

    default public CompletableFuture<MinecraftPacket> runCommand(VelocityServer server, ConnectedPlayer player, String command, Function<Boolean, MinecraftPacket> hasRunPacketFunction) {
        return server.getCommandManager().executeImmediatelyAsync(player, command).thenApply(hasRunPacketFunction);
    }

    default public void queueCommandResult(VelocityServer server, ConnectedPlayer player, Function<CommandExecuteEvent, CompletableFuture<MinecraftPacket>> futurePacketCreator, String message, Instant timestamp) {
        player.getChatQueue().queuePacket((CompletableFuture<MinecraftPacket>)((CompletableFuture)((CompletableFuture)server.getCommandManager().callCommandEvent(player, message).thenComposeAsync(futurePacketCreator)).thenApply(pkt -> {
            if (server.getConfiguration().isLogCommandExecutions()) {
                logger.info("{} -> executed command /{}", (Object)player, (Object)message);
            }
            return pkt;
        })).exceptionally(e -> {
            logger.info("Exception occurred while running command for {}", (Object)player.getUsername(), e);
            player.sendMessage(Component.translatable("velocity.command.generic-error", (TextColor)NamedTextColor.RED));
            return null;
        }), timestamp);
    }
}

