/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat.builder;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.packet.chat.builder.ChatBuilderV2;
import com.velocitypowered.proxy.protocol.packet.chat.keyed.KeyedChatBuilder;
import com.velocitypowered.proxy.protocol.packet.chat.legacy.LegacyChatBuilder;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionChatBuilder;
import java.util.function.Function;

public class ChatBuilderFactory {
    private final ProtocolVersion version;
    private final Function<ProtocolVersion, ChatBuilderV2> builderFunction;

    public ChatBuilderFactory(ProtocolVersion version) {
        this.version = version;
        this.builderFunction = version.compareTo(ProtocolVersion.MINECRAFT_1_19_3) >= 0 ? SessionChatBuilder::new : (version.compareTo(ProtocolVersion.MINECRAFT_1_19) >= 0 ? KeyedChatBuilder::new : LegacyChatBuilder::new);
    }

    public ChatBuilderV2 builder() {
        return this.builderFunction.apply(this.version);
    }
}

