/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat.legacy;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.Nullable;

public class LegacyChat
implements MinecraftPacket {
    public static final byte CHAT_TYPE = 0;
    public static final byte SYSTEM_TYPE = 1;
    public static final byte GAME_INFO_TYPE = 2;
    public static final int MAX_SERVERBOUND_MESSAGE_LENGTH = 256;
    public static final UUID EMPTY_SENDER = new UUID(0L, 0L);
    private @Nullable String message;
    private byte type;
    private @Nullable UUID sender;

    public LegacyChat() {
    }

    public LegacyChat(String message, byte type, UUID sender) {
        this.message = message;
        this.type = type;
        this.sender = sender;
    }

    public String getMessage() {
        if (this.message == null) {
            throw new IllegalStateException("Message is not specified");
        }
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public UUID getSenderUuid() {
        return this.sender;
    }

    public void setSenderUuid(UUID sender) {
        this.sender = sender;
    }

    public String toString() {
        return "Chat{message='" + this.message + "', type=" + this.type + ", sender=" + this.sender + "}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        this.message = ProtocolUtils.readString(buf);
        if (direction == ProtocolUtils.Direction.CLIENTBOUND && version.compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
            this.type = buf.readByte();
            if (version.compareTo(ProtocolVersion.MINECRAFT_1_16) >= 0) {
                this.sender = ProtocolUtils.readUuid(buf);
            }
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (this.message == null) {
            throw new IllegalStateException("Message is not specified");
        }
        ProtocolUtils.writeString(buf, this.message);
        if (direction == ProtocolUtils.Direction.CLIENTBOUND && version.compareTo(ProtocolVersion.MINECRAFT_1_8) >= 0) {
            buf.writeByte(this.type);
            if (version.compareTo(ProtocolVersion.MINECRAFT_1_16) >= 0) {
                ProtocolUtils.writeUuid(buf, this.sender == null ? EMPTY_SENDER : this.sender);
            }
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

