/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat.session;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.packet.chat.ChatType;
import com.velocitypowered.proxy.protocol.packet.chat.LastSeenMessages;
import com.velocitypowered.proxy.protocol.packet.chat.SystemChat;
import com.velocitypowered.proxy.protocol.packet.chat.builder.ChatBuilderV2;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionPlayerChat;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionPlayerCommand;
import net.kyori.adventure.text.Component;

public class SessionChatBuilder
extends ChatBuilderV2 {
    public SessionChatBuilder(ProtocolVersion version) {
        super(version);
    }

    @Override
    public MinecraftPacket toClient() {
        Component msg = this.component == null ? Component.text(this.message) : this.component;
        return new SystemChat(msg, this.type == ChatType.CHAT ? ChatType.SYSTEM : this.type);
    }

    @Override
    public MinecraftPacket toServer() {
        if (this.message.startsWith("/")) {
            SessionPlayerCommand command = new SessionPlayerCommand();
            command.command = this.message.substring(1);
            command.salt = 0L;
            command.timeStamp = this.timestamp;
            command.argumentSignatures = new SessionPlayerCommand.ArgumentSignatures();
            command.lastSeenMessages = new LastSeenMessages();
            return command;
        }
        SessionPlayerChat chat = new SessionPlayerChat();
        chat.message = this.message;
        chat.signed = false;
        chat.signature = new byte[0];
        chat.timestamp = this.timestamp;
        chat.salt = 0L;
        chat.lastSeenMessages = new LastSeenMessages();
        return chat;
    }
}

