/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.registry;

import com.velocitypowered.proxy.connection.player.VelocityResourcePackInfo;
import com.velocitypowered.proxy.connection.registry.DataTag;
import com.velocitypowered.proxy.protocol.packet.config.RegistrySync;
import net.kyori.adventure.key.Key;
import org.jetbrains.annotations.Nullable;

public class ClientConfigData {
    @Nullable
    private final VelocityResourcePackInfo resourcePackInfo;
    private final DataTag tag;
    private final RegistrySync registry;
    private final Key[] features;
    private final String brand;

    private ClientConfigData(@Nullable VelocityResourcePackInfo resourcePackInfo, DataTag tag, RegistrySync registry, Key[] features, String brand) {
        this.resourcePackInfo = resourcePackInfo;
        this.tag = tag;
        this.registry = registry;
        this.features = features;
        this.brand = brand;
    }

    public RegistrySync getRegistry() {
        return this.registry;
    }

    public DataTag getTag() {
        return this.tag;
    }

    public Key[] getFeatures() {
        return this.features;
    }

    @Nullable
    public VelocityResourcePackInfo getResourcePackInfo() {
        return this.resourcePackInfo;
    }

    public String getBrand() {
        return this.brand;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private VelocityResourcePackInfo resourcePackInfo;
        private DataTag tag;
        private RegistrySync registry;
        private Key[] features;
        private String brand;

        private Builder() {
        }

        public void clear() {
            this.resourcePackInfo = null;
            this.tag = null;
            this.registry = null;
            this.features = null;
            this.brand = null;
        }

        public Builder resourcePack(@Nullable VelocityResourcePackInfo resourcePackInfo) {
            this.resourcePackInfo = resourcePackInfo;
            return this;
        }

        public Builder dataTag(DataTag tag) {
            this.tag = tag;
            return this;
        }

        public Builder registry(RegistrySync registry) {
            this.registry = registry;
            return this;
        }

        public Builder features(Key[] features) {
            this.features = features;
            return this;
        }

        public Builder brand(String brand) {
            this.brand = brand;
            return this;
        }

        public ClientConfigData build() {
            return new ClientConfigData(this.resourcePackInfo, this.tag, this.registry, this.features, this.brand);
        }
    }
}

