/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat.keyed;

import com.google.common.collect.ImmutableMap;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.crypto.EncryptionUtils;
import com.velocitypowered.proxy.crypto.SignaturePair;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.chat.keyed.KeyedPlayerChat;
import com.velocitypowered.proxy.util.except.QuietDecoderException;
import io.netty.buffer.ByteBuf;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.Nullable;

public class KeyedPlayerCommand
implements MinecraftPacket {
    private static final int MAX_NUM_ARGUMENTS = 8;
    private static final int MAX_LENGTH_ARGUMENTS = 16;
    private static final QuietDecoderException LIMITS_VIOLATION = new QuietDecoderException("Command arguments incorrect size");
    private boolean unsigned = false;
    private String command;
    private Instant timestamp;
    private long salt;
    private boolean signedPreview;
    private SignaturePair[] previousMessages = new SignaturePair[0];
    private @Nullable SignaturePair lastMessage;
    private Map<String, byte[]> arguments = ImmutableMap.of();

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public boolean isUnsigned() {
        return this.unsigned;
    }

    public String getCommand() {
        return this.command;
    }

    public KeyedPlayerCommand() {
    }

    public KeyedPlayerCommand(String command, List<String> arguments, Instant timestamp) {
        this.unsigned = true;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        arguments.forEach(entry -> builder.put(entry, EncryptionUtils.EMPTY));
        this.arguments = builder.build();
        this.timestamp = timestamp;
        this.command = command;
        this.signedPreview = false;
        this.salt = 0L;
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        this.command = ProtocolUtils.readString(buf, 256);
        this.timestamp = Instant.ofEpochMilli(buf.readLong());
        this.salt = buf.readLong();
        int mapSize = ProtocolUtils.readVarInt(buf);
        if (mapSize > 8) {
            throw LIMITS_VIOLATION;
        }
        ImmutableMap.Builder<String, byte[]> entries = ImmutableMap.builderWithExpectedSize(mapSize);
        for (int i = 0; i < mapSize; ++i) {
            entries.put(ProtocolUtils.readString(buf, 16), ProtocolUtils.readByteArray(buf, this.unsigned ? 0 : 65536));
        }
        this.arguments = entries.build();
        this.signedPreview = buf.readBoolean();
        if (this.unsigned && this.signedPreview) {
            throw EncryptionUtils.PREVIEW_SIGNATURE_MISSING;
        }
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19_1) >= 0) {
            int size = ProtocolUtils.readVarInt(buf);
            if (size < 0 || size > 5) {
                throw KeyedPlayerChat.INVALID_PREVIOUS_MESSAGES;
            }
            SignaturePair[] lastSignatures = new SignaturePair[size];
            for (int i = 0; i < size; ++i) {
                lastSignatures[i] = new SignaturePair(ProtocolUtils.readUuid(buf), ProtocolUtils.readByteArray(buf));
            }
            this.previousMessages = lastSignatures;
            if (buf.readBoolean()) {
                this.lastMessage = new SignaturePair(ProtocolUtils.readUuid(buf), ProtocolUtils.readByteArray(buf));
            }
        }
        if (this.salt == 0L && this.previousMessages.length == 0) {
            this.unsigned = true;
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        ProtocolUtils.writeString(buf, this.command);
        buf.writeLong(this.timestamp.toEpochMilli());
        buf.writeLong(this.unsigned ? 0L : this.salt);
        int size = this.arguments.size();
        if (size > 8) {
            throw LIMITS_VIOLATION;
        }
        ProtocolUtils.writeVarInt(buf, size);
        for (Map.Entry<String, byte[]> entry : this.arguments.entrySet()) {
            ProtocolUtils.writeString(buf, entry.getKey());
            ProtocolUtils.writeByteArray(buf, this.unsigned ? EncryptionUtils.EMPTY : entry.getValue());
        }
        buf.writeBoolean(this.signedPreview);
        if (protocolVersion.compareTo(ProtocolVersion.MINECRAFT_1_19_1) >= 0) {
            ProtocolUtils.writeVarInt(buf, this.previousMessages.length);
            for (SignaturePair previousMessage : this.previousMessages) {
                ProtocolUtils.writeUuid(buf, previousMessage.getSigner());
                ProtocolUtils.writeByteArray(buf, previousMessage.getSignature());
            }
            if (this.lastMessage != null) {
                buf.writeBoolean(true);
                ProtocolUtils.writeUuid(buf, this.lastMessage.getSigner());
                ProtocolUtils.writeByteArray(buf, this.lastMessage.getSignature());
            } else {
                buf.writeBoolean(false);
            }
        }
    }

    public String toString() {
        return "PlayerCommand{unsigned=" + this.unsigned + ", command='" + this.command + "', timestamp=" + this.timestamp + ", salt=" + this.salt + ", signedPreview=" + this.signedPreview + ", previousMessages=" + Arrays.toString(this.previousMessages) + ", arguments=" + this.arguments + "}";
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }
}

