/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.player;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.ResultedEvent;
import com.velocitypowered.api.event.annotation.AwaitingEvent;
import com.velocitypowered.api.proxy.Player;
import net.kyori.adventure.key.Key;

@AwaitingEvent
public final class CookieRequestEvent
implements ResultedEvent<ForwardResult> {
    private final Player player;
    private final Key originalKey;
    private ForwardResult result;

    public CookieRequestEvent(Player player, Key key) {
        this.player = Preconditions.checkNotNull(player, "player");
        this.originalKey = Preconditions.checkNotNull(key, "key");
        this.result = ForwardResult.forward();
    }

    @Override
    public ForwardResult getResult() {
        return this.result;
    }

    @Override
    public void setResult(ForwardResult result) {
        this.result = Preconditions.checkNotNull(result, "result");
    }

    public Player getPlayer() {
        return this.player;
    }

    public Key getOriginalKey() {
        return this.originalKey;
    }

    public String toString() {
        return "CookieRequestEvent{, originalKey=" + this.originalKey + ", result=" + this.result + "}";
    }

    public static final class ForwardResult
    implements ResultedEvent.Result {
        private static final ForwardResult ALLOWED = new ForwardResult(true, null);
        private static final ForwardResult DENIED = new ForwardResult(false, null);
        private final boolean status;
        private final Key key;

        private ForwardResult(boolean status, Key key) {
            this.status = status;
            this.key = key;
        }

        @Override
        public boolean isAllowed() {
            return this.status;
        }

        public Key getKey() {
            return this.key;
        }

        public String toString() {
            return this.status ? "forward to client" : "handled by proxy";
        }

        public static ForwardResult forward() {
            return ALLOWED;
        }

        public static ForwardResult handled() {
            return DENIED;
        }

        public static ForwardResult key(Key key) {
            Preconditions.checkNotNull(key, "key");
            return new ForwardResult(true, key);
        }
    }
}

