/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.api.event.player;

import com.google.common.base.Preconditions;
import com.velocitypowered.api.event.annotation.AwaitingEvent;
import com.velocitypowered.api.proxy.Player;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import java.util.Optional;
import org.checkerframework.checker.nullness.qual.Nullable;

@AwaitingEvent
public final class ServerConnectedEvent {
    private final Player player;
    private final RegisteredServer server;
    private final @Nullable RegisteredServer previousServer;

    public ServerConnectedEvent(Player player, RegisteredServer server, @Nullable RegisteredServer previousServer) {
        this.player = Preconditions.checkNotNull(player, "player");
        this.server = Preconditions.checkNotNull(server, "server");
        this.previousServer = previousServer;
    }

    public Player getPlayer() {
        return this.player;
    }

    public RegisteredServer getServer() {
        return this.server;
    }

    public Optional<RegisteredServer> getPreviousServer() {
        return Optional.ofNullable(this.previousServer);
    }

    public String toString() {
        return "ServerConnectedEvent{player=" + this.player + ", server=" + this.server + ", previousServer=" + this.previousServer + "}";
    }
}

