/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.command.builtin;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.velocitypowered.api.command.BrigadierCommand;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.permission.Tristate;
import com.velocitypowered.api.plugin.PluginContainer;
import com.velocitypowered.api.plugin.PluginDescription;
import com.velocitypowered.api.proxy.ProxyServer;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.util.ProxyVersion;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.util.InformationUtils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.management.MBeanServer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class VelocityCommand {
    private static final String USAGE = "/velocity <%s>";

    public static BrigadierCommand create(VelocityServer server) {
        CommandNode dump = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder("dump").requires(source -> source.getPermissionValue("velocity.command.dump") == Tristate.TRUE)).executes(new Dump(server))).build();
        CommandNode heap = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder("heap").requires(source -> source.getPermissionValue("velocity.command.heap") == Tristate.TRUE)).executes(new Heap())).build();
        CommandNode info = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder("info").requires(source -> source.getPermissionValue("velocity.command.info") != Tristate.FALSE)).executes(new Info(server))).build();
        CommandNode plugins = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder("plugins").requires(source -> source.getPermissionValue("velocity.command.plugins") == Tristate.TRUE)).executes(new Plugins(server))).build();
        CommandNode reload = ((LiteralArgumentBuilder)((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder("reload").requires(source -> source.getPermissionValue("velocity.command.reload") == Tristate.TRUE)).executes(new Reload(server))).build();
        List<CommandNode> commands = List.of(dump, heap, info, plugins, reload);
        return new BrigadierCommand(commands.stream().reduce((LiteralArgumentBuilder)((LiteralArgumentBuilder)BrigadierCommand.literalArgumentBuilder("velocity").executes(ctx -> {
            CommandSource source = (CommandSource)ctx.getSource();
            String availableCommands = commands.stream().filter(e -> e.getRequirement().test(source)).map(LiteralCommandNode::getName).collect(Collectors.joining("|"));
            String commandText = USAGE.formatted(availableCommands);
            source.sendMessage(Component.text(commandText, (TextColor)NamedTextColor.RED));
            return 1;
        })).requires(commands.stream().map(CommandNode::getRequirement).reduce(Predicate::or).orElseThrow()), ArgumentBuilder::then, ArgumentBuilder::then));
    }

    private record Dump(ProxyServer server) implements Command<CommandSource>
    {
        private static final Logger logger = LogManager.getLogger(Dump.class);

        @Override
        public int run(CommandContext<CommandSource> context) {
            CommandSource source = context.getSource();
            Set<RegisteredServer> allServers = Set.copyOf(this.server.getAllServers());
            JsonObject servers = new JsonObject();
            for (RegisteredServer iter : allServers) {
                servers.add(iter.getServerInfo().getName(), InformationUtils.collectServerInfo(iter));
            }
            JsonArray connectOrder = new JsonArray();
            List<String> attemptedConnectionOrder = List.copyOf(this.server.getConfiguration().getAttemptConnectionOrder());
            for (String s : attemptedConnectionOrder) {
                connectOrder.add(s);
            }
            JsonObject proxyConfig = InformationUtils.collectProxyConfig(this.server.getConfiguration());
            proxyConfig.add("servers", servers);
            proxyConfig.add("connectOrder", connectOrder);
            proxyConfig.add("forcedHosts", InformationUtils.collectForcedHosts(this.server.getConfiguration()));
            JsonObject dump = new JsonObject();
            dump.add("versionInfo", InformationUtils.collectProxyInfo(this.server.getVersion()));
            dump.add("platform", InformationUtils.collectEnvironmentInfo());
            dump.add("config", proxyConfig);
            dump.add("plugins", InformationUtils.collectPluginInfo(this.server));
            Path dumpPath = Path.of("velocity-dump-" + new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(new Date()) + ".json", new String[0]);
            try (BufferedWriter bw = Files.newBufferedWriter(dumpPath, StandardCharsets.UTF_8, StandardOpenOption.CREATE_NEW);){
                bw.write(InformationUtils.toHumanReadableString(dump));
                source.sendMessage(Component.text("An anonymised report containing useful information about this proxy has been saved at " + dumpPath.toAbsolutePath(), (TextColor)NamedTextColor.GREEN));
            }
            catch (IOException e) {
                logger.error("Failed to complete dump command, the executor was interrupted: " + e.getMessage(), (Throwable)e);
                source.sendMessage(Component.text("We could not save the anonymized dump. Check the console for more details.", (TextColor)NamedTextColor.RED));
            }
            return 1;
        }
    }

    public static final class Heap
    implements Command<CommandSource> {
        private static final Logger logger = LogManager.getLogger(Heap.class);
        private MethodHandle heapGenerator;
        private Consumer<CommandSource> heapConsumer;
        private final Path dir = Path.of("./dumps", new String[0]);

        @Override
        public int run(CommandContext<CommandSource> context) throws CommandSyntaxException {
            CommandSource source = context.getSource();
            try {
                if (Files.notExists(this.dir, new LinkOption[0])) {
                    Files.createDirectories(this.dir, new FileAttribute[0]);
                }
                if (this.heapGenerator == null || this.heapConsumer == null) {
                    MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                    MethodHandles.Lookup lookup = MethodHandles.lookup();
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss");
                    try {
                        Class<?> clazz = Class.forName("openj9.lang.management.OpenJ9DiagnosticsMXBean");
                        MethodType type = MethodType.methodType(String.class, String.class, String.class);
                        this.heapGenerator = lookup.findVirtual(clazz, "triggerDumpToFile", type);
                        this.heapConsumer = src -> {
                            String name = "heap-dump-" + format.format(new Date());
                            Path file = this.dir.resolve(name + ".phd");
                            try {
                                Object openj9Mbean = ManagementFactory.newPlatformMXBeanProxy(server, "openj9.lang.management:type=OpenJ9Diagnostics", clazz);
                                this.heapGenerator.invoke(openj9Mbean, "heap", file.toString());
                            }
                            catch (Throwable e) {
                                throw new RuntimeException(e);
                            }
                            src.sendMessage(Component.text("Heap dump saved to " + file, (TextColor)NamedTextColor.GREEN));
                        };
                    }
                    catch (ClassNotFoundException e) {
                        Class<?> clazz = Class.forName("com.sun.management.HotSpotDiagnosticMXBean");
                        MethodType type = MethodType.methodType(Void.TYPE, String.class, Boolean.TYPE);
                        this.heapGenerator = lookup.findVirtual(clazz, "dumpHeap", type);
                        this.heapConsumer = src -> {
                            String name = "heap-dump-" + format.format(new Date());
                            Path file = this.dir.resolve(name + ".hprof");
                            try {
                                Object hotspotMbean = ManagementFactory.newPlatformMXBeanProxy(server, "com.sun.management:type=HotSpotDiagnostic", clazz);
                                this.heapGenerator.invoke(hotspotMbean, file.toString(), true);
                            }
                            catch (Throwable e1) {
                                throw new RuntimeException(e1);
                            }
                            src.sendMessage(Component.text("Heap dump saved to " + file, (TextColor)NamedTextColor.GREEN));
                        };
                    }
                }
                this.heapConsumer.accept(source);
            }
            catch (Throwable t) {
                source.sendMessage(Component.text("Failed to write heap dump, see server log for details", (TextColor)NamedTextColor.RED));
                logger.error("Could not write heap", t);
            }
            return 1;
        }
    }

    private record Info(ProxyServer server) implements Command<CommandSource>
    {
        private static final TextColor VELOCITY_COLOR = TextColor.color(634323);

        @Override
        public int run(CommandContext<CommandSource> context) {
            CommandSource source = context.getSource();
            ProxyVersion version = this.server.getVersion();
            Object velocity = ((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(version.getName() + " ").decoration(TextDecoration.BOLD, true)).color(VELOCITY_COLOR)).append((ComponentBuilder<?, ?>)Component.text().content(version.getVersion()).decoration(TextDecoration.BOLD, false))).build();
            TranslatableComponent copyright = Component.translatable("velocity.command.version-copyright", Component.text(version.getVendor()), Component.text(version.getName()), Component.text(LocalDate.now().getYear()));
            source.sendMessage((Component)velocity);
            source.sendMessage(copyright);
            if (version.getName().equals("Velocity")) {
                TextComponent embellishment = (TextComponent)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().append((Component)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("velocitypowered.com").color(NamedTextColor.GREEN)).clickEvent(ClickEvent.openUrl("https://velocitypowered.com"))).build())).append((Component)Component.text(" - "))).append((Component)((TextComponent.Builder)((TextComponent.Builder)((TextComponent.Builder)Component.text().content("GitHub").color(NamedTextColor.GREEN)).decoration(TextDecoration.UNDERLINED, true)).clickEvent(ClickEvent.openUrl("https://github.com/PaperMC/Velocity"))).build())).build();
                source.sendMessage(embellishment);
            }
            return 1;
        }
    }

    private record Plugins(ProxyServer server) implements Command<CommandSource>
    {
        @Override
        public int run(CommandContext<CommandSource> context) {
            CommandSource source = context.getSource();
            List<PluginContainer> plugins = List.copyOf(this.server.getPluginManager().getPlugins());
            int pluginCount = plugins.size();
            if (pluginCount == 0) {
                source.sendMessage(Component.translatable("velocity.command.no-plugins", (TextColor)NamedTextColor.YELLOW));
                return 1;
            }
            TextComponent.Builder listBuilder = Component.text();
            for (int i = 0; i < pluginCount; ++i) {
                PluginContainer plugin = plugins.get(i);
                listBuilder.append((Component)this.componentForPlugin(plugin.getDescription()));
                if (i + 1 >= pluginCount) continue;
                listBuilder.append((Component)Component.text(", "));
            }
            TranslatableComponent output = (TranslatableComponent)((TranslatableComponent.Builder)Component.translatable().key("velocity.command.plugins-list").color(NamedTextColor.YELLOW)).arguments(new ComponentLike[]{listBuilder.build()}).build();
            source.sendMessage(output);
            return 1;
        }

        private TextComponent componentForPlugin(PluginDescription description) {
            String pluginInfo = description.getName().orElse(description.getId()) + description.getVersion().map(v -> " " + v).orElse("");
            TextComponent.Builder hoverText = Component.text().content(pluginInfo);
            description.getUrl().ifPresent(url -> {
                hoverText.append((Component)Component.newline());
                hoverText.append((Component)Component.translatable("velocity.command.plugin-tooltip-website", Component.text(url)));
            });
            if (!description.getAuthors().isEmpty()) {
                hoverText.append((Component)Component.newline());
                if (description.getAuthors().size() == 1) {
                    hoverText.append((Component)Component.translatable("velocity.command.plugin-tooltip-author", Component.text(description.getAuthors().get(0))));
                } else {
                    hoverText.append((Component)Component.translatable("velocity.command.plugin-tooltip-author", Component.text(String.join((CharSequence)", ", description.getAuthors()))));
                }
            }
            description.getDescription().ifPresent(pdesc -> {
                hoverText.append((Component)Component.newline());
                hoverText.append((Component)Component.newline());
                hoverText.append((Component)Component.text(pdesc));
            });
            return (TextComponent)((TextComponent.Builder)((TextComponent.Builder)Component.text().content(description.getId()).color(NamedTextColor.GRAY)).hoverEvent(HoverEvent.showText((Component)hoverText.build()))).build();
        }
    }

    private record Reload(VelocityServer server) implements Command<CommandSource>
    {
        private static final Logger logger = LogManager.getLogger(Reload.class);

        @Override
        public int run(CommandContext<CommandSource> context) {
            CommandSource source = context.getSource();
            try {
                if (this.server.reloadConfiguration()) {
                    source.sendMessage(Component.translatable("velocity.command.reload-success", (TextColor)NamedTextColor.GREEN));
                } else {
                    source.sendMessage(Component.translatable("velocity.command.reload-failure", (TextColor)NamedTextColor.RED));
                }
            }
            catch (Exception e) {
                logger.error("Unable to reload configuration", (Throwable)e);
                source.sendMessage(Component.translatable("velocity.command.reload-failure", (TextColor)NamedTextColor.RED));
            }
            return 1;
        }
    }
}

