/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.client;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.suggestion.Suggestion;
import com.velocitypowered.api.command.VelocityBrigadierMessage;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.player.CookieReceiveEvent;
import com.velocitypowered.api.event.player.PlayerChannelRegisterEvent;
import com.velocitypowered.api.event.player.PlayerClientBrandEvent;
import com.velocitypowered.api.event.player.TabCompleteEvent;
import com.velocitypowered.api.event.player.configuration.PlayerEnteredConfigurationEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.messages.LegacyChannelIdentifier;
import com.velocitypowered.api.proxy.messages.MinecraftChannelIdentifier;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.connection.ConnectionTypes;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.backend.BackendConnectionPhases;
import com.velocitypowered.proxy.connection.backend.BungeeCordMessageResponder;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.player.resourcepack.ResourcePackResponseBundle;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.packet.BossBarPacket;
import com.velocitypowered.proxy.protocol.packet.ClientSettingsPacket;
import com.velocitypowered.proxy.protocol.packet.JoinGamePacket;
import com.velocitypowered.proxy.protocol.packet.KeepAlivePacket;
import com.velocitypowered.proxy.protocol.packet.PluginMessagePacket;
import com.velocitypowered.proxy.protocol.packet.ResourcePackResponsePacket;
import com.velocitypowered.proxy.protocol.packet.RespawnPacket;
import com.velocitypowered.proxy.protocol.packet.ServerboundCookieResponsePacket;
import com.velocitypowered.proxy.protocol.packet.TabCompleteRequestPacket;
import com.velocitypowered.proxy.protocol.packet.TabCompleteResponsePacket;
import com.velocitypowered.proxy.protocol.packet.chat.ChatAcknowledgementPacket;
import com.velocitypowered.proxy.protocol.packet.chat.ChatHandler;
import com.velocitypowered.proxy.protocol.packet.chat.ChatTimeKeeper;
import com.velocitypowered.proxy.protocol.packet.chat.CommandHandler;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import com.velocitypowered.proxy.protocol.packet.chat.keyed.KeyedChatHandler;
import com.velocitypowered.proxy.protocol.packet.chat.keyed.KeyedCommandHandler;
import com.velocitypowered.proxy.protocol.packet.chat.keyed.KeyedPlayerChatPacket;
import com.velocitypowered.proxy.protocol.packet.chat.keyed.KeyedPlayerCommandPacket;
import com.velocitypowered.proxy.protocol.packet.chat.legacy.LegacyChatHandler;
import com.velocitypowered.proxy.protocol.packet.chat.legacy.LegacyChatPacket;
import com.velocitypowered.proxy.protocol.packet.chat.legacy.LegacyCommandHandler;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionChatHandler;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionCommandHandler;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionPlayerChatPacket;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionPlayerCommandPacket;
import com.velocitypowered.proxy.protocol.packet.config.FinishedUpdatePacket;
import com.velocitypowered.proxy.protocol.packet.title.GenericTitlePacket;
import com.velocitypowered.proxy.protocol.util.PluginMessageUtil;
import com.velocitypowered.proxy.util.CharacterUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.util.ReferenceCountUtil;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ClientPlaySessionHandler
implements MinecraftSessionHandler {
    private static final Logger logger = LogManager.getLogger(ClientPlaySessionHandler.class);
    private final ConnectedPlayer player;
    private boolean spawned = false;
    private final List<UUID> serverBossBars = new ArrayList<UUID>();
    private final Queue<PluginMessagePacket> loginPluginMessages = new ConcurrentLinkedQueue<PluginMessagePacket>();
    private final VelocityServer server;
    private @Nullable TabCompleteRequestPacket outstandingTabComplete;
    private final ChatHandler<? extends MinecraftPacket> chatHandler;
    private final CommandHandler<? extends MinecraftPacket> commandHandler;
    private final ChatTimeKeeper timeKeeper = new ChatTimeKeeper();
    private CompletableFuture<Void> configSwitchFuture;

    public ClientPlaySessionHandler(VelocityServer server, ConnectedPlayer player) {
        this.player = player;
        this.server = server;
        if (this.player.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_19_3)) {
            this.chatHandler = new SessionChatHandler(this.player, this.server);
            this.commandHandler = new SessionCommandHandler(this.player, this.server);
        } else if (this.player.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_19)) {
            this.chatHandler = new KeyedChatHandler(this.server, this.player);
            this.commandHandler = new KeyedCommandHandler(this.player, this.server);
        } else {
            this.chatHandler = new LegacyChatHandler(this.server, this.player);
            this.commandHandler = new LegacyCommandHandler(this.player, this.server);
        }
    }

    private boolean updateTimeKeeper(@Nullable Instant instant) {
        if (instant == null) {
            return true;
        }
        if (!this.timeKeeper.update(instant)) {
            this.player.disconnect(Component.translatable("multiplayer.disconnect.out_of_order_chat"));
            return false;
        }
        return true;
    }

    private boolean validateChat(String message) {
        if (CharacterUtil.containsIllegalCharacters(message)) {
            this.player.disconnect(Component.translatable("velocity.error.illegal-chat-characters", (TextColor)NamedTextColor.RED));
            return false;
        }
        return true;
    }

    @Override
    public void activated() {
        this.configSwitchFuture = new CompletableFuture();
        Collection<String> channels = this.server.getChannelRegistrar().getChannelsForProtocol(this.player.getProtocolVersion());
        if (!channels.isEmpty()) {
            PluginMessagePacket register = PluginMessageUtil.constructChannelsPacket(this.player.getProtocolVersion(), channels);
            this.player.getConnection().write(register);
        }
    }

    @Override
    public void deactivated() {
        for (PluginMessagePacket message : this.loginPluginMessages) {
            ReferenceCountUtil.release(message);
        }
    }

    @Override
    public boolean handle(KeepAlivePacket packet) {
        this.player.forwardKeepAlive(packet);
        return true;
    }

    @Override
    public boolean handle(ClientSettingsPacket packet) {
        this.player.setClientSettings(packet);
        VelocityServerConnection serverConnection = this.player.getConnectedServer();
        if (serverConnection == null) {
            return true;
        }
        this.player.getConnectedServer().ensureConnected().write(packet);
        return true;
    }

    @Override
    public boolean handle(SessionPlayerCommandPacket packet) {
        if (this.player.getCurrentServer().isEmpty()) {
            return true;
        }
        if (!this.updateTimeKeeper(packet.getTimeStamp())) {
            return true;
        }
        if (!this.validateChat(packet.getCommand())) {
            return true;
        }
        return this.commandHandler.handlePlayerCommand(packet);
    }

    @Override
    public boolean handle(SessionPlayerChatPacket packet) {
        if (this.player.getCurrentServer().isEmpty()) {
            return true;
        }
        if (!this.updateTimeKeeper(packet.getTimestamp())) {
            return true;
        }
        if (!this.validateChat(packet.getMessage())) {
            return true;
        }
        return this.chatHandler.handlePlayerChat(packet);
    }

    @Override
    public boolean handle(KeyedPlayerCommandPacket packet) {
        if (this.player.getCurrentServer().isEmpty()) {
            return true;
        }
        if (!this.updateTimeKeeper(packet.getTimestamp())) {
            return true;
        }
        if (!this.validateChat(packet.getCommand())) {
            return true;
        }
        return this.commandHandler.handlePlayerCommand(packet);
    }

    @Override
    public boolean handle(KeyedPlayerChatPacket packet) {
        if (this.player.getCurrentServer().isEmpty()) {
            return true;
        }
        if (!this.updateTimeKeeper(packet.getExpiry())) {
            return true;
        }
        if (!this.validateChat(packet.getMessage())) {
            return true;
        }
        return this.chatHandler.handlePlayerChat(packet);
    }

    @Override
    public boolean handle(LegacyChatPacket packet) {
        if (this.player.getCurrentServer().isEmpty()) {
            return true;
        }
        String msg = packet.getMessage();
        if (!this.validateChat(msg)) {
            return true;
        }
        if (msg.startsWith("/")) {
            this.commandHandler.handlePlayerCommand(packet);
        } else {
            this.chatHandler.handlePlayerChat(packet);
        }
        return true;
    }

    @Override
    public boolean handle(TabCompleteRequestPacket packet) {
        boolean isCommand;
        boolean bl = isCommand = !packet.isAssumeCommand() && packet.getCommand().startsWith("/");
        if (isCommand) {
            return this.handleCommandTabComplete(packet);
        }
        return this.handleRegularTabComplete(packet);
    }

    @Override
    public boolean handle(PluginMessagePacket packet) {
        MinecraftConnection backendConn;
        VelocityServerConnection serverConn = this.player.getConnectedServer() == null && packet.getChannel().equals("FML|HS") ? this.player.getConnectionInFlight() : this.player.getConnectedServer();
        MinecraftConnection minecraftConnection = backendConn = serverConn != null ? serverConn.getConnection() : null;
        if (serverConn != null && backendConn != null) {
            if (backendConn.getState() != StateRegistry.PLAY) {
                logger.warn("A plugin message was received while the backend server was not ready. Channel: {}. Packet discarded.", (Object)packet.getChannel());
            } else if (PluginMessageUtil.isRegister(packet)) {
                List<String> channels = PluginMessageUtil.getChannels(packet);
                ArrayList<ChannelIdentifier> channelIdentifiers = new ArrayList<ChannelIdentifier>();
                for (String channel : channels) {
                    try {
                        channelIdentifiers.add(MinecraftChannelIdentifier.from(channel));
                    }
                    catch (IllegalArgumentException e) {
                        channelIdentifiers.add(new LegacyChannelIdentifier(channel));
                    }
                }
                this.server.getEventManager().fireAndForget(new PlayerChannelRegisterEvent(this.player, ImmutableList.copyOf(channelIdentifiers)));
                backendConn.write(packet.retain());
            } else if (PluginMessageUtil.isUnregister(packet)) {
                backendConn.write(packet.retain());
            } else if (PluginMessageUtil.isMcBrand(packet)) {
                String brand = PluginMessageUtil.readBrandMessage(packet.content());
                this.server.getEventManager().fireAndForget(new PlayerClientBrandEvent(this.player, brand));
                this.player.setClientBrand(brand);
                backendConn.write(packet.retain());
            } else {
                if (BungeeCordMessageResponder.isBungeeCordMessage(packet)) {
                    return true;
                }
                if (serverConn.getPhase() == BackendConnectionPhases.IN_TRANSITION) {
                    VelocityServerConnection inFlight = this.player.getConnectionInFlight();
                    if (inFlight != null) {
                        this.player.getPhase().handle(this.player, packet, inFlight);
                    }
                    return true;
                }
                if (!this.player.getPhase().handle(this.player, packet, serverConn)) {
                    ChannelIdentifier id = this.server.getChannelRegistrar().getFromId(packet.getChannel());
                    if (id == null) {
                        if (!this.player.getPhase().consideredComplete() || !serverConn.getPhase().consideredComplete()) {
                            this.loginPluginMessages.add(packet.retain());
                        } else {
                            backendConn.write(packet.retain());
                        }
                    } else {
                        byte[] copy = ByteBufUtil.getBytes(packet.content());
                        PluginMessageEvent event = new PluginMessageEvent(this.player, serverConn, id, copy);
                        ((CompletableFuture)this.server.getEventManager().fire(event).thenAcceptAsync(pme -> {
                            if (pme.getResult().isAllowed()) {
                                PluginMessagePacket message = new PluginMessagePacket(packet.getChannel(), Unpooled.wrappedBuffer(copy));
                                if (!this.player.getPhase().consideredComplete() || !serverConn.getPhase().consideredComplete()) {
                                    this.loginPluginMessages.add(message.retain());
                                } else {
                                    backendConn.write(message);
                                }
                            }
                        }, (Executor)backendConn.eventLoop())).exceptionally(ex -> {
                            logger.error("Exception while handling plugin message packet for {}", (Object)this.player, ex);
                            return null;
                        });
                    }
                }
            }
        }
        return true;
    }

    @Override
    public boolean handle(ResourcePackResponsePacket packet) {
        return this.player.resourcePackHandler().onResourcePackResponse(new ResourcePackResponseBundle(packet.getId(), packet.getHash(), packet.getStatus()));
    }

    @Override
    public boolean handle(FinishedUpdatePacket packet) {
        this.player.getConnection().setActiveSessionHandler(StateRegistry.CONFIG);
        VelocityServerConnection serverConnection = this.player.getConnectedServer();
        this.server.getEventManager().fireAndForget(new PlayerEnteredConfigurationEvent(this.player, serverConnection));
        if (serverConnection != null) {
            MinecraftConnection smc = serverConnection.ensureConnected();
            CompletableFuture.runAsync(() -> {
                smc.write(packet);
                smc.setActiveSessionHandler(StateRegistry.CONFIG);
                smc.setAutoReading(true);
            }, smc.eventLoop()).exceptionally(ex -> {
                logger.error("Error forwarding config state acknowledgement to server:", (Throwable)ex);
                return null;
            });
        }
        this.configSwitchFuture.complete(null);
        return true;
    }

    @Override
    public boolean handle(ChatAcknowledgementPacket packet) {
        if (this.player.getCurrentServer().isEmpty()) {
            return true;
        }
        this.player.getChatQueue().handleAcknowledgement(packet.offset());
        return true;
    }

    @Override
    public boolean handle(ServerboundCookieResponsePacket packet) {
        this.server.getEventManager().fire(new CookieReceiveEvent(this.player, packet.getKey(), packet.getPayload())).thenAcceptAsync(event -> {
            VelocityServerConnection serverConnection;
            if (event.getResult().isAllowed() && (serverConnection = this.player.getConnectedServer()) != null) {
                Key resultedKey = event.getResult().getKey() == null ? event.getOriginalKey() : event.getResult().getKey();
                byte[] resultedData = event.getResult().getData() == null ? event.getOriginalData() : event.getResult().getData();
                serverConnection.ensureConnected().write(new ServerboundCookieResponsePacket(resultedKey, resultedData));
            }
        }, (Executor)this.player.getConnection().eventLoop());
        return true;
    }

    @Override
    public void handleGeneric(MinecraftPacket packet) {
        VelocityServerConnection serverConnection = this.player.getConnectedServer();
        if (serverConnection == null) {
            return;
        }
        MinecraftConnection smc = serverConnection.getConnection();
        if (smc != null && serverConnection.getPhase().consideredComplete()) {
            if (packet instanceof PluginMessagePacket) {
                ((PluginMessagePacket)packet).retain();
            }
            smc.write(packet);
        }
    }

    @Override
    public void handleUnknown(ByteBuf buf) {
        VelocityServerConnection serverConnection = this.player.getConnectedServer();
        if (serverConnection == null) {
            return;
        }
        MinecraftConnection smc = serverConnection.getConnection();
        if (smc != null && !smc.isClosed() && serverConnection.getPhase().consideredComplete()) {
            smc.write(buf.retain());
        }
    }

    @Override
    public void disconnected() {
        this.player.teardown();
    }

    @Override
    public void exception(Throwable throwable) {
        this.player.disconnect(Component.translatable("velocity.error.player-connection-error", (TextColor)NamedTextColor.RED));
    }

    @Override
    public void writabilityChanged() {
        MinecraftConnection smc;
        VelocityServerConnection serverConn;
        boolean writable = this.player.getConnection().getChannel().isWritable();
        if (!writable) {
            this.player.getConnection().eventLoop().execute(() -> this.player.getConnection().flush());
        }
        if ((serverConn = this.player.getConnectedServer()) != null && (smc = serverConn.getConnection()) != null) {
            smc.setAutoReading(writable);
        }
    }

    public CompletableFuture<Void> doSwitch() {
        VelocityServerConnection existingConnection = this.player.getConnectedServer();
        if (existingConnection != null) {
            this.player.setConnectedServer(null);
            existingConnection.disconnect();
            this.player.sendKeepAlive();
            this.spawned = false;
            this.serverBossBars.clear();
            this.player.clearPlayerListHeaderAndFooterSilent();
            this.player.getTabList().clearAllSilent();
        }
        this.player.switchToConfigState();
        return this.configSwitchFuture;
    }

    public void handleBackendJoinGame(JoinGamePacket joinGame, VelocityServerConnection destination) {
        PluginMessagePacket pm;
        MinecraftConnection serverMc = destination.ensureConnected();
        if (!this.spawned) {
            this.spawned = true;
            this.player.getConnection().delayedWrite(joinGame);
            this.player.getPhase().onFirstJoin(this.player);
        } else {
            this.player.getTabList().clearAll();
            if (this.player.getConnection().getType() == ConnectionTypes.LEGACY_FORGE) {
                this.doSafeClientServerSwitch(joinGame);
            } else {
                this.doFastClientServerSwitch(joinGame);
            }
        }
        for (UUID serverBossBar : this.serverBossBars) {
            BossBarPacket deletePacket = new BossBarPacket();
            deletePacket.setUuid(serverBossBar);
            deletePacket.setAction(1);
            this.player.getConnection().delayedWrite(deletePacket);
        }
        this.serverBossBars.clear();
        ProtocolVersion serverVersion = serverMc.getProtocolVersion();
        Collection<String> channels = this.server.getChannelRegistrar().getChannelsForProtocol(serverMc.getProtocolVersion());
        if (!channels.isEmpty()) {
            serverMc.delayedWrite(PluginMessageUtil.constructChannelsPacket(serverVersion, channels));
        }
        while ((pm = this.loginPluginMessages.poll()) != null) {
            serverMc.delayedWrite(pm);
        }
        if (this.player.getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_8)) {
            this.player.getConnection().delayedWrite(GenericTitlePacket.constructTitlePacket(GenericTitlePacket.ActionType.RESET, this.player.getProtocolVersion()));
        }
        this.player.getConnection().flush();
        serverMc.flush();
        destination.completeJoin();
    }

    private void doFastClientServerSwitch(JoinGamePacket joinGame) {
        RespawnPacket respawn = RespawnPacket.fromJoinGame(joinGame);
        if (this.player.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_16)) {
            joinGame.setDimension(joinGame.getDimension() == 0 ? -1 : 0);
        }
        this.player.getConnection().delayedWrite(joinGame);
        this.player.getConnection().delayedWrite(respawn);
    }

    private void doSafeClientServerSwitch(JoinGamePacket joinGame) {
        this.player.getConnection().delayedWrite(joinGame);
        RespawnPacket fakeSwitchPacket = RespawnPacket.fromJoinGame(joinGame);
        fakeSwitchPacket.setDimension(joinGame.getDimension() == 0 ? -1 : 0);
        this.player.getConnection().delayedWrite(fakeSwitchPacket);
        RespawnPacket correctSwitchPacket = RespawnPacket.fromJoinGame(joinGame);
        this.player.getConnection().delayedWrite(correctSwitchPacket);
    }

    public List<UUID> getServerBossBars() {
        return this.serverBossBars;
    }

    private boolean handleCommandTabComplete(TabCompleteRequestPacket packet) {
        String command = packet.getCommand().substring(1);
        int commandEndPosition = command.indexOf(32);
        if (commandEndPosition == -1) {
            commandEndPosition = command.length();
        }
        String commandLabel = command.substring(0, commandEndPosition);
        if (!this.server.getCommandManager().hasCommand(commandLabel, this.player)) {
            if (this.player.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_13)) {
                this.outstandingTabComplete = packet;
            }
            return false;
        }
        ((CompletableFuture)this.server.getCommandManager().offerBrigadierSuggestions(this.player, command).thenAcceptAsync(suggestions -> {
            if (suggestions.isEmpty()) {
                return;
            }
            ArrayList<TabCompleteResponsePacket.Offer> offers = new ArrayList<TabCompleteResponsePacket.Offer>();
            for (Suggestion suggestion : suggestions.getList()) {
                String offer = suggestion.getText();
                ComponentHolder tooltip = null;
                if (suggestion.getTooltip() != null && suggestion.getTooltip() instanceof VelocityBrigadierMessage) {
                    tooltip = new ComponentHolder(this.player.getProtocolVersion(), ((VelocityBrigadierMessage)suggestion.getTooltip()).asComponent());
                }
                offers.add(new TabCompleteResponsePacket.Offer(offer, tooltip));
            }
            int startPos = packet.getCommand().lastIndexOf(32) + 1;
            if (startPos > 0) {
                TabCompleteResponsePacket resp = new TabCompleteResponsePacket();
                resp.setTransactionId(packet.getTransactionId());
                resp.setStart(startPos);
                resp.setLength(packet.getCommand().length() - startPos);
                resp.getOffers().addAll(offers);
                this.player.getConnection().write(resp);
            }
        }, (Executor)this.player.getConnection().eventLoop())).exceptionally(ex -> {
            logger.error("Exception while handling command tab completion for player {} executing {}", (Object)this.player, (Object)command, ex);
            return null;
        });
        return true;
    }

    private boolean handleRegularTabComplete(TabCompleteRequestPacket packet) {
        if (this.player.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_13)) {
            this.outstandingTabComplete = packet;
        }
        return false;
    }

    public void handleTabCompleteResponse(TabCompleteResponsePacket response) {
        if (this.outstandingTabComplete != null && !this.outstandingTabComplete.isAssumeCommand()) {
            if (this.outstandingTabComplete.getCommand().startsWith("/")) {
                this.finishCommandTabComplete(this.outstandingTabComplete, response);
            } else {
                this.finishRegularTabComplete(this.outstandingTabComplete, response);
            }
            this.outstandingTabComplete = null;
        } else {
            this.player.getConnection().write(response);
        }
    }

    private void finishCommandTabComplete(TabCompleteRequestPacket request, TabCompleteResponsePacket response) {
        String command = request.getCommand().substring(1);
        ((CompletableFuture)this.server.getCommandManager().offerBrigadierSuggestions(this.player, command).thenAcceptAsync(offers -> {
            boolean legacy = this.player.getProtocolVersion().lessThan(ProtocolVersion.MINECRAFT_1_13);
            try {
                for (Suggestion suggestion : offers.getList()) {
                    String offer = suggestion.getText();
                    String string = offer = legacy && !offer.startsWith("/") ? "/" + offer : offer;
                    if (legacy && offer.startsWith(command)) {
                        offer = offer.substring(command.length());
                    }
                    ComponentHolder tooltip = null;
                    if (suggestion.getTooltip() != null && suggestion.getTooltip() instanceof VelocityBrigadierMessage) {
                        tooltip = new ComponentHolder(this.player.getProtocolVersion(), ((VelocityBrigadierMessage)suggestion.getTooltip()).asComponent());
                    }
                    response.getOffers().add(new TabCompleteResponsePacket.Offer(offer, tooltip));
                }
                response.getOffers().sort(null);
                this.player.getConnection().write(response);
            }
            catch (Exception e) {
                logger.error("Unable to provide tab list completions for {} for command '{}'", (Object)this.player.getUsername(), (Object)command, (Object)e);
            }
        }, (Executor)this.player.getConnection().eventLoop())).exceptionally(ex -> {
            logger.error("Exception while finishing command tab completion, with request {} and response {}", (Object)request, (Object)response, ex);
            return null;
        });
    }

    private void finishRegularTabComplete(TabCompleteRequestPacket request, TabCompleteResponsePacket response) {
        ArrayList<String> offers = new ArrayList<String>();
        for (TabCompleteResponsePacket.Offer offer : response.getOffers()) {
            offers.add(offer.getText());
        }
        ((CompletableFuture)this.server.getEventManager().fire(new TabCompleteEvent(this.player, request.getCommand(), offers)).thenAcceptAsync(e -> {
            response.getOffers().clear();
            for (String s : e.getSuggestions()) {
                response.getOffers().add(new TabCompleteResponsePacket.Offer(s));
            }
            this.player.getConnection().write(response);
        }, (Executor)this.player.getConnection().eventLoop())).exceptionally(ex -> {
            logger.error("Exception while finishing regular tab completion, with request {} and response{}", (Object)request, (Object)response, ex);
            return null;
        });
    }

    public void flushQueuedMessages() {
        MinecraftConnection connection;
        VelocityServerConnection serverConnection = this.player.getConnectedServer();
        if (serverConnection != null && (connection = serverConnection.getConnection()) != null) {
            PluginMessagePacket pm;
            while ((pm = this.loginPluginMessages.poll()) != null) {
                connection.write(pm);
            }
        }
    }
}

