/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.network;

import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.netty.AutoReadHolderHandler;
import com.velocitypowered.proxy.protocol.netty.MinecraftDecoder;
import com.velocitypowered.proxy.protocol.netty.MinecraftEncoder;
import com.velocitypowered.proxy.protocol.netty.MinecraftVarintFrameDecoder;
import com.velocitypowered.proxy.protocol.netty.MinecraftVarintLengthEncoder;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.util.concurrent.TimeUnit;

public class BackendChannelInitializer
extends ChannelInitializer<Channel> {
    private final VelocityServer server;

    public BackendChannelInitializer(VelocityServer server) {
        this.server = server;
    }

    @Override
    protected void initChannel(Channel ch) {
        ch.pipeline().addLast("frame-decoder", (ChannelHandler)new MinecraftVarintFrameDecoder()).addLast("read-timeout", (ChannelHandler)new ReadTimeoutHandler(this.server.getConfiguration().getReadTimeout(), TimeUnit.MILLISECONDS)).addLast("frame-encoder", (ChannelHandler)MinecraftVarintLengthEncoder.INSTANCE).addLast("minecraft-decoder", (ChannelHandler)new MinecraftDecoder(ProtocolUtils.Direction.CLIENTBOUND)).addLast("flow-handler", (ChannelHandler)new AutoReadHolderHandler()).addLast("minecraft-encoder", (ChannelHandler)new MinecraftEncoder(ProtocolUtils.Direction.SERVERBOUND));
    }
}

