/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet;

import com.google.common.base.MoreObjects;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TabCompleteResponsePacket
implements MinecraftPacket {
    private int transactionId;
    private int start;
    private int length;
    private final List<Offer> offers = new ArrayList<Offer>();

    public int getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(int transactionId) {
        this.transactionId = transactionId;
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public List<Offer> getOffers() {
        return this.offers;
    }

    public String toString() {
        return "TabCompleteResponse{transactionId=" + this.transactionId + ", start=" + this.start + ", length=" + this.length + ", offers=" + this.offers + "}";
    }

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_13)) {
            this.transactionId = ProtocolUtils.readVarInt(buf);
            this.start = ProtocolUtils.readVarInt(buf);
            this.length = ProtocolUtils.readVarInt(buf);
            int offersAvailable = ProtocolUtils.readVarInt(buf);
            for (int i = 0; i < offersAvailable; ++i) {
                String offer = ProtocolUtils.readString(buf);
                ComponentHolder tooltip = buf.readBoolean() ? ComponentHolder.read(buf, version) : null;
                this.offers.add(new Offer(offer, tooltip));
            }
        } else {
            int offersAvailable = ProtocolUtils.readVarInt(buf);
            for (int i = 0; i < offersAvailable; ++i) {
                this.offers.add(new Offer(ProtocolUtils.readString(buf), null));
            }
        }
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion version) {
        if (version.noLessThan(ProtocolVersion.MINECRAFT_1_13)) {
            ProtocolUtils.writeVarInt(buf, this.transactionId);
            ProtocolUtils.writeVarInt(buf, this.start);
            ProtocolUtils.writeVarInt(buf, this.length);
            ProtocolUtils.writeVarInt(buf, this.offers.size());
            for (Offer offer : this.offers) {
                ProtocolUtils.writeString(buf, offer.text);
                buf.writeBoolean(offer.tooltip != null);
                if (offer.tooltip == null) continue;
                offer.tooltip.write(buf);
            }
        } else {
            ProtocolUtils.writeVarInt(buf, this.offers.size());
            for (Offer offer : this.offers) {
                ProtocolUtils.writeString(buf, offer.text);
            }
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    public static class Offer
    implements Comparable<Offer> {
        private final String text;
        private final @Nullable ComponentHolder tooltip;

        public Offer(String text) {
            this(text, null);
        }

        public Offer(String text, @Nullable ComponentHolder tooltip) {
            this.text = text;
            this.tooltip = tooltip;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Offer offer = (Offer)o;
            return this.text.equals(offer.text);
        }

        public int hashCode() {
            return this.text.hashCode();
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("text", this.text).add("tooltip", this.tooltip).toString();
        }

        @Override
        public int compareTo(Offer o) {
            return this.text.compareTo(o.text);
        }

        public String getText() {
            return this.text;
        }
    }
}

