/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat;

import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.BitSet;

public class LastSeenMessages {
    public static final int WINDOW_SIZE = 20;
    private static final int DIV_FLOOR = -Math.floorDiv(-20, 8);
    private int offset;
    private BitSet acknowledged;

    public LastSeenMessages() {
        this.offset = 0;
        this.acknowledged = new BitSet();
    }

    public LastSeenMessages(int offset, BitSet acknowledged) {
        this.offset = offset;
        this.acknowledged = acknowledged;
    }

    public LastSeenMessages(ByteBuf buf) {
        this.offset = ProtocolUtils.readVarInt(buf);
        byte[] bytes = new byte[DIV_FLOOR];
        buf.readBytes(bytes);
        this.acknowledged = BitSet.valueOf(bytes);
    }

    public void encode(ByteBuf buf) {
        ProtocolUtils.writeVarInt(buf, this.offset);
        buf.writeBytes(Arrays.copyOf(this.acknowledged.toByteArray(), DIV_FLOOR));
    }

    public int getOffset() {
        return this.offset;
    }

    public BitSet getAcknowledged() {
        return this.acknowledged;
    }

    public LastSeenMessages offset(int offset) {
        return new LastSeenMessages(this.offset + offset, this.acknowledged);
    }

    public String toString() {
        return "LastSeenMessages{offset=" + this.offset + ", acknowledged=" + this.acknowledged + "}";
    }
}

