/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat.session;

import com.google.common.collect.Lists;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.protocol.packet.chat.LastSeenMessages;
import com.velocitypowered.proxy.protocol.packet.chat.session.SessionPlayerChatPacket;
import com.velocitypowered.proxy.protocol.packet.chat.session.UnsignedPlayerCommandPacket;
import com.velocitypowered.proxy.util.except.QuietDecoderException;
import io.netty.buffer.ByteBuf;
import java.time.Instant;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SessionPlayerCommandPacket
implements MinecraftPacket {
    protected String command;
    protected Instant timeStamp;
    protected long salt;
    protected ArgumentSignatures argumentSignatures;
    protected LastSeenMessages lastSeenMessages;

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        this.command = ProtocolUtils.readString(buf, 256);
        this.timeStamp = Instant.ofEpochMilli(buf.readLong());
        this.salt = buf.readLong();
        this.argumentSignatures = new ArgumentSignatures(buf);
        this.lastSeenMessages = new LastSeenMessages(buf);
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        ProtocolUtils.writeString(buf, this.command);
        buf.writeLong(this.timeStamp.toEpochMilli());
        buf.writeLong(this.salt);
        this.argumentSignatures.encode(buf);
        this.lastSeenMessages.encode(buf);
    }

    public String getCommand() {
        return this.command;
    }

    public Instant getTimeStamp() {
        return this.timeStamp;
    }

    public boolean isSigned() {
        return !this.argumentSignatures.isEmpty();
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    public String toString() {
        return "SessionPlayerCommand{command='" + this.command + "', timeStamp=" + this.timeStamp + ", salt=" + this.salt + ", argumentSignatures=" + this.argumentSignatures + ", lastSeenMessages=" + this.lastSeenMessages + "}";
    }

    public SessionPlayerCommandPacket withLastSeenMessages(@Nullable LastSeenMessages lastSeenMessages) {
        if (lastSeenMessages == null) {
            UnsignedPlayerCommandPacket packet = new UnsignedPlayerCommandPacket();
            packet.command = this.command;
            return packet;
        }
        SessionPlayerCommandPacket packet = new SessionPlayerCommandPacket();
        packet.command = this.command;
        packet.timeStamp = this.timeStamp;
        packet.salt = this.salt;
        packet.argumentSignatures = this.argumentSignatures;
        packet.lastSeenMessages = lastSeenMessages;
        return packet;
    }

    public static class ArgumentSignatures {
        private final List<ArgumentSignature> entries;

        public ArgumentSignatures() {
            this.entries = List.of();
        }

        public ArgumentSignatures(ByteBuf buf) {
            int size = ProtocolUtils.readVarInt(buf);
            if (size > 8) {
                throw new QuietDecoderException(String.format("Too many argument signatures, %d is above limit %d", size, 8));
            }
            this.entries = Lists.newArrayListWithCapacity(size);
            for (int i = 0; i < size; ++i) {
                this.entries.add(new ArgumentSignature(buf));
            }
        }

        public boolean isEmpty() {
            return this.entries.isEmpty();
        }

        public void encode(ByteBuf buf) {
            ProtocolUtils.writeVarInt(buf, this.entries.size());
            for (ArgumentSignature entry : this.entries) {
                entry.encode(buf);
            }
        }

        public String toString() {
            return "ArgumentSignatures{entries=" + this.entries + "}";
        }
    }

    public static class ArgumentSignature {
        private final String name;
        private final byte[] signature;

        public ArgumentSignature(ByteBuf buf) {
            this.name = ProtocolUtils.readString(buf, 16);
            this.signature = SessionPlayerChatPacket.readMessageSignature(buf);
        }

        public void encode(ByteBuf buf) {
            ProtocolUtils.writeString(buf, this.name);
            buf.writeBytes(this.signature);
        }

        public String toString() {
            return "ArgumentSignature{name='" + this.name + "'}";
        }
    }
}

