/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.config;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import com.velocitypowered.proxy.util.except.QuietDecoderException;
import io.netty.buffer.ByteBuf;

public class KnownPacksPacket
implements MinecraftPacket {
    private static final int MAX_LENGTH_PACKS = Integer.getInteger("velocity.max-known-packs", 64);
    private static final QuietDecoderException TOO_MANY_PACKS = new QuietDecoderException("too many known packs");
    private KnownPack[] packs;

    @Override
    public void decode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        int packCount = ProtocolUtils.readVarInt(buf);
        if (packCount > MAX_LENGTH_PACKS) {
            throw TOO_MANY_PACKS;
        }
        KnownPack[] packs = new KnownPack[packCount];
        for (int i = 0; i < packCount; ++i) {
            packs[i] = KnownPack.read(buf);
        }
        this.packs = packs;
    }

    @Override
    public void encode(ByteBuf buf, ProtocolUtils.Direction direction, ProtocolVersion protocolVersion) {
        ProtocolUtils.writeVarInt(buf, this.packs.length);
        for (KnownPack pack : this.packs) {
            pack.write(buf);
        }
    }

    @Override
    public boolean handle(MinecraftSessionHandler handler) {
        return handler.handle(this);
    }

    public record KnownPack(String namespace, String id, String version) {
        private static KnownPack read(ByteBuf buf) {
            return new KnownPack(ProtocolUtils.readString(buf), ProtocolUtils.readString(buf), ProtocolUtils.readString(buf));
        }

        private void write(ByteBuf buf) {
            ProtocolUtils.writeString(buf, this.namespace);
            ProtocolUtils.writeString(buf, this.id);
            ProtocolUtils.writeString(buf, this.version);
        }
    }
}

