/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.util;

import com.velocitypowered.proxy.util.ClosestLocaleMatcher;
import java.util.Locale;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TranslatableComponent;
import net.kyori.adventure.text.flattener.ComponentFlattener;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.TranslationRegistry;
import net.kyori.adventure.translation.Translator;
import org.jetbrains.annotations.Nullable;

public enum TranslatableMapper implements BiConsumer<TranslatableComponent, Consumer<Component>>
{
    INSTANCE;

    public static final ComponentFlattener FLATTENER;

    @Override
    public void accept(TranslatableComponent translatableComponent, Consumer<Component> componentConsumer) {
        for (Translator translator : GlobalTranslator.translator().sources()) {
            TranslationRegistry translationRegistry;
            if (!(translator instanceof TranslationRegistry) || !(translationRegistry = (TranslationRegistry)translator).contains(translatableComponent.key())) continue;
            componentConsumer.accept(GlobalTranslator.render(translatableComponent, ClosestLocaleMatcher.INSTANCE.lookupClosest(Locale.getDefault())));
            return;
        }
        @Nullable String fallback = translatableComponent.fallback();
        if (fallback == null) {
            return;
        }
        for (Translator translator : GlobalTranslator.translator().sources()) {
            TranslationRegistry registry;
            if (!(translator instanceof TranslationRegistry) || !(registry = (TranslationRegistry)translator).contains(fallback)) continue;
            componentConsumer.accept(GlobalTranslator.render(Component.translatable(fallback), ClosestLocaleMatcher.INSTANCE.lookupClosest(Locale.getDefault())));
            return;
        }
    }

    static {
        FLATTENER = (ComponentFlattener)((ComponentFlattener.Builder)ComponentFlattener.basic().toBuilder()).complexMapper(TranslatableComponent.class, INSTANCE).build();
    }
}

