/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.connection.backend;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.tree.RootCommandNode;
import com.velocitypowered.api.command.CommandSource;
import com.velocitypowered.api.event.command.PlayerAvailableCommandsEvent;
import com.velocitypowered.api.event.connection.PluginMessageEvent;
import com.velocitypowered.api.event.connection.PreTransferEvent;
import com.velocitypowered.api.event.player.CookieRequestEvent;
import com.velocitypowered.api.event.player.CookieStoreEvent;
import com.velocitypowered.api.event.player.PlayerResourcePackStatusEvent;
import com.velocitypowered.api.event.player.ServerResourcePackRemoveEvent;
import com.velocitypowered.api.event.player.ServerResourcePackSendEvent;
import com.velocitypowered.api.event.proxy.ProxyPingEvent;
import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.api.proxy.messages.ChannelIdentifier;
import com.velocitypowered.api.proxy.player.ResourcePackInfo;
import com.velocitypowered.api.proxy.server.RegisteredServer;
import com.velocitypowered.api.proxy.server.ServerPing;
import com.velocitypowered.proxy.VelocityServer;
import com.velocitypowered.proxy.command.CommandGraphInjector;
import com.velocitypowered.proxy.connection.MinecraftConnection;
import com.velocitypowered.proxy.connection.MinecraftSessionHandler;
import com.velocitypowered.proxy.connection.backend.BungeeCordMessageResponder;
import com.velocitypowered.proxy.connection.backend.VelocityServerConnection;
import com.velocitypowered.proxy.connection.client.ClientPlaySessionHandler;
import com.velocitypowered.proxy.connection.client.ConnectedPlayer;
import com.velocitypowered.proxy.connection.player.resourcepack.VelocityResourcePackInfo;
import com.velocitypowered.proxy.connection.player.resourcepack.handler.ResourcePackHandler;
import com.velocitypowered.proxy.connection.util.ConnectionMessages;
import com.velocitypowered.proxy.protocol.MinecraftPacket;
import com.velocitypowered.proxy.protocol.StateRegistry;
import com.velocitypowered.proxy.protocol.netty.MinecraftDecoder;
import com.velocitypowered.proxy.protocol.netty.MinecraftVarintFrameDecoder;
import com.velocitypowered.proxy.protocol.packet.AvailableCommandsPacket;
import com.velocitypowered.proxy.protocol.packet.BossBarPacket;
import com.velocitypowered.proxy.protocol.packet.BundleDelimiterPacket;
import com.velocitypowered.proxy.protocol.packet.ClientSettingsPacket;
import com.velocitypowered.proxy.protocol.packet.ClientboundCookieRequestPacket;
import com.velocitypowered.proxy.protocol.packet.ClientboundStoreCookiePacket;
import com.velocitypowered.proxy.protocol.packet.DisconnectPacket;
import com.velocitypowered.proxy.protocol.packet.KeepAlivePacket;
import com.velocitypowered.proxy.protocol.packet.LegacyPlayerListItemPacket;
import com.velocitypowered.proxy.protocol.packet.PluginMessagePacket;
import com.velocitypowered.proxy.protocol.packet.RemovePlayerInfoPacket;
import com.velocitypowered.proxy.protocol.packet.RemoveResourcePackPacket;
import com.velocitypowered.proxy.protocol.packet.ResourcePackRequestPacket;
import com.velocitypowered.proxy.protocol.packet.ResourcePackResponsePacket;
import com.velocitypowered.proxy.protocol.packet.ServerDataPacket;
import com.velocitypowered.proxy.protocol.packet.TabCompleteResponsePacket;
import com.velocitypowered.proxy.protocol.packet.TransferPacket;
import com.velocitypowered.proxy.protocol.packet.UpsertPlayerInfoPacket;
import com.velocitypowered.proxy.protocol.packet.chat.ComponentHolder;
import com.velocitypowered.proxy.protocol.packet.config.StartUpdatePacket;
import com.velocitypowered.proxy.protocol.util.PluginMessageUtil;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.handler.timeout.ReadTimeoutException;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import net.kyori.adventure.key.Key;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BackendPlaySessionHandler
implements MinecraftSessionHandler {
    private static final Pattern PLAUSIBLE_SHA1_HASH = Pattern.compile("^[a-z0-9]{40}$");
    private static final Logger logger = LogManager.getLogger(BackendPlaySessionHandler.class);
    private static final boolean BACKPRESSURE_LOG = Boolean.getBoolean("velocity.log-server-backpressure");
    private static final int MAXIMUM_PACKETS_TO_FLUSH = Integer.getInteger("velocity.max-packets-per-flush", 8192);
    private final VelocityServer server;
    private final VelocityServerConnection serverConn;
    private final ClientPlaySessionHandler playerSessionHandler;
    private final MinecraftConnection playerConnection;
    private final BungeeCordMessageResponder bungeecordMessageResponder;
    private boolean exceptionTriggered = false;
    private int packetsFlushed;

    BackendPlaySessionHandler(VelocityServer server, VelocityServerConnection serverConn) {
        this.server = server;
        this.serverConn = serverConn;
        this.playerConnection = serverConn.getPlayer().getConnection();
        MinecraftSessionHandler psh = this.playerConnection.getActiveSessionHandler();
        if (!(psh instanceof ClientPlaySessionHandler)) {
            throw new IllegalStateException("Initializing BackendPlaySessionHandler with no backing client play session handler!");
        }
        this.playerSessionHandler = (ClientPlaySessionHandler)psh;
        this.bungeecordMessageResponder = new BungeeCordMessageResponder(server, serverConn.getPlayer());
    }

    @Override
    public void activated() {
        this.serverConn.getServer().addPlayer(this.serverConn.getPlayer());
        MinecraftConnection serverMc = this.serverConn.ensureConnected();
        if (this.server.getConfiguration().isBungeePluginChannelEnabled()) {
            serverMc.write(PluginMessageUtil.constructChannelsPacket(serverMc.getProtocolVersion(), ImmutableList.of(BungeeCordMessageResponder.getBungeeCordChannel(serverMc.getProtocolVersion()))));
        }
    }

    @Override
    public boolean beforeHandle() {
        if (!this.serverConn.isActive()) {
            this.serverConn.disconnect();
            return true;
        }
        return false;
    }

    @Override
    public boolean handle(BundleDelimiterPacket bundleDelimiterPacket) {
        this.serverConn.getPlayer().getBundleHandler().toggleBundleSession();
        return false;
    }

    @Override
    public boolean handle(StartUpdatePacket packet) {
        MinecraftConnection smc = this.serverConn.ensureConnected();
        smc.setAutoReading(false);
        smc.getChannel().pipeline().get(MinecraftVarintFrameDecoder.class).setState(StateRegistry.CONFIG);
        smc.getChannel().pipeline().get(MinecraftDecoder.class).setState(StateRegistry.CONFIG);
        this.serverConn.getPlayer().switchToConfigState();
        return true;
    }

    @Override
    public boolean handle(KeepAlivePacket packet) {
        this.serverConn.getPendingPings().put(packet.getRandomId(), System.nanoTime());
        return false;
    }

    @Override
    public boolean handle(ClientSettingsPacket packet) {
        this.serverConn.ensureConnected().write(packet);
        return true;
    }

    @Override
    public boolean handle(DisconnectPacket packet) {
        this.serverConn.disconnect();
        this.serverConn.getPlayer().handleConnectionException((RegisteredServer)this.serverConn.getServer(), packet, true);
        return true;
    }

    @Override
    public boolean handle(BossBarPacket packet) {
        if (packet.getAction() == 0) {
            this.playerSessionHandler.getServerBossBars().add(packet.getUuid());
        } else if (packet.getAction() == 1) {
            this.playerSessionHandler.getServerBossBars().remove(packet.getUuid());
        }
        return false;
    }

    @Override
    public boolean handle(ResourcePackRequestPacket packet) {
        VelocityResourcePackInfo.BuilderImpl builder = new VelocityResourcePackInfo.BuilderImpl(Preconditions.checkNotNull(packet.getUrl())).setId(packet.getId()).setPrompt(packet.getPrompt() == null ? null : packet.getPrompt().getComponent()).setShouldForce(packet.isRequired()).setOrigin(ResourcePackInfo.Origin.DOWNSTREAM_SERVER);
        String hash = packet.getHash();
        if (hash != null && !hash.isEmpty() && PLAUSIBLE_SHA1_HASH.matcher(hash).matches()) {
            builder.setHash(ByteBufUtil.decodeHexDump(hash));
        }
        ResourcePackInfo resourcePackInfo = builder.build();
        ServerResourcePackSendEvent event = new ServerResourcePackSendEvent(resourcePackInfo, this.serverConn);
        ((CompletableFuture)this.server.getEventManager().fire(event).thenAcceptAsync(serverResourcePackSendEvent -> {
            if (this.playerConnection.isClosed()) {
                return;
            }
            if (serverResourcePackSendEvent.getResult().isAllowed()) {
                ResourcePackInfo toSend = serverResourcePackSendEvent.getProvidedResourcePack();
                boolean modifiedPack = false;
                if (toSend != serverResourcePackSendEvent.getReceivedResourcePack()) {
                    ((VelocityResourcePackInfo)toSend).setOriginalOrigin(ResourcePackInfo.Origin.DOWNSTREAM_SERVER);
                    modifiedPack = true;
                }
                if (this.serverConn.getPlayer().resourcePackHandler().hasPackAppliedByHash(toSend.getHash())) {
                    if (this.serverConn.getConnection() != null) {
                        this.serverConn.getConnection().write(new ResourcePackResponsePacket(packet.getId(), packet.getHash(), PlayerResourcePackStatusEvent.Status.ACCEPTED));
                        if (this.serverConn.getConnection().getProtocolVersion().noLessThan(ProtocolVersion.MINECRAFT_1_20_3)) {
                            this.serverConn.getConnection().write(new ResourcePackResponsePacket(packet.getId(), packet.getHash(), PlayerResourcePackStatusEvent.Status.DOWNLOADED));
                        }
                        this.serverConn.getConnection().write(new ResourcePackResponsePacket(packet.getId(), packet.getHash(), PlayerResourcePackStatusEvent.Status.SUCCESSFUL));
                    }
                    if (modifiedPack) {
                        logger.warn("A plugin has tried to modify a ResourcePack provided by the backend server with a ResourcePack already applied, the applying of the resource pack will be skipped.");
                    }
                } else {
                    this.serverConn.getPlayer().resourcePackHandler().queueResourcePack(toSend);
                }
            } else if (this.serverConn.getConnection() != null) {
                this.serverConn.getConnection().write(new ResourcePackResponsePacket(packet.getId(), packet.getHash(), PlayerResourcePackStatusEvent.Status.DECLINED));
            }
        }, (Executor)this.playerConnection.eventLoop())).exceptionally(ex -> {
            if (this.serverConn.getConnection() != null) {
                this.serverConn.getConnection().write(new ResourcePackResponsePacket(packet.getId(), packet.getHash(), PlayerResourcePackStatusEvent.Status.DECLINED));
            }
            logger.error("Exception while handling resource pack send for {}", (Object)this.playerConnection, ex);
            return null;
        });
        return true;
    }

    @Override
    public boolean handle(RemoveResourcePackPacket packet) {
        ServerResourcePackRemoveEvent event = new ServerResourcePackRemoveEvent(packet.getId(), this.serverConn);
        ((CompletableFuture)this.server.getEventManager().fire(event).thenAcceptAsync(serverResourcePackRemoveEvent -> {
            if (this.playerConnection.isClosed()) {
                return;
            }
            if (serverResourcePackRemoveEvent.getResult().isAllowed()) {
                ConnectedPlayer player = this.serverConn.getPlayer();
                ResourcePackHandler handler = player.resourcePackHandler();
                if (packet.getId() != null) {
                    handler.remove(packet.getId());
                } else {
                    handler.clearAppliedResourcePacks();
                }
                this.playerConnection.write(packet);
            }
        }, (Executor)this.playerConnection.eventLoop())).exceptionally(ex -> {
            logger.error("Exception while handling resource pack remove for {}", (Object)this.playerConnection, ex);
            return null;
        });
        return true;
    }

    @Override
    public boolean handle(PluginMessagePacket packet) {
        if (this.bungeecordMessageResponder.process(packet)) {
            return true;
        }
        if (PluginMessageUtil.isRegister(packet) || PluginMessageUtil.isUnregister(packet)) {
            return false;
        }
        if (PluginMessageUtil.isMcBrand(packet)) {
            PluginMessagePacket rewritten = PluginMessageUtil.rewriteMinecraftBrand(packet, this.server.getVersion(), this.playerConnection.getProtocolVersion());
            this.playerConnection.write(rewritten);
            return true;
        }
        if (this.serverConn.getPhase().handle(this.serverConn, this.serverConn.getPlayer(), packet)) {
            return true;
        }
        ChannelIdentifier id = this.server.getChannelRegistrar().getFromId(packet.getChannel());
        if (id == null) {
            return false;
        }
        byte[] copy = ByteBufUtil.getBytes(packet.content());
        PluginMessageEvent event = new PluginMessageEvent(this.serverConn, this.serverConn.getPlayer(), id, copy);
        ((CompletableFuture)this.server.getEventManager().fire(event).thenAcceptAsync(pme -> {
            if (pme.getResult().isAllowed() && !this.playerConnection.isClosed()) {
                PluginMessagePacket copied = new PluginMessagePacket(packet.getChannel(), Unpooled.wrappedBuffer(copy));
                this.playerConnection.write(copied);
            }
        }, (Executor)this.playerConnection.eventLoop())).exceptionally(ex -> {
            logger.error("Exception while handling plugin message {}", (Object)packet, ex);
            return null;
        });
        return true;
    }

    @Override
    public boolean handle(TabCompleteResponsePacket packet) {
        this.playerSessionHandler.handleTabCompleteResponse(packet);
        return true;
    }

    @Override
    public boolean handle(LegacyPlayerListItemPacket packet) {
        this.serverConn.getPlayer().getTabList().processLegacy(packet);
        return false;
    }

    @Override
    public boolean handle(UpsertPlayerInfoPacket packet) {
        this.serverConn.getPlayer().getTabList().processUpdate(packet);
        return false;
    }

    @Override
    public boolean handle(RemovePlayerInfoPacket packet) {
        this.serverConn.getPlayer().getTabList().processRemove(packet);
        return false;
    }

    @Override
    public boolean handle(AvailableCommandsPacket commands) {
        RootCommandNode<CommandSource> rootNode = commands.getRootNode();
        if (this.server.getConfiguration().isAnnounceProxyCommands()) {
            CommandGraphInjector<CommandSource> injector = this.server.getCommandManager().getInjector();
            injector.inject(rootNode, this.serverConn.getPlayer());
            rootNode.removeChildByName("velocity:callback");
        }
        ((CompletableFuture)this.server.getEventManager().fire(new PlayerAvailableCommandsEvent(this.serverConn.getPlayer(), rootNode)).thenAcceptAsync(event -> this.playerConnection.write(commands), (Executor)this.playerConnection.eventLoop())).exceptionally(ex -> {
            logger.error("Exception while handling available commands for {}", (Object)this.playerConnection, ex);
            return null;
        });
        return true;
    }

    @Override
    public boolean handle(ServerDataPacket packet) {
        ((CompletableFuture)this.server.getServerListPingHandler().getInitialPing(this.serverConn.getPlayer()).thenComposeAsync(ping -> this.server.getEventManager().fire(new ProxyPingEvent(this.serverConn.getPlayer(), (ServerPing)ping)), (Executor)this.playerConnection.eventLoop())).thenAcceptAsync(pingEvent -> this.playerConnection.write(new ServerDataPacket(new ComponentHolder(this.serverConn.ensureConnected().getProtocolVersion(), pingEvent.getPing().getDescriptionComponent()), pingEvent.getPing().getFavicon().orElse(null), packet.isSecureChatEnforced())), (Executor)this.playerConnection.eventLoop());
        return true;
    }

    @Override
    public boolean handle(TransferPacket packet) {
        InetSocketAddress originalAddress = packet.address();
        if (originalAddress == null) {
            logger.error("Unexpected nullable address received in TransferPacket from Backend Server in Play State");
            return true;
        }
        this.server.getEventManager().fire(new PreTransferEvent(this.serverConn.getPlayer(), originalAddress)).thenAcceptAsync(event -> {
            if (event.getResult().isAllowed()) {
                InetSocketAddress resultedAddress = event.getResult().address();
                if (resultedAddress == null) {
                    resultedAddress = originalAddress;
                }
                this.playerConnection.write(new TransferPacket(resultedAddress.getHostName(), resultedAddress.getPort()));
            }
        }, (Executor)this.playerConnection.eventLoop());
        return true;
    }

    @Override
    public boolean handle(ClientboundStoreCookiePacket packet) {
        this.server.getEventManager().fire(new CookieStoreEvent(this.serverConn.getPlayer(), packet.getKey(), packet.getPayload())).thenAcceptAsync(event -> {
            if (event.getResult().isAllowed()) {
                Key resultedKey = event.getResult().getKey() == null ? event.getOriginalKey() : event.getResult().getKey();
                byte[] resultedData = event.getResult().getData() == null ? event.getOriginalData() : event.getResult().getData();
                this.playerConnection.write(new ClientboundStoreCookiePacket(resultedKey, resultedData));
            }
        }, (Executor)this.playerConnection.eventLoop());
        return true;
    }

    @Override
    public boolean handle(ClientboundCookieRequestPacket packet) {
        this.server.getEventManager().fire(new CookieRequestEvent(this.serverConn.getPlayer(), packet.getKey())).thenAcceptAsync(event -> {
            if (event.getResult().isAllowed()) {
                Key resultedKey = event.getResult().getKey() == null ? event.getOriginalKey() : event.getResult().getKey();
                this.playerConnection.write(new ClientboundCookieRequestPacket(resultedKey));
            }
        }, (Executor)this.playerConnection.eventLoop());
        return true;
    }

    @Override
    public void handleGeneric(MinecraftPacket packet) {
        if (packet instanceof PluginMessagePacket) {
            ((PluginMessagePacket)packet).retain();
        }
        this.playerConnection.delayedWrite(packet);
        if (++this.packetsFlushed >= MAXIMUM_PACKETS_TO_FLUSH) {
            this.playerConnection.flush();
            this.packetsFlushed = 0;
        }
    }

    @Override
    public void handleUnknown(ByteBuf buf) {
        this.playerConnection.delayedWrite(buf.retain());
        if (++this.packetsFlushed >= MAXIMUM_PACKETS_TO_FLUSH) {
            this.playerConnection.flush();
            this.packetsFlushed = 0;
        }
    }

    @Override
    public void readCompleted() {
        this.playerConnection.flush();
        this.packetsFlushed = 0;
    }

    @Override
    public void exception(Throwable throwable) {
        this.exceptionTriggered = true;
        this.serverConn.getPlayer().handleConnectionException((RegisteredServer)this.serverConn.getServer(), throwable, !(throwable instanceof ReadTimeoutException));
    }

    public VelocityServer getServer() {
        return this.server;
    }

    @Override
    public void disconnected() {
        this.serverConn.getServer().removePlayer(this.serverConn.getPlayer());
        if (!this.serverConn.isGracefulDisconnect() && !this.exceptionTriggered) {
            if (this.server.getConfiguration().isFailoverOnUnexpectedServerDisconnect()) {
                this.serverConn.getPlayer().handleConnectionException((RegisteredServer)this.serverConn.getServer(), DisconnectPacket.create(ConnectionMessages.INTERNAL_SERVER_CONNECTION_ERROR, this.serverConn.getPlayer().getProtocolVersion(), this.serverConn.getPlayer().getConnection().getState()), true);
            } else {
                this.serverConn.getPlayer().disconnect(ConnectionMessages.INTERNAL_SERVER_CONNECTION_ERROR);
            }
        }
    }

    @Override
    public void writabilityChanged() {
        Channel serverChan = this.serverConn.ensureConnected().getChannel();
        boolean writable = serverChan.isWritable();
        if (BACKPRESSURE_LOG) {
            if (writable) {
                logger.info("{} is not writable, not auto-reading player connection data", (Object)this.serverConn);
            } else {
                logger.info("{} is writable, will auto-read player connection data", (Object)this.serverConn);
            }
        }
        this.playerConnection.setAutoReading(writable);
    }
}

