/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.crypto;

import com.google.common.base.Preconditions;
import com.google.common.io.ByteStreams;
import com.velocitypowered.proxy.util.except.QuietDecoderException;
import it.unimi.dsi.fastutil.Pair;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import javax.crypto.Cipher;

public final class EncryptionUtils
extends Enum<EncryptionUtils> {
    public static final Pair<String, String> PEM_RSA_PUBLIC_KEY_DESCRIPTOR;
    public static final Pair<String, String> PEM_RSA_PRIVATE_KEY_DESCRIPTOR;
    public static final String SHA1_WITH_RSA = "SHA1withRSA";
    public static final String SHA256_WITH_RSA = "SHA256withRSA";
    public static final QuietDecoderException INVALID_SIGNATURE;
    public static final QuietDecoderException PREVIEW_SIGNATURE_MISSING;
    public static final byte[] EMPTY;
    private static PublicKey YGGDRASIL_SESSION_KEY;
    private static KeyFactory RSA_KEY_FACTORY;
    private static final Base64.Encoder MIME_SPECIAL_ENCODER;
    private static final /* synthetic */ EncryptionUtils[] $VALUES;

    public static EncryptionUtils[] values() {
        return (EncryptionUtils[])$VALUES.clone();
    }

    public static EncryptionUtils valueOf(String name) {
        return Enum.valueOf(EncryptionUtils.class, name);
    }

    public static PublicKey getYggdrasilSessionKey() {
        return YGGDRASIL_SESSION_KEY;
    }

    public static boolean verifySignature(String algorithm, PublicKey base, byte[] signature, byte[] ... toVerify) {
        Preconditions.checkArgument(toVerify.length > 0);
        try {
            Signature construct = Signature.getInstance(algorithm);
            construct.initVerify(base);
            for (byte[] bytes : toVerify) {
                construct.update(bytes);
            }
            return construct.verify(signature);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalArgumentException("Invalid signature parameters");
        }
    }

    public static String encodeUrlEncoded(byte[] data) {
        return MIME_SPECIAL_ENCODER.encodeToString(data);
    }

    public static byte[] decodeUrlEncoded(String toParse) {
        return Base64.getMimeDecoder().decode(toParse);
    }

    public static String pemEncodeRsaKey(Key toEncode) {
        Pair<String, String> encoder;
        Preconditions.checkNotNull(toEncode);
        if (toEncode instanceof PublicKey) {
            encoder = PEM_RSA_PUBLIC_KEY_DESCRIPTOR;
        } else if (toEncode instanceof PrivateKey) {
            encoder = PEM_RSA_PRIVATE_KEY_DESCRIPTOR;
        } else {
            throw new IllegalArgumentException("Invalid key type");
        }
        return encoder.first() + "\n" + EncryptionUtils.encodeUrlEncoded(toEncode.getEncoded()) + "\n" + encoder.second() + "\n";
    }

    public static PublicKey parseRsaPublicKey(byte[] keyValue) {
        try {
            return RSA_KEY_FACTORY.generatePublic(new X509EncodedKeySpec(keyValue));
        }
        catch (InvalidKeySpecException e) {
            throw new IllegalArgumentException("Invalid key bytes");
        }
    }

    public static KeyPair createRsaKeyPair(int keysize) {
        try {
            KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA");
            generator.initialize(keysize);
            return generator.generateKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Unable to generate RSA keypair", e);
        }
    }

    public static String twosComplementHexdigest(byte[] digest) {
        return new BigInteger(digest).toString(16);
    }

    public static byte[] decryptRsa(KeyPair keyPair, byte[] bytes) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("RSA");
        cipher.init(2, keyPair.getPrivate());
        return cipher.doFinal(bytes);
    }

    public static String generateServerId(byte[] sharedSecret, PublicKey key) {
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            digest.update(sharedSecret);
            digest.update(key.getEncoded());
            return EncryptionUtils.twosComplementHexdigest(digest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static /* synthetic */ EncryptionUtils[] $values() {
        return new EncryptionUtils[0];
    }

    static {
        $VALUES = EncryptionUtils.$values();
        PEM_RSA_PUBLIC_KEY_DESCRIPTOR = Pair.of("-----BEGIN RSA PUBLIC KEY-----", "-----END RSA PUBLIC KEY-----");
        PEM_RSA_PRIVATE_KEY_DESCRIPTOR = Pair.of("-----BEGIN RSA PRIVATE KEY-----", "-----END RSA PRIVATE KEY-----");
        INVALID_SIGNATURE = new QuietDecoderException("Incorrectly signed chat message");
        PREVIEW_SIGNATURE_MISSING = new QuietDecoderException("Unsigned chat message requested signed preview");
        EMPTY = new byte[0];
        MIME_SPECIAL_ENCODER = Base64.getMimeEncoder(76, "\n".getBytes(StandardCharsets.UTF_8));
        try {
            RSA_KEY_FACTORY = KeyFactory.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        try {
            byte[] bytes = ByteStreams.toByteArray(EncryptionUtils.class.getClassLoader().getResourceAsStream("yggdrasil_session_pubkey.der"));
            YGGDRASIL_SESSION_KEY = EncryptionUtils.parseRsaPublicKey(bytes);
        }
        catch (IOException | NullPointerException err) {
            throw new RuntimeException(err);
        }
    }
}

