/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.packet.chat;

import com.velocitypowered.api.network.ProtocolVersion;
import com.velocitypowered.proxy.protocol.ProtocolUtils;
import io.netty.buffer.ByteBuf;
import java.util.Arrays;
import java.util.BitSet;

public class LastSeenMessages {
    public static final int WINDOW_SIZE = 20;
    private static final int DIV_FLOOR = -Math.floorDiv(-20, 8);
    private final int offset;
    private final BitSet acknowledged;
    private byte checksum;

    public LastSeenMessages() {
        this(0, new BitSet(), 0);
    }

    public LastSeenMessages(int offset, BitSet acknowledged, byte checksum) {
        this.offset = offset;
        this.acknowledged = acknowledged;
        this.checksum = checksum;
    }

    public LastSeenMessages(ByteBuf buf, ProtocolVersion protocolVersion) {
        this.offset = ProtocolUtils.readVarInt(buf);
        byte[] bytes = new byte[DIV_FLOOR];
        buf.readBytes(bytes);
        this.acknowledged = BitSet.valueOf(bytes);
        if (protocolVersion.noLessThan(ProtocolVersion.MINECRAFT_1_21_5)) {
            this.checksum = buf.readByte();
        }
    }

    public void encode(ByteBuf buf, ProtocolVersion protocolVersion) {
        ProtocolUtils.writeVarInt(buf, this.offset);
        buf.writeBytes(Arrays.copyOf(this.acknowledged.toByteArray(), DIV_FLOOR));
        if (protocolVersion.noLessThan(ProtocolVersion.MINECRAFT_1_21_5)) {
            buf.writeByte(this.checksum);
        }
    }

    public int getOffset() {
        return this.offset;
    }

    public BitSet getAcknowledged() {
        return this.acknowledged;
    }

    public LastSeenMessages offset(int offset) {
        return new LastSeenMessages(this.offset + offset, this.acknowledged, this.checksum);
    }

    public String toString() {
        return "LastSeenMessages{offset=" + this.offset + ", acknowledged=" + this.acknowledged + ", checksum=" + this.checksum + "}";
    }
}

