/*
 * Decompiled with CFR 0.152.
 */
package com.velocitypowered.proxy.protocol.util;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.util.IllegalReferenceCountException;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;

public class DeferredByteBufHolder
implements ByteBufHolder {
    private @MonotonicNonNull ByteBuf backing;

    public DeferredByteBufHolder(@MonotonicNonNull ByteBuf backing) {
        this.backing = backing;
    }

    @Override
    public ByteBuf content() {
        if (this.backing == null) {
            throw new IllegalStateException("Trying to obtain contents of holder with a null buffer");
        }
        if (this.backing.refCnt() <= 0) {
            throw new IllegalReferenceCountException(this.backing.refCnt());
        }
        return this.backing;
    }

    @Override
    public ByteBufHolder copy() {
        if (this.backing == null) {
            throw new IllegalStateException("Trying to obtain contents of holder with a null buffer");
        }
        return new DeferredByteBufHolder(this.backing.copy());
    }

    @Override
    public ByteBufHolder duplicate() {
        if (this.backing == null) {
            throw new IllegalStateException("Trying to obtain contents of holder with a null buffer");
        }
        return new DeferredByteBufHolder(this.backing.duplicate());
    }

    @Override
    public ByteBufHolder retainedDuplicate() {
        if (this.backing == null) {
            throw new IllegalStateException("Trying to obtain contents of holder with a null buffer");
        }
        return new DeferredByteBufHolder(this.backing.retainedDuplicate());
    }

    @Override
    public ByteBufHolder replace(ByteBuf content) {
        if (content == null) {
            throw new NullPointerException("content");
        }
        this.backing = content;
        return this;
    }

    @Override
    public int refCnt() {
        if (this.backing == null) {
            throw new IllegalStateException("Trying to obtain contents of holder with a null buffer");
        }
        return this.backing.refCnt();
    }

    @Override
    public ByteBufHolder retain() {
        if (this.backing == null) {
            throw new IllegalStateException("Trying to obtain contents of holder with a null buffer");
        }
        this.backing.retain();
        return this;
    }

    @Override
    public ByteBufHolder retain(int increment) {
        if (this.backing == null) {
            throw new IllegalStateException("Trying to obtain contents of holder with a null buffer");
        }
        this.backing.retain(increment);
        return this;
    }

    @Override
    public ByteBufHolder touch() {
        if (this.backing == null) {
            throw new IllegalStateException("Trying to obtain contents of holder with a null buffer");
        }
        this.backing.touch();
        return this;
    }

    @Override
    public ByteBufHolder touch(Object hint) {
        if (this.backing == null) {
            throw new IllegalStateException("Trying to obtain contents of holder with a null buffer");
        }
        this.backing.touch(hint);
        return this;
    }

    @Override
    public boolean release() {
        if (this.backing == null) {
            throw new IllegalStateException("Trying to obtain contents of holder with a null buffer");
        }
        return this.backing.release();
    }

    @Override
    public boolean release(int decrement) {
        if (this.backing == null) {
            throw new IllegalStateException("Trying to obtain contents of holder with a null buffer");
        }
        return this.backing.release(decrement);
    }

    public String toString() {
        Object str = "DeferredByteBufHolder[";
        str = this.backing == null ? (String)str + "null" : (String)str + this.backing.toString();
        return (String)str + "]";
    }
}

