/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.asm.proxy;

import catserver.server.asm.proxy.LibrarianLibTransformerProxy;
import catserver.server.asm.proxy.WingsTransformerProxy;
import catserver.server.asm.proxy.WizardryTransformerProxy;
import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.launchwrapper.IClassTransformer;

public class TransformerProxyRules {
    private static final Map<String, Class<?>> transformerProxyRules = Maps.newHashMap();

    public static IClassTransformer getTarget(IClassTransformer originTransformer) {
        Class<?> target = transformerProxyRules.get(originTransformer.getClass().getName());
        if (target != null) {
            try {
                return (IClassTransformer)target.getConstructor(IClassTransformer.class).newInstance(originTransformer);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return originTransformer;
    }

    static {
        transformerProxyRules.put("com.teamwizardry.librarianlib.asm.LibLibTransformer", LibrarianLibTransformerProxy.class);
        transformerProxyRules.put("me.paulf.wings.server.asm.WingsRuntimePatcher", WingsTransformerProxy.class);
        transformerProxyRules.put("com.teamwizardry.wizardry.asm.WizardryTransformer", WizardryTransformerProxy.class);
    }
}

