/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.asm.proxy;

import java.util.Optional;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodNode;

public class WingsTransformerProxy
implements IClassTransformer {
    private final IClassTransformer originTransformer;

    public WingsTransformerProxy(IClassTransformer originTransformer) {
        this.originTransformer = originTransformer;
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (basicClass == null) {
            return null;
        }
        byte[] patchedClass = this.originTransformer.transform(name, transformedName, basicClass);
        if ("net.minecraft.entity.player.EntityPlayer".equals(transformedName)) {
            return this.patchEntityPlayer(basicClass, patchedClass);
        }
        return patchedClass;
    }

    public byte[] patchEntityPlayer(byte[] originClass, byte[] patchedClass) {
        Optional<MethodNode> optional_func_174820_d;
        Optional<MethodNode> optional_func_71000_j;
        Optional<MethodNode> optional_func_70047_e;
        ClassReader patchedReader = new ClassReader(patchedClass);
        ClassNode patchedNode = new ClassNode();
        patchedReader.accept((ClassVisitor)patchedNode, 0);
        ClassReader originReader = new ClassReader(originClass);
        ClassNode originNode = new ClassNode();
        originReader.accept((ClassVisitor)originNode, 0);
        Optional<MethodNode> optional_func_184808_cD = patchedNode.methods.stream().filter(methodNode -> "func_184808_cD".equals(methodNode.name) && "()V".equals(methodNode.desc)).findFirst();
        if (optional_func_184808_cD.isPresent()) {
            originNode.methods.removeIf(methodNode -> "func_184808_cD".equals(methodNode.name) && "()V".equals(methodNode.desc));
            originNode.methods.add(optional_func_184808_cD.get());
        }
        if ((optional_func_70047_e = patchedNode.methods.stream().filter(methodNode -> "func_70047_e".equals(methodNode.name) && "()V".equals(methodNode.desc)).findFirst()).isPresent()) {
            originNode.methods.removeIf(methodNode -> "func_70047_e".equals(methodNode.name) && "()F".equals(methodNode.desc));
            originNode.methods.add(optional_func_70047_e.get());
        }
        if ((optional_func_71000_j = patchedNode.methods.stream().filter(methodNode -> "func_71000_j".equals(methodNode.name) && "(DDD)V".equals(methodNode.desc)).findFirst()).isPresent()) {
            originNode.methods.removeIf(methodNode -> "func_71000_j".equals(methodNode.name) && "(DDD)V".equals(methodNode.desc));
            originNode.methods.add(optional_func_71000_j.get());
        }
        if ((optional_func_174820_d = patchedNode.methods.stream().filter(methodNode -> "func_174820_d".equals(methodNode.name) && "(ILnet/minecraft/item/ItemStack;)Z".equals(methodNode.desc)).findFirst()).isPresent()) {
            originNode.methods.removeIf(methodNode -> "func_174820_d".equals(methodNode.name) && "(ILnet/minecraft/item/ItemStack;)Z".equals(methodNode.desc));
            originNode.methods.add(optional_func_174820_d.get());
        }
        ClassWriter writer = new ClassWriter(0);
        originNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

