/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.command;

import catserver.server.command.ModCustomCommand;
import java.util.Arrays;
import java.util.regex.Pattern;
import net.minecraft.server.MinecraftServer;
import net.minecraftforge.fml.common.FMLCommonHandler;
import org.bukkit.Server;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.ProxiedCommandSender;
import org.bukkit.command.RemoteConsoleCommandSender;
import org.bukkit.command.SimpleCommandMap;
import org.bukkit.craftbukkit.v1_12_R1.command.CraftBlockCommandSender;
import org.bukkit.craftbukkit.v1_12_R1.command.CraftFunctionCommandSender;
import org.bukkit.craftbukkit.v1_12_R1.command.ProxiedNativeCommandSender;
import org.bukkit.craftbukkit.v1_12_R1.entity.CraftEntity;

public class CraftSimpleCommandMap
extends SimpleCommandMap {
    private static final Pattern PATTERN_ON_SPACE = Pattern.compile(" ", 16);
    private final MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();

    public CraftSimpleCommandMap(Server server) {
        super(server);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean dispatch(CommandSender sender, String commandLine) throws CommandException {
        String[] args = PATTERN_ON_SPACE.split(commandLine);
        if (args.length == 0) {
            return false;
        }
        String sentCommandLabel = args[0].toLowerCase();
        Command target = this.getCommand(sentCommandLabel);
        if (target == null) {
            return false;
        }
        try {
            if (target instanceof ModCustomCommand) {
                if (!target.testPermission(sender)) {
                    return true;
                }
                if (sender instanceof ConsoleCommandSender) {
                    this.server.N().a((bn)this.server, commandLine);
                    return true;
                } else if (sender instanceof RemoteConsoleCommandSender) {
                    this.server.N().a((bn)((nz)this.server).o, commandLine);
                    return true;
                } else if (sender instanceof CraftEntity) {
                    this.server.N().a((bn)((CraftEntity)sender).getHandle(), commandLine);
                    return true;
                } else if (sender instanceof CraftBlockCommandSender) {
                    this.server.N().a(((CraftBlockCommandSender)sender).getTileEntity(), commandLine);
                    return true;
                } else if (sender instanceof ProxiedCommandSender) {
                    this.server.N().a(((ProxiedNativeCommandSender)sender).getHandle(), commandLine);
                    return true;
                } else {
                    if (!(sender instanceof CraftFunctionCommandSender)) throw new CommandException("Unknown sender type: " + sender.getClass().getName());
                    this.server.N().a(((CraftFunctionCommandSender)sender).getHandle(), commandLine);
                }
                return true;
            } else {
                target.execute(sender, sentCommandLabel, Arrays.copyOfRange(args, 1, args.length));
            }
            return true;
        }
        catch (CommandException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new CommandException("Unhandled exception executing '" + commandLine + "' in " + target, ex);
        }
    }

    @Deprecated
    public void setVanillaConsoleSender(bn console) {
    }
}

