/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.command.internal;

import catserver.server.CatServer;
import net.minecraftforge.common.DimensionManager;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.v1_12_R1.CraftServer;

public class CommandCatserver
extends Command {
    public CommandCatserver(String name) {
        super(name);
        this.description = "CatServer related commands";
        this.usageMessage = "/catserver worlds|reload|reloadall";
        this.setPermission("catserver.command.catserver");
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length < 1) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        if (args[0].equals("worlds")) {
            sender.sendMessage(CommandCatserver.formatStringLength("Dim", 8) + " " + CommandCatserver.formatStringLength("Name", 8) + " " + CommandCatserver.formatStringLength("Type", 8));
            for (Integer dimension : DimensionManager.getStaticDimensionIDs()) {
                oo world = DimensionManager.getWorld(dimension, false);
                String name = world != null ? world.getWorld().getName() : "(Unload)";
                String type = DimensionManager.getProviderType(dimension).toString();
                sender.sendMessage(CommandCatserver.formatStringLength(String.valueOf(dimension), 8) + " " + CommandCatserver.formatStringLength(name, 8) + " " + CommandCatserver.formatStringLength(type, 8));
            }
        } else if (args[0].equals("reload")) {
            CatServer.getConfig().loadConfig();
            sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Configuration reload complete.");
        } else if (args[0].equals("reloadall")) {
            CatServer.getConfig().loadConfig();
            ((CraftServer)Bukkit.getServer()).reloadConfig();
            sender.sendMessage((Object)((Object)ChatColor.GREEN) + "Configuration reload complete.");
        }
        return true;
    }

    private static String formatStringLength(String str, int size) {
        int formatLength = size - str.length();
        for (int i = 0; i < formatLength; ++i) {
            str = str + " ";
        }
        return str;
    }
}

