/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.command.internal;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ClickEvent;
import net.md_5.bungee.api.chat.HoverEvent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class CommandChunkStats
extends Command {
    private static Map<axw, Long> chunks = new HashMap<axw, Long>();
    private static boolean enable = false;
    private static long lastNanoTime = 0L;
    private static int totalTick = 0;

    public CommandChunkStats(String name) {
        super(name);
        this.description = "Chunk Stats Command";
        this.usageMessage = "/chunkstats start/stop";
        this.setPermission("catserver.command.chunkstats");
    }

    @Override
    public boolean execute(CommandSender sender, String commandLabel, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
            return false;
        }
        if (args[0].equals("start")) {
            if (!enable) {
                chunks = new HashMap<axw, Long>();
                lastNanoTime = 0L;
                totalTick = 0;
                enable = true;
                sender.sendMessage("Chunk stats started.");
            } else {
                sender.sendMessage("Already running!");
            }
            return true;
        }
        if (args[0].equals("stop")) {
            if (enable) {
                enable = false;
                sender.sendMessage("Please wait for analyzing..");
                ArrayList<ChunkTime> chunkList = new ArrayList<ChunkTime>();
                for (int i = 0; i < 10; ++i) {
                    axw hight = null;
                    long t = 0L;
                    for (axw chunkPos : chunks.keySet()) {
                        if (hight == null) {
                            hight = chunkPos;
                            t = chunks.get(chunkPos);
                            continue;
                        }
                        long tt = chunks.get(chunkPos);
                        if (tt <= t) continue;
                        hight = chunkPos;
                        t = tt;
                    }
                    chunkList.add(new ChunkTime(hight, t));
                    chunks.remove(hight);
                }
                chunks.clear();
                sender.sendMessage("Chunks Time:");
                for (ChunkTime chunkTime : chunkList) {
                    int chunkX = chunkTime.chunk.b;
                    int chunkZ = chunkTime.chunk.c;
                    int posX = chunkX << 4;
                    int posZ = chunkZ << 4;
                    int time = (int)(chunkTime.time / 1000L / 1000L);
                    int avg2 = totalTick > 0 ? time / totalTick : 0;
                    TextComponent component = new TextComponent(String.format("[%s: %d,%d at chunk %d,%d] has running time: %d ms (Arg %d ms/tick)", chunkTime.chunk.k.getWorld().getName(), posX, posZ, chunkX, chunkZ, time, avg2));
                    component.setClickEvent(new ClickEvent(ClickEvent.Action.RUN_COMMAND, String.format("/minecraft:tp %d 128 %d", posX, posZ)));
                    component.setHoverEvent(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (BaseComponent[])new TextComponent[]{new TextComponent(String.format("Execute command: /minecraft:tp %d 128 %d", posX, posZ))}));
                    sender.spigot().sendMessage((BaseComponent)component);
                }
            } else {
                sender.sendMessage("Not start!");
            }
            return true;
        }
        sender.sendMessage((Object)((Object)ChatColor.RED) + "Usage: " + this.usageMessage);
        return false;
    }

    public static void onServerTick() {
        if (!enable) {
            return;
        }
        ++totalTick;
    }

    public static void onTickStart() {
        if (!enable) {
            return;
        }
        lastNanoTime = System.nanoTime();
    }

    public static void onTickEnd(amu world, et pos) {
        if (!enable) {
            return;
        }
        axw chunk = world.getChunkIfLoaded(pos.p() >> 4, pos.r() >> 4);
        if (chunk != null && lastNanoTime > 0L) {
            Long oldTime = chunks.getOrDefault(chunk, 0L);
            oldTime = oldTime + (System.nanoTime() - lastNanoTime);
            chunks.put(chunk, oldTime);
        }
    }

    static class ChunkTime {
        public final axw chunk;
        public final long time;

        public ChunkTime(axw chunk, long time) {
            this.chunk = chunk;
            this.time = time;
        }
    }
}

