/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.patcher;

import catserver.server.CatServer;
import catserver.server.patcher.IPatcher;
import catserver.server.patcher.plugin.CitizensPatcher;
import catserver.server.patcher.plugin.CoreProtectPatcher;
import catserver.server.patcher.plugin.DynmapPacher;
import catserver.server.patcher.plugin.EssentialsPatcher;
import catserver.server.patcher.plugin.MythicMobsPatcher;
import catserver.server.patcher.plugin.SuperiorSkyblock2Pathcer;
import catserver.server.patcher.plugin.WorldEditPatcher;
import java.util.HashMap;
import java.util.Map;

public class PatcherManager {
    private static Map<String, IPatcher> pluginPatcher = new HashMap<String, IPatcher>();

    public static IPatcher getPluginPatcher(String pluginName) {
        return pluginPatcher.get(pluginName);
    }

    public static boolean registerPluginPatcher(String pluginName, IPatcher patcher) {
        if (!pluginPatcher.containsKey(pluginName) && patcher != null) {
            pluginPatcher.put(pluginName, patcher);
            return true;
        }
        return false;
    }

    static {
        if (CatServer.getConfig().enableDynmapCompatible) {
            PatcherManager.registerPluginPatcher("dynmap", new DynmapPacher());
        }
        if (CatServer.getConfig().enableCoreProtectModBlockCompatible) {
            PatcherManager.registerPluginPatcher("CoreProtect", new CoreProtectPatcher());
        }
        if (CatServer.getConfig().enableEssentialsNewVersionCompatible) {
            PatcherManager.registerPluginPatcher("Essentials", new EssentialsPatcher());
        }
        if (CatServer.getConfig().enableMythicMobsPatcherCompatible) {
            PatcherManager.registerPluginPatcher("MythicMobs", new MythicMobsPatcher());
        }
        if (CatServer.getConfig().enableWorldEditCompatible) {
            PatcherManager.registerPluginPatcher("WorldEdit", new WorldEditPatcher());
        }
        if (CatServer.getConfig().enableCitizensCompatible) {
            PatcherManager.registerPluginPatcher("Citizens", new CitizensPatcher());
        }
        if (CatServer.getConfig().enableSuperiorSkyblock2Compatible) {
            PatcherManager.registerPluginPatcher("SuperiorSkyblock2", new SuperiorSkyblock2Pathcer());
        }
    }
}

