/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.patcher.plugin;

import catserver.server.patcher.IPatcher;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.permissions.Permission;
import org.bukkit.permissions.PermissionDefault;
import org.bukkit.plugin.PluginManager;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class EssentialsPatcher
implements IPatcher {
    @Override
    public byte[] transform(String className, byte[] basicClass) {
        if (className.equals("com.earth2me.essentials.commands.Commandhat")) {
            return this.patchCommandhat(basicClass);
        }
        if (className.equals("com.earth2me.essentials.perm.PermissionsDefaults")) {
            return this.patchPermissionsDefaults(basicClass);
        }
        return basicClass;
    }

    private byte[] patchCommandhat(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("registerPermissionsIfNecessary") || !method.desc.equals("(Lorg/bukkit/plugin/PluginManager;)V")) continue;
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(EssentialsPatcher.class), "registerPermissionsIfNecessaryHook", "(Lorg/bukkit/plugin/PluginManager;)V", false));
            insnList.add((AbstractInsnNode)new InsnNode(177));
            method.instructions = insnList;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchPermissionsDefaults(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("registerAllHatDefaults") || !method.desc.equals("()V")) continue;
            InsnList insnList = new InsnList();
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, Type.getInternalName(EssentialsPatcher.class), "registerAllHatDefaultsHook", "()V", false));
            insnList.add((AbstractInsnNode)new InsnNode(177));
            method.instructions = insnList;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static void registerPermissionsIfNecessaryHook(PluginManager toRegister) {
        Permission hatPerm = toRegister.getPermission("essentials.hat.prevent-type.*");
        if (hatPerm != null) {
            return;
        }
        ImmutableMap.Builder children = ImmutableMap.builder();
        for (Material mat : Material.values()) {
            String matPerm;
            if (mat.getMaterialType() != Material.MaterialType.VANILLA && mat.getMaterialType() != Material.MaterialType.MOD_ITEM || toRegister.getPermission(matPerm = "essentials.hat.prevent-type." + mat.name().toLowerCase()) != null) continue;
            children.put((Object)matPerm, (Object)true);
            toRegister.addPermission(new Permission(matPerm, "Prevent using " + (Object)((Object)mat) + " as a type of hat.", PermissionDefault.FALSE));
        }
        toRegister.addPermission(new Permission("essentials.hat.prevent-type.*", "Prevent all types of hats", PermissionDefault.FALSE, (Map<String, Boolean>)children.build()));
    }

    public static void registerAllHatDefaultsHook() {
        PluginManager pluginManager = Bukkit.getPluginManager();
        Permission hatPerm = pluginManager.getPermission("essentials.hat.prevent-type.*");
        if (hatPerm != null) {
            return;
        }
        ImmutableMap.Builder children = ImmutableMap.builder();
        for (Material mat : Material.values()) {
            String matPerm;
            if (mat.getMaterialType() != Material.MaterialType.VANILLA && mat.getMaterialType() != Material.MaterialType.MOD_ITEM || pluginManager.getPermission(matPerm = "essentials.hat.prevent-type." + mat.name().toLowerCase()) != null) continue;
            children.put((Object)matPerm, (Object)true);
            pluginManager.addPermission(new Permission(matPerm, "Prevent using " + (Object)((Object)mat) + " as a type of hat.", PermissionDefault.FALSE));
        }
        pluginManager.addPermission(new Permission("essentials.hat.prevent-type.*", "Prevent all types of hats", PermissionDefault.FALSE, (Map<String, Boolean>)children.build()));
    }
}

