/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.patcher.plugin;

import catserver.server.inventory.BukkitMaterialHelper;
import catserver.server.patcher.IPatcher;
import java.util.Locale;
import org.bukkit.Material;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class WorldEditPatcher
implements IPatcher {
    @Override
    public byte[] transform(String className, byte[] basicClass) {
        if (className.equals("com.sk89q.worldedit.bukkit.BukkitServerInterface")) {
            return this.patchBukkitServerInterface(basicClass);
        }
        if (className.equals("com.sk89q.worldedit.bukkit.BukkitWorld")) {
            return this.patchBukkitWorld(basicClass);
        }
        if (className.equals("com.sk89q.worldedit.world.registry.NullItemRegistry")) {
            return this.patchNullItemRegistry(basicClass);
        }
        return basicClass;
    }

    private byte[] patchBukkitServerInterface(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("resolveItem") || !method.desc.equals("(Ljava/lang/String;)I")) continue;
            for (AbstractInsnNode next : method.instructions) {
                if (!(next instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)next;
                if (!methodInsnNode.owner.equals("org/bukkit/Material") || !methodInsnNode.name.equals("matchMaterial") || !methodInsnNode.desc.equals("(Ljava/lang/String;)Lorg/bukkit/Material;")) continue;
                methodInsnNode.owner = Type.getInternalName(WorldEditPatcher.class);
                methodInsnNode.name = "matchMaterialHook";
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static Material matchMaterialHook(String name) {
        Material material = Material.getMaterial(name.toUpperCase(Locale.ENGLISH).replaceAll("\\s+", "_").replaceAll("\\W", ""));
        return material != null ? BukkitMaterialHelper.convertModItemMaterialToBlock(material) : null;
    }

    private byte[] patchBukkitWorld(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            if (!method.name.equals("isValidBlockType") || !method.desc.equals("(I)Z")) continue;
            for (AbstractInsnNode next : method.instructions) {
                if (!(next instanceof MethodInsnNode)) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)next;
                if (!methodInsnNode.owner.equals("org/bukkit/Material") || !methodInsnNode.name.equals("getMaterial") || !methodInsnNode.desc.equals("(I)Lorg/bukkit/Material;")) continue;
                methodInsnNode.name = "getBlockMaterial";
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchNullItemRegistry(byte[] basicClass) {
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (MethodNode method : node.methods) {
            LabelNode label3;
            LabelNode label2;
            LabelNode label1;
            InsnList insnList;
            if (method.name.equals("createFromId") && method.desc.equals("(Ljava/lang/String;)Lcom/sk89q/worldedit/blocks/BaseItem;")) {
                insnList = new InsnList();
                label1 = new LabelNode();
                label2 = new LabelNode();
                label3 = new LabelNode();
                insnList.add((AbstractInsnNode)label1);
                insnList.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/item/Item", "field_150901_e", "Lnet/minecraft/util/registry/RegistryNamespaced;"));
                insnList.add((AbstractInsnNode)new TypeInsnNode(187, "net/minecraft/util/ResourceLocation"));
                insnList.add((AbstractInsnNode)new InsnNode(89));
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 1));
                insnList.add((AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/util/ResourceLocation", "<init>", "(Ljava/lang/String;)V", false));
                insnList.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/util/registry/RegistryNamespaced", "func_82594_a", "(Ljava/lang/Object;)Ljava/lang/Object;", false));
                insnList.add((AbstractInsnNode)new TypeInsnNode(192, "net/minecraft/item/Item"));
                insnList.add((AbstractInsnNode)new VarInsnNode(58, 2));
                insnList.add((AbstractInsnNode)label2);
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 2));
                insnList.add((AbstractInsnNode)new JumpInsnNode(198, label3));
                insnList.add((AbstractInsnNode)new TypeInsnNode(187, "com/sk89q/worldedit/blocks/BaseItem"));
                insnList.add((AbstractInsnNode)new InsnNode(89));
                insnList.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/item/Item", "field_150901_e", "Lnet/minecraft/util/registry/RegistryNamespaced;"));
                insnList.add((AbstractInsnNode)new VarInsnNode(25, 2));
                insnList.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/util/registry/RegistryNamespaced", "func_148757_b", "(Ljava/lang/Object;)I", false));
                insnList.add((AbstractInsnNode)new InsnNode(3));
                insnList.add((AbstractInsnNode)new MethodInsnNode(183, "com/sk89q/worldedit/blocks/BaseItem", "<init>", "(IS)V", false));
                insnList.add((AbstractInsnNode)new InsnNode(176));
                insnList.add((AbstractInsnNode)label3);
                insnList.add((AbstractInsnNode)new FrameNode(-1, 3, new Object[]{"com/sk89q/worldedit/world/registry/NullItemRegistry", "java/lang/String", "net/minecraft/item/Item"}, 0, new Object[0]));
                insnList.add((AbstractInsnNode)new InsnNode(1));
                insnList.add((AbstractInsnNode)new InsnNode(176));
                method.instructions = insnList;
                method.localVariables.clear();
                method.maxStack = 4;
                method.maxLocals = 3;
            }
            if (!method.name.equals("createFromId") || !method.desc.equals("(I)Lcom/sk89q/worldedit/blocks/BaseItem;")) continue;
            insnList = new InsnList();
            label1 = new LabelNode();
            label2 = new LabelNode();
            label3 = new LabelNode();
            insnList.add((AbstractInsnNode)label1);
            insnList.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/item/Item", "field_150901_e", "Lnet/minecraft/util/registry/RegistryNamespaced;"));
            insnList.add((AbstractInsnNode)new VarInsnNode(21, 1));
            insnList.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/util/registry/RegistryNamespaced", "func_148754_a", "(I)Ljava/lang/Object;", false));
            insnList.add((AbstractInsnNode)new JumpInsnNode(198, label3));
            insnList.add((AbstractInsnNode)label2);
            insnList.add((AbstractInsnNode)new TypeInsnNode(187, "com/sk89q/worldedit/blocks/BaseItem"));
            insnList.add((AbstractInsnNode)new InsnNode(89));
            insnList.add((AbstractInsnNode)new VarInsnNode(21, 1));
            insnList.add((AbstractInsnNode)new InsnNode(3));
            insnList.add((AbstractInsnNode)new MethodInsnNode(183, "com/sk89q/worldedit/blocks/BaseItem", "<init>", "(IS)V", false));
            insnList.add((AbstractInsnNode)new InsnNode(176));
            insnList.add((AbstractInsnNode)label3);
            insnList.add((AbstractInsnNode)new FrameNode(-1, 2, new Object[]{"com/sk89q/worldedit/world/registry/NullItemRegistry", 1}, 0, new Object[0]));
            insnList.add((AbstractInsnNode)new InsnNode(1));
            insnList.add((AbstractInsnNode)new InsnNode(176));
            method.instructions = insnList;
            method.localVariables.clear();
            method.maxStack = 4;
            method.maxLocals = 2;
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

