/*
 * Decompiled with CFR 0.152.
 */
package catserver.server.remapper;

import catserver.server.remapper.CatServerRemapper;
import catserver.server.remapper.ClassInheritanceProvider;
import catserver.server.remapper.MappingLoader;
import catserver.server.remapper.RemapRules;
import catserver.server.remapper.target.CatClassLoader;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import net.md_5.specialsource.JarMapping;
import net.md_5.specialsource.provider.InheritanceProvider;
import net.md_5.specialsource.provider.JointProvider;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;

public class ReflectionTransformer {
    public static JarMapping jarMapping;
    public static CatServerRemapper remapper;
    public static final HashMap<String, String> classReverseMapping;
    public static final Multimap<String, String> methodReverseMapping;
    public static final Multimap<String, String> fieldReverseMapping;
    public static final Multimap<String, String> methodFastMapping;

    public static void init() {
        jarMapping = MappingLoader.loadMapping();
        JointProvider provider = new JointProvider();
        provider.add((InheritanceProvider)new ClassInheritanceProvider());
        jarMapping.setFallbackInheritanceProvider((InheritanceProvider)provider);
        remapper = new CatServerRemapper(jarMapping);
        ReflectionTransformer.jarMapping.classes.forEach((k, v) -> classReverseMapping.put((String)v, (String)k));
        ReflectionTransformer.jarMapping.methods.forEach((k, v) -> methodReverseMapping.put(v, k));
        ReflectionTransformer.jarMapping.fields.forEach((k, v) -> fieldReverseMapping.put(v, k));
        ReflectionTransformer.jarMapping.methods.forEach((k, v) -> methodFastMapping.put((Object)k.split("\\s+")[0], k));
        try {
            Class.forName("catserver.server.remapper.target.MethodHandleMethods");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public static byte[] transform(byte[] code) {
        ClassReader reader = new ClassReader(code);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        boolean remapCL = false;
        Class<?> remappedSuperClass = RemapRules.getSuperClassTarget(node.superName);
        if (remappedSuperClass != null) {
            if (remappedSuperClass == CatClassLoader.class) {
                RemapRules.addVirtualMethodTarget(node.name + ";defineClass", CatClassLoader.class);
            }
            node.superName = Type.getInternalName(remappedSuperClass);
            remapCL = true;
        }
        for (MethodNode method : node.methods) {
            for (AbstractInsnNode next : method.instructions) {
                MethodInsnNode insn;
                if (next instanceof TypeInsnNode && next.getOpcode() == 187) {
                    insn = (TypeInsnNode)next;
                    Class<?> remappedClass = RemapRules.getSuperClassTarget(insn.desc);
                    if (remappedClass != null) {
                        insn.desc = Type.getInternalName(remappedClass);
                        remapCL = true;
                    }
                }
                if (!(next instanceof MethodInsnNode)) continue;
                insn = (MethodInsnNode)next;
                switch (insn.getOpcode()) {
                    case 182: {
                        ReflectionTransformer.remapVirtual(insn);
                        break;
                    }
                    case 184: {
                        ReflectionTransformer.remapStatic(insn);
                        break;
                    }
                    case 183: {
                        if (remapCL) {
                            ReflectionTransformer.remapSuperClass(insn);
                        }
                        ReflectionTransformer.remapScriptEngineManager(insn, method);
                    }
                }
            }
        }
        ClassWriter writer = new ClassWriter(0);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public static void remapStatic(MethodInsnNode insn) {
        Class<?> remappedClass = RemapRules.getStaticMethodTarget(insn.owner + ";" + insn.name);
        if (remappedClass != null) {
            insn.owner = Type.getInternalName(remappedClass);
        }
    }

    public static void remapVirtual(MethodInsnNode insn) {
        Class<?> remappedClass = RemapRules.getVirtualMethodToStaticTarget(insn.owner + ";" + insn.name);
        if (remappedClass != null) {
            Type returnType = Type.getReturnType((String)insn.desc);
            ArrayList<Type> args = new ArrayList<Type>();
            args.add(Type.getObjectType((String)insn.owner));
            args.addAll(Arrays.asList(Type.getArgumentTypes((String)insn.desc)));
            insn.setOpcode(184);
            insn.owner = Type.getInternalName(remappedClass);
            insn.desc = Type.getMethodDescriptor((Type)returnType, (Type[])args.toArray(new Type[0]));
        } else {
            remappedClass = RemapRules.getVirtualMethodTarget(insn.owner + ";" + insn.name);
            if (remappedClass != null) {
                insn.name = insn.name + "Remap";
                insn.owner = Type.getInternalName(remappedClass);
            }
        }
    }

    private static void remapSuperClass(MethodInsnNode insn) {
        Class<?> remappedClass = RemapRules.getSuperClassTarget(insn.owner);
        if (remappedClass != null && insn.name.equals("<init>")) {
            insn.owner = Type.getInternalName(remappedClass);
        }
    }

    private static void remapScriptEngineManager(MethodInsnNode insn, MethodNode node) {
        if (insn.owner.equals("javax/script/ScriptEngineManager") && insn.desc.equals("()V") && insn.name.equals("<init>")) {
            insn.desc = "(Ljava/lang/ClassLoader;)V";
            node.instructions.insertBefore((AbstractInsnNode)insn, (AbstractInsnNode)new MethodInsnNode(184, "java/lang/ClassLoader", "getSystemClassLoader", "()Ljava/lang/ClassLoader;"));
            ++node.maxStack;
        }
    }

    static {
        classReverseMapping = Maps.newHashMap();
        methodReverseMapping = ArrayListMultimap.create();
        fieldReverseMapping = ArrayListMultimap.create();
        methodFastMapping = ArrayListMultimap.create();
    }
}

