/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.crafting;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.minecraftforge.common.crafting.CompoundIngredient;
import net.minecraftforge.common.crafting.IConditionFactory;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.IngredientNBT;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreIngredient;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class CraftingHelper {
    private static final boolean DEBUG_LOAD_MINECRAFT = false;
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final Map<nf, IConditionFactory> conditions = Maps.newHashMap();
    private static final Map<nf, IIngredientFactory> ingredients = Maps.newHashMap();
    private static final Map<nf, IRecipeFactory> recipes = Maps.newHashMap();
    public static final FactoryLoader<IIngredientFactory> INGREDIENTS;
    public static final FactoryLoader<IRecipeFactory> RECIPES;
    public static final FactoryLoader<IConditionFactory> CONDITIONS;

    public static void register(nf key, IConditionFactory factory) {
        if (conditions.containsKey(key)) {
            throw new IllegalStateException("Duplicate recipe condition factory: " + key);
        }
        conditions.put(key, factory);
    }

    public static void register(nf key, IRecipeFactory factory) {
        if (recipes.containsKey(key)) {
            throw new IllegalStateException("Duplicate recipe factory: " + key);
        }
        recipes.put(key, factory);
    }

    public static void register(nf key, IIngredientFactory factory) {
        if (ingredients.containsKey(key)) {
            throw new IllegalStateException("Duplicate recipe ingredient factory: " + key);
        }
        ingredients.put(key, factory);
    }

    public static akq getIngredient(Object obj) {
        if (obj instanceof akq) {
            return (akq)obj;
        }
        if (obj instanceof aip) {
            return akq.a((aip[])new aip[]{((aip)obj).l()});
        }
        if (obj instanceof ain) {
            return akq.a((ain)((ain)obj));
        }
        if (obj instanceof aow) {
            return akq.a((aip[])new aip[]{new aip((aow)obj, 1, Short.MAX_VALUE)});
        }
        if (obj instanceof String) {
            return new OreIngredient((String)obj);
        }
        if (obj instanceof JsonElement) {
            throw new IllegalArgumentException("JsonObjects must use getIngredient(JsonObject, JsonContext)");
        }
        return null;
    }

    @Nonnull
    public static akq getIngredient(JsonElement json, JsonContext context) {
        String item;
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("getIngredient Context cannot be null");
        }
        if (json.isJsonArray()) {
            ArrayList ingredients = Lists.newArrayList();
            ArrayList vanilla = Lists.newArrayList();
            json.getAsJsonArray().forEach(ele -> {
                akq ing = CraftingHelper.getIngredient(ele, context);
                if (ing.getClass() == akq.class) {
                    vanilla.add(ing);
                } else {
                    ingredients.add(ing);
                }
            });
            if (!vanilla.isEmpty()) {
                ingredients.add(akq.merge((Collection)vanilla));
            }
            if (ingredients.size() == 0) {
                throw new JsonSyntaxException("Item array cannot be empty, at least one item must be defined");
            }
            if (ingredients.size() == 1) {
                return (akq)ingredients.get(0);
            }
            return new CompoundIngredient(ingredients);
        }
        if (!json.isJsonObject()) {
            throw new JsonSyntaxException("Expcted ingredient to be a object or array of objects");
        }
        JsonObject obj = (JsonObject)json;
        String type = context.appendModId(rc.a((JsonObject)obj, (String)"type", (String)"minecraft:item"));
        if (type.isEmpty()) {
            throw new JsonSyntaxException("Ingredient type can not be an empty string");
        }
        if (type.equals("minecraft:item") && (item = rc.h((JsonObject)obj, (String)"item")).startsWith("#")) {
            akq constant = context.getConstant(item.substring(1));
            if (constant == null) {
                throw new JsonSyntaxException("Ingredient referenced invalid constant: " + item);
            }
            return constant;
        }
        IIngredientFactory factory = ingredients.get(new nf(type));
        if (factory == null) {
            throw new JsonSyntaxException("Unknown ingredient type: " + type);
        }
        return factory.parse(context, obj);
    }

    public static aip getItemStack(JsonObject json, JsonContext context) {
        String itemName = context.appendModId(rc.h((JsonObject)json, (String)"item"));
        ain item = ForgeRegistries.ITEMS.getValue(new nf(itemName));
        if (item == null) {
            throw new JsonSyntaxException("Unknown item '" + itemName + "'");
        }
        if (item.k() && !json.has("data")) {
            throw new JsonParseException("Missing data for item '" + itemName + "'");
        }
        if (json.has("nbt")) {
            try {
                JsonElement element = json.get("nbt");
                fy nbt = element.isJsonObject() ? gp.a((String)GSON.toJson(element)) : gp.a((String)rc.a((JsonElement)element, (String)"nbt"));
                fy tmp = new fy();
                if (nbt.e("ForgeCaps")) {
                    tmp.a("ForgeCaps", nbt.c("ForgeCaps"));
                    nbt.r("ForgeCaps");
                }
                tmp.a("tag", (gn)nbt);
                tmp.a("id", itemName);
                tmp.a("Count", rc.a((JsonObject)json, (String)"count", (int)1));
                tmp.a("Damage", rc.a((JsonObject)json, (String)"data", (int)0));
                return new aip(tmp);
            }
            catch (go e) {
                throw new JsonSyntaxException("Invalid NBT Entry: " + e.toString());
            }
        }
        return new aip(item, rc.a((JsonObject)json, (String)"count", (int)1), rc.a((JsonObject)json, (String)"data", (int)0));
    }

    public static aip getItemStackBasic(JsonObject json, JsonContext context) {
        String itemName = context.appendModId(rc.h((JsonObject)json, (String)"item"));
        ain item = ForgeRegistries.ITEMS.getValue(new nf(itemName));
        if (item == null) {
            throw new JsonSyntaxException("Unknown item '" + itemName + "'");
        }
        if (item.k() && !json.has("data")) {
            throw new JsonParseException("Missing data for item '" + itemName + "'");
        }
        return new aip(item, 1, rc.a((JsonObject)json, (String)"data", (int)0));
    }

    public static ShapedPrimer parseShaped(Object ... recipe) {
        ShapedPrimer ret = new ShapedPrimer();
        String shape = "";
        int idx = 0;
        if (recipe[idx] instanceof Boolean) {
            ret.mirrored = (Boolean)recipe[idx];
            if (recipe[idx + 1] instanceof Object[]) {
                recipe = (Object[])recipe[idx + 1];
            } else {
                idx = 1;
            }
        }
        if (recipe[idx] instanceof String[]) {
            String[] parts = (String[])recipe[idx++];
            for (String s : parts) {
                ret.width = s.length();
                shape = shape + (String)s;
            }
            ret.height = parts.length;
        } else {
            while (recipe[idx] instanceof String) {
                String s = (String)recipe[idx++];
                shape = shape + s;
                ret.width = s.length();
                ++ret.height;
            }
        }
        if (ret.width * ret.height != shape.length() || shape.length() == 0) {
            String err = "Invalid shaped recipe: ";
            for (Object tmp : recipe) {
                err = err + tmp + ", ";
            }
            throw new RuntimeException(err);
        }
        HashMap itemMap = Maps.newHashMap();
        itemMap.put(Character.valueOf(' '), akq.a);
        while (idx < recipe.length) {
            Character chr = (Character)recipe[idx];
            Object in = recipe[idx + 1];
            akq ing = CraftingHelper.getIngredient(in);
            if (' ' == chr.charValue()) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            if (ing == null) {
                String err = "Invalid shaped ore recipe: ";
                for (Object tmp : recipe) {
                    err = err + tmp + ", ";
                }
                throw new RuntimeException(err);
            }
            itemMap.put(chr, ing);
            idx += 2;
        }
        ret.input = fi.a((int)(ret.width * ret.height), (Object)akq.a);
        HashSet keys = Sets.newHashSet(itemMap.keySet());
        keys.remove(Character.valueOf(' '));
        int x = 0;
        for (char chr : shape.toCharArray()) {
            akq ing = (akq)itemMap.get(Character.valueOf(chr));
            if (ing == null) {
                throw new IllegalArgumentException("Pattern references symbol '" + chr + "' but it's not defined in the key");
            }
            ret.input.set(x++, (Object)ing);
            keys.remove(Character.valueOf(chr));
        }
        if (!keys.isEmpty()) {
            throw new IllegalArgumentException("Key defines symbols that aren't used in pattern: " + keys);
        }
        return ret;
    }

    public static boolean processConditions(JsonObject json, String memberName, JsonContext context) {
        return !json.has(memberName) || CraftingHelper.processConditions(rc.u((JsonObject)json, (String)memberName), context);
    }

    public static boolean processConditions(JsonArray conditions, JsonContext context) {
        for (int x = 0; x < conditions.size(); ++x) {
            if (!conditions.get(x).isJsonObject()) {
                throw new JsonSyntaxException("Conditions must be an array of JsonObjects");
            }
            JsonObject json = conditions.get(x).getAsJsonObject();
            BooleanSupplier cond = CraftingHelper.getCondition(json, context);
            if (cond.getAsBoolean()) continue;
            return false;
        }
        return true;
    }

    public static BooleanSupplier getCondition(JsonObject json, JsonContext context) {
        nf type = new nf(context.appendModId(rc.h((JsonObject)json, (String)"type")));
        IConditionFactory factory = conditions.get(type);
        if (factory == null) {
            throw new JsonSyntaxException("Unknown condition type: " + type.toString());
        }
        return factory.parse(context, json);
    }

    public static akt getRecipe(JsonObject json, JsonContext context) {
        if (json == null || json.isJsonNull()) {
            throw new JsonSyntaxException("Json cannot be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("getRecipe Context cannot be null");
        }
        String type = context.appendModId(rc.h((JsonObject)json, (String)"type"));
        if (type.isEmpty()) {
            throw new JsonSyntaxException("Recipe type can not be an empty string");
        }
        IRecipeFactory factory = recipes.get(new nf(type));
        if (factory == null) {
            throw new JsonSyntaxException("Unknown recipe type: " + type);
        }
        return factory.parse(context, json);
    }

    public static void init() {
        conditions.clear();
        ingredients.clear();
        recipes.clear();
        CraftingHelper.registerC("forge:mod_loaded", (context, json) -> {
            String modid = rc.h((JsonObject)json, (String)"modid");
            return () -> Loader.isModLoaded(modid);
        });
        CraftingHelper.registerC("minecraft:item_exists", (context, json) -> {
            String itemName = context.appendModId(rc.h((JsonObject)json, (String)"item"));
            return () -> ForgeRegistries.ITEMS.containsKey(new nf(itemName));
        });
        CraftingHelper.registerC("forge:not", (context, json) -> {
            BooleanSupplier child = CraftingHelper.getCondition(rc.t((JsonObject)json, (String)"value"), context);
            return () -> !child.getAsBoolean();
        });
        CraftingHelper.registerC("forge:or", (context, json) -> {
            JsonArray values = rc.u((JsonObject)json, (String)"values");
            ArrayList children = Lists.newArrayList();
            for (JsonElement j : values) {
                if (!j.isJsonObject()) {
                    throw new JsonSyntaxException("Or condition values must be an array of JsonObjects");
                }
                children.add(CraftingHelper.getCondition(j.getAsJsonObject(), context));
            }
            return () -> children.stream().anyMatch(BooleanSupplier::getAsBoolean);
        });
        CraftingHelper.registerC("forge:and", (context, json) -> {
            JsonArray values = rc.u((JsonObject)json, (String)"values");
            ArrayList children = Lists.newArrayList();
            for (JsonElement j : values) {
                if (!j.isJsonObject()) {
                    throw new JsonSyntaxException("And condition values must be an array of JsonObjects");
                }
                children.add(CraftingHelper.getCondition(j.getAsJsonObject(), context));
            }
            return () -> children.stream().allMatch(c2 -> c2.getAsBoolean());
        });
        CraftingHelper.registerC("forge:false", (context, json) -> () -> false);
        CraftingHelper.registerR("minecraft:crafting_shaped", (context, json) -> {
            String group = rc.a((JsonObject)json, (String)"group", (String)"");
            HashMap ingMap = Maps.newHashMap();
            for (Map.Entry entry : rc.t((JsonObject)json, (String)"key").entrySet()) {
                if (((String)entry.getKey()).length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
                }
                if (" ".equals(entry.getKey())) {
                    throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                }
                ingMap.put(Character.valueOf(((String)entry.getKey()).toCharArray()[0]), CraftingHelper.getIngredient((JsonElement)entry.getValue(), context));
            }
            ingMap.put(Character.valueOf(' '), akq.a);
            JsonArray patternJ = rc.u((JsonObject)json, (String)"pattern");
            if (patternJ.size() == 0) {
                throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
            }
            if (patternJ.size() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
            }
            String[] pattern = new String[patternJ.size()];
            for (int x = 0; x < pattern.length; ++x) {
                String line = rc.a((JsonElement)patternJ.get(x), (String)("pattern[" + x + "]"));
                if (line.length() > 3) {
                    throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
                }
                if (x > 0 && pattern[0].length() != line.length()) {
                    throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
                }
                pattern[x] = line;
            }
            fi input = fi.a((int)(pattern[0].length() * pattern.length), (Object)akq.a);
            HashSet keys = Sets.newHashSet(ingMap.keySet());
            keys.remove(Character.valueOf(' '));
            int x = 0;
            for (String line : pattern) {
                for (char chr : line.toCharArray()) {
                    akq ing = (akq)ingMap.get(Character.valueOf(chr));
                    if (ing == null) {
                        throw new JsonSyntaxException("Pattern references symbol '" + chr + "' but it's not defined in the key");
                    }
                    input.set(x++, (Object)ing);
                    keys.remove(Character.valueOf(chr));
                }
            }
            if (!keys.isEmpty()) {
                throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + keys);
            }
            aip result = CraftingHelper.getItemStack(rc.t((JsonObject)json, (String)"result"), context);
            return new akw(group, pattern[0].length(), pattern.length, input, result);
        });
        CraftingHelper.registerR("minecraft:crafting_shapeless", (context, json) -> {
            String group = rc.a((JsonObject)json, (String)"group", (String)"");
            fi ings = fi.a();
            for (JsonElement ele : rc.u((JsonObject)json, (String)"ingredients")) {
                ings.add((Object)CraftingHelper.getIngredient(ele, context));
            }
            if (ings.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (ings.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe");
            }
            aip itemstack = CraftingHelper.getItemStack(rc.t((JsonObject)json, (String)"result"), context);
            return new akx(group, itemstack, ings);
        });
        CraftingHelper.registerR("forge:ore_shaped", ShapedOreRecipe::factory);
        CraftingHelper.registerR("forge:ore_shapeless", ShapelessOreRecipe::factory);
        CraftingHelper.registerI("minecraft:item", (context, json) -> akq.a((aip[])new aip[]{CraftingHelper.getItemStackBasic(json, context)}));
        CraftingHelper.registerI("minecraft:empty", (context, json) -> akq.a);
        CraftingHelper.registerI("minecraft:item_nbt", (context, json) -> new IngredientNBT(CraftingHelper.getItemStack(json, context)));
        CraftingHelper.registerI("forge:ore_dict", (context, json) -> new OreIngredient(rc.h((JsonObject)json, (String)"ore")));
    }

    private static void registerC(String name, IConditionFactory fac) {
        CraftingHelper.register(new nf(name), fac);
    }

    private static void registerR(String name, IRecipeFactory fac) {
        CraftingHelper.register(new nf(name), fac);
    }

    private static void registerI(String name, IIngredientFactory fac) {
        CraftingHelper.register(new nf(name), fac);
    }

    private static void loadFactories(JsonObject json, JsonContext context, FactoryLoader ... loaders) {
        for (FactoryLoader loader : loaders) {
            CraftingHelper.loadFactory(json, context, loader);
        }
    }

    private static <T> void loadFactory(JsonObject json, JsonContext context, FactoryLoader<T> loader) {
        if (json.has(loader.name)) {
            for (Map.Entry entry : rc.t((JsonObject)json, (String)loader.name).entrySet()) {
                nf key = new nf(context.getModId(), (String)entry.getKey());
                String clsName = rc.a((JsonElement)((JsonElement)entry.getValue()), (String)(loader.name + "[" + entry.getValue() + "]"));
                loader.consumer.accept(key, (nf)CraftingHelper.getClassInstance(clsName, loader.type));
            }
        }
    }

    private static <T> T getClassInstance(String clsName, Class<T> expected) {
        try {
            Class<?> cls = Class.forName(clsName);
            if (!expected.isAssignableFrom(cls)) {
                throw new JsonSyntaxException("Class '" + clsName + "' is not an " + expected.getSimpleName());
            }
            return (T)cls.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new JsonSyntaxException("Could not find " + expected.getSimpleName() + ": " + clsName, (Throwable)e);
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new JsonSyntaxException("Could not instantiate " + expected.getSimpleName() + ": " + clsName, (Throwable)e);
        }
    }

    public static void loadRecipes(boolean revertFrozen) {
        CraftingHelper.init();
        ForgeRegistry reg = (ForgeRegistry)ForgeRegistries.RECIPES;
        if (revertFrozen) {
            GameData.revert(RegistryManager.FROZEN, GameData.RECIPES, false);
        }
        Loader.instance().setActiveModContainer(null);
        Loader.instance().getActiveModList().forEach(CraftingHelper::loadFactories);
        Loader.instance().getActiveModList().forEach(CraftingHelper::loadRecipes);
        Loader.instance().setActiveModContainer(null);
        GameData.fireRegistryEvents(rl2 -> rl2.equals((Object)GameData.RECIPES));
        FMLCommonHandler.instance().resetClientRecipeBook();
    }

    private static void loadFactories(ModContainer mod) {
        CraftingHelper.loadFactories(mod, "assets/" + mod.getModId() + "/recipes", INGREDIENTS, RECIPES, CONDITIONS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFactories(ModContainer mod, String base, FactoryLoader ... loaders) {
        FileSystem fs = null;
        try {
            Path fPath = null;
            JsonContext ctx = new JsonContext(mod.getModId());
            if (mod.getSource().isFile()) {
                fs = FileSystems.newFileSystem(mod.getSource().toPath(), (ClassLoader)null);
                fPath = fs.getPath("/" + base, "_factories.json");
            } else if (mod.getSource().isDirectory()) {
                fPath = mod.getSource().toPath().resolve(base).resolve("_factories.json");
            }
            if (fPath != null && Files.exists(fPath, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(fPath);){
                    JsonObject json = (JsonObject)rc.a((Gson)GSON, (Reader)reader, JsonObject.class);
                    CraftingHelper.loadFactories(json, ctx, loaders);
                }
            }
            IOUtils.closeQuietly((Closeable)fs);
        }
        catch (JsonParseException | IOException e) {
            FMLLog.log.error("Error loading _factories.json: ", e);
        }
        finally {
            IOUtils.closeQuietly(fs);
        }
    }

    private static boolean loadRecipes(ModContainer mod) {
        JsonContext ctx = new JsonContext(mod.getModId());
        return CraftingHelper.findFiles(mod, "assets/" + mod.getModId() + "/recipes", root -> {
            Path fPath = root.resolve("_constants.json");
            if (fPath != null && Files.exists(fPath, new LinkOption[0])) {
                try (BufferedReader reader = Files.newBufferedReader(fPath);){
                    JsonObject[] json = (JsonObject[])rc.a((Gson)GSON, (Reader)reader, JsonObject[].class);
                    ctx.loadConstants(json);
                }
                catch (JsonParseException | IOException e) {
                    FMLLog.log.error("Error loading _constants.json: ", e);
                    return false;
                }
            }
            return true;
        }, (root, file) -> {
            Loader.instance().setActiveModContainer(mod);
            String relative = root.relativize((Path)file).toString();
            if (!"json".equals(FilenameUtils.getExtension((String)file.toString()))) return true;
            if (relative.startsWith("_")) {
                return true;
            }
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            nf key = new nf(ctx.getModId(), name);
            try (BufferedReader reader = Files.newBufferedReader(file);){
                JsonObject json = (JsonObject)rc.a((Gson)GSON, (Reader)reader, JsonObject.class);
                if (!CraftingHelper.processConditions(json, "conditions", ctx)) {
                    Boolean bl2 = true;
                    return bl2;
                }
                akt recipe = CraftingHelper.getRecipe(json, ctx);
                ForgeRegistries.RECIPES.register((akt)((IForgeRegistryEntry)recipe.setRegistryName(key)));
                return true;
            }
            catch (JsonParseException e) {
                FMLLog.log.error("Parsing error loading recipe {}", (Object)key, (Object)e);
                return false;
            }
            catch (IOException e) {
                FMLLog.log.error("Couldn't read recipe {} from {}", (Object)key, file, (Object)e);
                return false;
            }
        }, true, true);
    }

    @Deprecated
    public static boolean findFiles(ModContainer mod, String base, Function<Path, Boolean> preprocessor, BiFunction<Path, Path, Boolean> processor) {
        return CraftingHelper.findFiles(mod, base, preprocessor, processor, false, false);
    }

    @Deprecated
    public static boolean findFiles(ModContainer mod, String base, Function<Path, Boolean> preprocessor, BiFunction<Path, Path, Boolean> processor, boolean defaultUnfoundRoot) {
        return CraftingHelper.findFiles(mod, base, preprocessor, processor, defaultUnfoundRoot, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean findFiles(ModContainer mod, String base, Function<Path, Boolean> preprocessor, BiFunction<Path, Path, Boolean> processor, boolean defaultUnfoundRoot, boolean visitAllFiles) {
        boolean success;
        FileSystem fs;
        block19: {
            Iterator itr;
            Path root;
            block18: {
                Boolean cont;
                block17: {
                    File source = mod.getSource();
                    if ("minecraft".equals(mod.getModId())) {
                        return true;
                    }
                    fs = null;
                    success = true;
                    root = null;
                    if (source.isFile()) {
                        try {
                            fs = FileSystems.newFileSystem(source.toPath(), (ClassLoader)null);
                            root = fs.getPath("/" + base, new String[0]);
                        }
                        catch (IOException e) {
                            FMLLog.log.error("Error loading FileSystem from jar: ", (Throwable)e);
                            boolean bl2 = false;
                            IOUtils.closeQuietly((Closeable)fs);
                            return bl2;
                        }
                    } else if (source.isDirectory()) {
                        root = source.toPath().resolve(base);
                    }
                    if (root != null && Files.exists(root, new LinkOption[0])) break block17;
                    boolean e = defaultUnfoundRoot;
                    IOUtils.closeQuietly((Closeable)fs);
                    return e;
                }
                if (preprocessor == null || (cont = preprocessor.apply(root)) != null && cont.booleanValue()) break block18;
                boolean bl3 = false;
                IOUtils.closeQuietly((Closeable)fs);
                return bl3;
            }
            try {
                if (processor == null) break block19;
                itr = null;
                try {
                    itr = Files.walk(root, new FileVisitOption[0]).iterator();
                }
                catch (IOException e) {
                    FMLLog.log.error("Error iterating filesystem for: {}", (Object)mod.getModId(), (Object)e);
                    boolean bl4 = false;
                    IOUtils.closeQuietly((Closeable)fs);
                    return bl4;
                }
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fs);
                throw throwable;
            }
            while (true) {
                block20: {
                    if (itr == null || !itr.hasNext()) break;
                    Boolean cont = processor.apply(root, (Path)itr.next());
                    if (visitAllFiles) {
                        success &= cont != null && cont != false;
                        break block20;
                    }
                    if (cont != null && cont.booleanValue()) break block20;
                    boolean bl5 = false;
                    IOUtils.closeQuietly((Closeable)fs);
                    return bl5;
                }
                continue;
                break;
            }
        }
        IOUtils.closeQuietly((Closeable)fs);
        return success;
    }

    public static JsonContext loadContext(nf path) throws IOException {
        ModContainer mod = Loader.instance().activeModContainer();
        if (mod == null) {
            throw new IllegalStateException("No active mod container");
        }
        return CraftingHelper.loadContext(path, mod);
    }

    public static JsonContext loadContext(nf path, ModContainer mod) throws IOException {
        return CraftingHelper.loadContext(mod, new JsonContext(mod.getModId()), path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static JsonContext loadContext(JsonContext ctx, File file) throws IOException {
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            JsonObject[] json = (JsonObject[])rc.a((Gson)GSON, (Reader)reader, JsonObject[].class);
            ctx.loadConstants(json);
            JsonContext jsonContext = ctx;
            return jsonContext;
        }
        catch (IOException e) {
            throw new IOException("Error loading constants from file: " + file.getAbsolutePath(), e);
        }
    }

    private static JsonContext loadContext(ModContainer mod, JsonContext ctx, nf path) throws IOException {
        Path fPath = null;
        if (mod.getSource().isFile()) {
            try (FileSystem fs = FileSystems.newFileSystem(mod.getSource().toPath(), (ClassLoader)null);){
                fPath = fs.getPath("assets", path.b(), path.a());
            }
        } else if (mod.getSource().isDirectory()) {
            fPath = mod.getSource().toPath().resolve(Paths.get("assets", path.b(), path.a()));
        }
        if (fPath != null && Files.exists(fPath, new LinkOption[0])) {
            return CraftingHelper.loadContext(ctx, fPath.toFile());
        }
        throw new FileNotFoundException(fPath != null ? fPath.toString() : path.toString());
    }

    static {
        CraftingHelper.init();
        INGREDIENTS = new FactoryLoader<IIngredientFactory>("ingredients", IIngredientFactory.class, CraftingHelper::register);
        RECIPES = new FactoryLoader<IRecipeFactory>("recipes", IRecipeFactory.class, CraftingHelper::register);
        CONDITIONS = new FactoryLoader<IConditionFactory>("conditions", IConditionFactory.class, CraftingHelper::register);
    }

    public static final class FactoryLoader<T> {
        final String name;
        final Class<T> type;
        final BiConsumer<nf, T> consumer;

        FactoryLoader(String name, Class<T> type, BiConsumer<nf, T> consumer) {
            this.name = name;
            this.type = type;
            this.consumer = consumer;
        }
    }

    public static class ShapedPrimer {
        public int height;
        public int width;
        public boolean mirrored = true;
        public fi<akq> input;
    }
}

