/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.event.entity.player;

import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.relauncher.Side;

public class PlayerInteractEvent
extends PlayerEvent {
    private final ub hand;
    private final et pos;
    @Nullable
    private final fa face;
    private ud cancellationResult = ud.b;
    public boolean isVanilla = false;

    private PlayerInteractEvent(aed player, ub hand, et pos, @Nullable fa face) {
        super((aed)Preconditions.checkNotNull((Object)player, (Object)"Null player in PlayerInteractEvent!"));
        this.hand = (ub)Preconditions.checkNotNull((Object)hand, (Object)"Null hand in PlayerInteractEvent!");
        this.pos = (et)Preconditions.checkNotNull((Object)pos, (Object)"Null position in PlayerInteractEvent!");
        this.face = face;
    }

    @Nonnull
    public ub getHand() {
        return this.hand;
    }

    @Nonnull
    public aip getItemStack() {
        return this.getEntityPlayer().b(this.hand);
    }

    @Nonnull
    public et getPos() {
        return this.pos;
    }

    @Nullable
    public fa getFace() {
        return this.face;
    }

    public amu getWorld() {
        return this.getEntityPlayer().e();
    }

    public Side getSide() {
        return this.getWorld().G ? Side.CLIENT : Side.SERVER;
    }

    public ud getCancellationResult() {
        return this.cancellationResult;
    }

    public void setCancellationResult(ud result) {
        this.cancellationResult = result;
    }

    public static class LeftClickEmpty
    extends PlayerInteractEvent {
        public LeftClickEmpty(aed player) {
            super(player, ub.a, new et((vg)player), null);
        }
    }

    @Cancelable
    public static class LeftClickBlock
    extends PlayerInteractEvent {
        private Event.Result useBlock = Event.Result.DEFAULT;
        private Event.Result useItem = Event.Result.DEFAULT;
        private final bhe hitVec;

        public LeftClickBlock(aed player, et pos, fa face, bhe hitVec) {
            super(player, ub.a, pos, face);
            this.hitVec = hitVec;
        }

        public bhe getHitVec() {
            return this.hitVec;
        }

        public Event.Result getUseBlock() {
            return this.useBlock;
        }

        public Event.Result getUseItem() {
            return this.useItem;
        }

        public void setUseBlock(Event.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(Event.Result triggerItem) {
            this.useItem = triggerItem;
        }

        @Override
        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = Event.Result.DENY;
                this.useItem = Event.Result.DENY;
            }
        }
    }

    public static class RightClickEmpty
    extends PlayerInteractEvent {
        public RightClickEmpty(aed player, ub hand) {
            super(player, hand, new et((vg)player), null);
        }
    }

    @Cancelable
    public static class RightClickItem
    extends PlayerInteractEvent {
        public RightClickItem(aed player, ub hand) {
            super(player, hand, new et((vg)player), null);
        }
    }

    @Cancelable
    public static class RightClickBlock
    extends PlayerInteractEvent {
        private Event.Result useBlock = Event.Result.DEFAULT;
        private Event.Result useItem = Event.Result.DEFAULT;
        private final bhe hitVec;

        public RightClickBlock(aed player, ub hand, et pos, fa face, bhe hitVec) {
            super(player, hand, pos, face);
            this.hitVec = hitVec;
        }

        public bhe getHitVec() {
            return this.hitVec;
        }

        public Event.Result getUseBlock() {
            return this.useBlock;
        }

        public Event.Result getUseItem() {
            return this.useItem;
        }

        public void setUseBlock(Event.Result triggerBlock) {
            this.useBlock = triggerBlock;
        }

        public void setUseItem(Event.Result triggerItem) {
            this.useItem = triggerItem;
        }

        @Override
        public void setCanceled(boolean canceled) {
            super.setCanceled(canceled);
            if (canceled) {
                this.useBlock = Event.Result.DENY;
                this.useItem = Event.Result.DENY;
            }
        }
    }

    @Cancelable
    public static class EntityInteract
    extends PlayerInteractEvent {
        private final vg target;

        public EntityInteract(aed player, ub hand, vg target) {
            super(player, hand, new et(target), null);
            this.target = target;
        }

        public vg getTarget() {
            return this.target;
        }
    }

    @Cancelable
    public static class EntityInteractSpecific
    extends PlayerInteractEvent {
        private final bhe localPos;
        private final vg target;

        public EntityInteractSpecific(aed player, ub hand, vg target, bhe localPos) {
            super(player, hand, new et(target), null);
            this.localPos = localPos;
            this.target = target;
        }

        public bhe getLocalPos() {
            return this.localPos;
        }

        public vg getTarget() {
            return this.target;
        }
    }
}

