/*
 * Decompiled with CFR 0.152.
 */
package org.spigotmc;

import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

public class TicksPerSecondCommand
extends Command {
    public TicksPerSecondCommand(String name) {
        super(name);
        this.description = "Gets the current ticks per second for the server";
        this.usageMessage = "/tps";
        this.setPermission("bukkit.command.tps");
    }

    @Override
    public boolean execute(CommandSender sender, String currentAlias, String[] args) {
        if (!this.testPermission(sender)) {
            return true;
        }
        double[] tps = Bukkit.getTPS();
        Object[] tpsAvg = new String[tps.length];
        for (int i2 = 0; i2 < tps.length; ++i2) {
            tpsAvg[i2] = TicksPerSecondCommand.format(tps[i2]);
        }
        sender.sendMessage((Object)((Object)ChatColor.GOLD) + "TPS from last 1m, 5m, 15m: " + StringUtils.join((Object[])tpsAvg, (String)", "));
        return true;
    }

    private static String format(double tps) {
        return (tps > 18.0 ? ChatColor.GREEN : (tps > 16.0 ? ChatColor.YELLOW : ChatColor.RED)).toString() + (tps > 20.0 ? "*" : "") + Math.min((double)Math.round(tps * 100.0) / 100.0, 20.0);
    }
}

